/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.archive;

import java.io.IOException;
import java.util.Locale;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.func.archive.ArchiveFn;
import org.basex.query.func.archive.ArchiveIn;
import org.basex.query.func.archive.ArchiveOut;
import org.basex.query.func.archive.GZIPIn;
import org.basex.query.iter.Iter;
import org.basex.query.value.item.B64;
import org.basex.query.value.item.Item;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.hash.TokenObjMap;

public final class ArchiveDelete
extends ArchiveFn {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Item item(QueryContext qc, InputInfo ii) throws QueryException {
        Object en;
        this.checkCreate(qc);
        B64 archive = this.toB64(this.exprs[0], qc, false);
        TokenObjMap hm = new TokenObjMap();
        Iter names = this.exprs[1].iter(qc);
        while ((en = qc.next(names)) != null) {
            hm.put(this.checkElemToken((Item)en).string(this.info), null);
        }
        try {
            en = null;
            Object var7_9 = null;
            try {
                ArchiveIn in = ArchiveIn.get(archive.input(this.info), this.info);
                try {
                    B64 b64;
                    block20: {
                        ArchiveOut out = ArchiveOut.get(in.format(), this.info);
                        try {
                            if (in instanceof GZIPIn) {
                                throw QueryError.ARCHIVE_MODIFY_X.get(this.info, in.format().toUpperCase(Locale.ENGLISH));
                            }
                            while (true) {
                                if (!in.more()) {
                                    b64 = B64.get(out.finish());
                                    return b64;
                                }
                                if (hm.contains(Token.token(in.entry().getName()))) continue;
                                out.write(in);
                            }
                        }
                        finally {
                            if (out == null) break block20;
                            out.close();
                        }
                    }
                    if (in != null) {
                        in.close();
                    }
                    return b64;
                }
                catch (Throwable throwable) {
                    if (en == null) {
                        en = throwable;
                    } else if (en != throwable) {
                        ((Throwable)en).addSuppressed(throwable);
                    }
                    if (in == null) throw en;
                    in.close();
                    throw en;
                }
            }
            catch (Throwable throwable) {
                if (en == null) {
                    en = throwable;
                    throw en;
                }
                if (en == throwable) throw en;
                ((Throwable)en).addSuppressed(throwable);
                throw en;
            }
        }
        catch (IOException ex) {
            throw QueryError.ARCHIVE_ERROR_X.get(this.info, ex);
        }
    }
}

