/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.archive;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Locale;
import java.util.zip.ZipEntry;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.func.archive.ArchOptions;
import org.basex.query.func.archive.ArchiveFn;
import org.basex.query.func.archive.ArchiveOut;
import org.basex.query.func.archive.ArchiveText;
import org.basex.query.func.archive.GZIPOut;
import org.basex.query.iter.Iter;
import org.basex.query.value.item.B64;
import org.basex.query.value.item.Bin;
import org.basex.query.value.item.Dtm;
import org.basex.query.value.item.Item;
import org.basex.query.value.node.ANode;
import org.basex.util.InputInfo;
import org.basex.util.Prop;
import org.basex.util.Strings;
import org.basex.util.Token;
import org.basex.util.Util;

public class ArchiveCreate
extends ArchiveFn {
    @Override
    public Item item(QueryContext qc, InputInfo ii) throws QueryException {
        Iter entries = this.exprs[0].iter(qc);
        Iter contents = this.exprs[1].iter(qc);
        ArchOptions opts = this.toOptions(2, new ArchOptions(), qc);
        String format = opts.get(ArchOptions.FORMAT);
        int level = this.level(opts);
        Throwable throwable = null;
        Object var9_10 = null;
        try (ArchiveOut out = ArchiveOut.get(format.toLowerCase(Locale.ENGLISH), this.info);){
            out.level(level);
            try {
                int e = 0;
                int c = 0;
                while (true) {
                    Item en = qc.next(entries);
                    Item cn = contents.next();
                    if (en == null || cn == null) {
                        if (cn != null) {
                            do {
                                ++c;
                            } while (contents.next() != null);
                        }
                        if (en != null) {
                            do {
                                ++e;
                            } while (entries.next() != null);
                        }
                        if (e != c) {
                            throw QueryError.ARCHIVE_NUMBER_X_X.get(this.info, e, c);
                        }
                        break;
                    }
                    if (out instanceof GZIPOut && c > 0) {
                        throw QueryError.ARCHIVE_SINGLE_X.get(this.info, format.toUpperCase(Locale.ENGLISH));
                    }
                    this.add(this.checkElemToken(en), cn, out, level, qc);
                    ++e;
                    ++c;
                }
            }
            catch (IOException ex) {
                throw QueryError.ARCHIVE_ERROR_X.get(this.info, ex);
            }
            return B64.get(out.finish());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    protected int level(ArchOptions options) throws QueryException {
        int level = 8;
        String format = options.get(ArchOptions.FORMAT);
        String alg = options.get(ArchOptions.ALGORITHM);
        if (alg != null) {
            if (format.equals("zip") && !Strings.eq(alg, "stored", "deflate") || format.equals("gzip") && !Strings.eq(alg, "deflate")) {
                throw QueryError.ARCHIVE_FORMAT_X_X.get(this.info, ArchOptions.ALGORITHM.name(), alg);
            }
            if (Strings.eq(alg, "stored")) {
                level = 0;
            } else if (Strings.eq(alg, "deflate")) {
                level = 8;
            }
        }
        return level;
    }

    protected final void add(Item entry, Item content, ArchiveOut out, int level, QueryContext qc) throws QueryException, IOException {
        String name = Token.string(entry.string(this.info));
        if (name.isEmpty()) {
            throw QueryError.ARCHIVE_DESCRIPTOR1.get(this.info, new Object[0]);
        }
        if (Prop.WIN) {
            name = name.replace('\\', '/');
        }
        ZipEntry ze = new ZipEntry(name);
        String enc = "UTF-8";
        byte[] lvl = null;
        if (entry instanceof ANode) {
            byte[] ea;
            ANode el = (ANode)entry;
            lvl = el.attribute(ArchiveText.LEVEL);
            byte[] mod = el.attribute(ArchiveText.LAST_MODIFIED);
            if (mod != null) {
                try {
                    ze.setTime(this.dateTimeToMs(new Dtm(mod, this.info), qc));
                }
                catch (QueryException qe) {
                    Util.debug(qe);
                    throw QueryError.ARCHIVE_DESCRIPTOR3_X.get(this.info, new Object[]{mod});
                }
            }
            if ((ea = el.attribute(ArchiveText.ENCODING)) != null && !Charset.isSupported(enc = Strings.normEncoding(Token.string(ea)))) {
                throw QueryError.ARCHIVE_ENCODE1_X.get(this.info, new Object[]{ea});
            }
        }
        byte[] val = this.toBytes(content);
        if (!(content instanceof Bin) && enc != "UTF-8") {
            val = this.encode(val, enc, qc);
        }
        try {
            out.level(lvl == null ? level : Token.toInt(lvl));
        }
        catch (IllegalArgumentException ex) {
            Util.debug(ex);
            throw QueryError.ARCHIVE_DESCRIPTOR2_X.get(this.info, new Object[]{lvl});
        }
        out.write(ze, val);
    }
}

