/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func;

import java.lang.reflect.Method;
import org.basex.core.users.Perm;
import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryModule;
import org.basex.query.StaticContext;
import org.basex.query.expr.Expr;
import org.basex.query.func.JavaFunction;
import org.basex.query.func.JavaMapping;
import org.basex.query.util.Flag;
import org.basex.query.value.Value;
import org.basex.query.value.node.FElem;
import org.basex.query.value.type.Type;
import org.basex.query.var.Var;
import org.basex.util.Array;
import org.basex.util.InputInfo;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;
import org.basex.util.hash.IntObjMap;

final class JavaModuleFunc
extends JavaFunction {
    private final Object module;
    private final Method method;
    private final Class<?>[] params;
    private final boolean[] vTypes;

    JavaModuleFunc(StaticContext sc, InputInfo info, Object module, Method method, Expr[] args, Perm perm) {
        super(sc, info, args, perm);
        this.module = module;
        this.method = method;
        this.params = method.getParameterTypes();
        this.vTypes = JavaModuleFunc.values(this.params);
    }

    @Override
    public boolean isVacuous() {
        return this.method.getReturnType() == Void.TYPE;
    }

    @Override
    protected Object eval(Value[] args, QueryContext qc) throws QueryException {
        Object[] jargs;
        if (this.module instanceof QueryModule) {
            QueryModule mod = (QueryModule)this.module;
            mod.staticContext = this.sc;
            mod.queryContext = qc;
        }
        if ((jargs = JavaModuleFunc.javaArgs(this.params, this.vTypes, args, true)) != null) {
            try {
                return this.method.invoke(this.module, jargs);
            }
            catch (Exception ex) {
                Throwable th = Util.rootException(ex);
                if (th instanceof QueryException) {
                    throw ((QueryException)th).info(this.info);
                }
                throw QueryError.JAVAERROR_X_X_X.get(this.info, this.name(), JavaModuleFunc.foundArgs(args), th);
            }
        }
        TokenBuilder expect = new TokenBuilder();
        Class<?>[] classArray = this.method.getParameterTypes();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Type type;
            Class<?> param = classArray[n2];
            if (!expect.isEmpty()) {
                expect.add(", ");
            }
            expect.add((type = JavaMapping.type(param, false)) != null ? type.toString() : Util.className(param));
            ++n2;
        }
        String name = this.method.getName();
        throw QueryError.JAVAARGS_X_X_X.get(this.info, name, expect, JavaModuleFunc.foundArgs(args));
    }

    @Override
    public Expr copy(CompileContext cc, IntObjMap<Var> vm) {
        return new JavaModuleFunc(this.sc, this.info, this.module, this.method, JavaModuleFunc.copyAll((CompileContext)cc, vm, (Expr[])this.exprs), this.perm);
    }

    @Override
    public void plan(FElem plan) {
        JavaModuleFunc.addPlan(plan, this.planElem("name", this.name()), this.exprs);
    }

    @Override
    public String description() {
        return String.valueOf(this.name()) + " method";
    }

    private String name() {
        return String.valueOf(Util.className(this.module)) + ':' + this.method.getName();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof JavaModuleFunc)) {
            return false;
        }
        JavaModuleFunc j = (JavaModuleFunc)obj;
        return this.module.equals(j.module) && this.method.equals(j.method) && Array.equals(this.params, j.params) && super.equals(obj);
    }

    @Override
    public boolean has(Flag ... flags) {
        return Flag.NDT.in(flags) && this.method.getAnnotation(QueryModule.Deterministic.class) == null || (Flag.CTX.in(flags) || Flag.POS.in(flags)) && this.method.getAnnotation(QueryModule.FocusDependent.class) != null || super.has(flags);
    }

    @Override
    public String toString() {
        return String.valueOf(this.name()) + this.toString(", ");
    }
}

