/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func;

import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Arr;
import org.basex.query.expr.Expr;
import org.basex.query.func.XQFunction;
import org.basex.query.iter.Iter;
import org.basex.query.value.Value;
import org.basex.query.value.item.Item;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.type.SeqType;
import org.basex.util.InputInfo;

public abstract class FuncCall
extends Arr {
    boolean tailCall;

    FuncCall(InputInfo info, Expr[] exprs) {
        super(info, SeqType.ITEM_ZM, exprs);
    }

    abstract XQFunction evalFunc(QueryContext var1) throws QueryException;

    abstract Value[] evalArgs(QueryContext var1) throws QueryException;

    @Override
    public final void markTailCalls(CompileContext cc) {
        if (cc != null) {
            cc.info("mark as tail call: %", this);
        }
        this.tailCall = true;
    }

    @Override
    public final Item item(QueryContext qc, InputInfo ii) throws QueryException {
        return (Item)(this.tailCall ? FuncCall.invokeTail(this.evalFunc(qc), this.evalArgs(qc), true, qc, this.info) : FuncCall.invoke(this.evalFunc(qc), this.evalArgs(qc), true, qc, this.info));
    }

    @Override
    public final Value value(QueryContext qc) throws QueryException {
        return this.tailCall ? FuncCall.invokeTail(this.evalFunc(qc), this.evalArgs(qc), false, qc, this.info) : FuncCall.invoke(this.evalFunc(qc), this.evalArgs(qc), false, qc, this.info);
    }

    @Override
    public final Iter iter(QueryContext qc) throws QueryException {
        return this.value(qc).iter();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Value invoke(XQFunction fun, Value[] arg, boolean itm, QueryContext qc, InputInfo info) throws QueryException {
        XQFunction func = fun;
        Value[] args = arg;
        int fp = qc.stack.enterFrame(func.stackFrameSize());
        try {
            while (true) {
                Value ret = itm ? func.invItem(qc, info, args) : func.invValue(qc, info, args);
                func = qc.pollTailCall();
                if (func == null) {
                    Value value = ret;
                    return value;
                }
                qc.stack.reuseFrame(func.stackFrameSize());
                args = qc.pollTailArgs();
                continue;
                break;
            }
        }
        catch (QueryException ex) {
            throw ex.add(info);
        }
        finally {
            qc.stack.exitFrame(fp);
        }
    }

    private static Value invokeTail(XQFunction fun, Value[] arg, boolean itm, QueryContext qc, InputInfo info) throws QueryException {
        int calls = qc.tailCalls;
        int max = qc.maxCalls;
        if (max >= 0 && calls >= max) {
            qc.registerTailCall(fun, arg);
            return itm ? null : Empty.SEQ;
        }
        ++qc.tailCalls;
        int fp = qc.stack.enterFrame(fun.stackFrameSize());
        try {
            Value value = itm ? fun.invItem(qc, info, arg) : fun.invValue(qc, info, arg);
            return value;
        }
        catch (QueryException ex) {
            throw ex.add(info);
        }
        finally {
            qc.tailCalls = calls;
            qc.stack.exitFrame(fp);
        }
    }

    public static Item item(XQFunction fun, Value[] arg, QueryContext qc, InputInfo info) throws QueryException {
        return (Item)FuncCall.invoke(fun, arg, true, qc, info);
    }

    public static Value value(XQFunction fun, Value[] arg, QueryContext qc, InputInfo info) throws QueryException {
        return FuncCall.invoke(fun, arg, false, qc, info);
    }
}

