/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr.gflwor;

import java.util.ArrayList;
import java.util.Arrays;
import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryRTException;
import org.basex.query.expr.Arr;
import org.basex.query.expr.Expr;
import org.basex.query.expr.ParseExpr;
import org.basex.query.expr.gflwor.Clause;
import org.basex.query.expr.gflwor.GFLWOR;
import org.basex.query.expr.gflwor.OrderKey;
import org.basex.query.expr.gflwor.Where;
import org.basex.query.util.ASTVisitor;
import org.basex.query.util.Flag;
import org.basex.query.value.Value;
import org.basex.query.value.item.Dbl;
import org.basex.query.value.item.Flt;
import org.basex.query.value.item.Item;
import org.basex.query.value.node.FElem;
import org.basex.query.value.type.SeqType;
import org.basex.query.var.Var;
import org.basex.query.var.VarRef;
import org.basex.query.var.VarUsage;
import org.basex.util.Array;
import org.basex.util.BitArray;
import org.basex.util.InputInfo;
import org.basex.util.hash.IntObjMap;

public final class OrderBy
extends Clause {
    private VarRef[] refs;
    private final OrderKey[] keys;

    public OrderBy(VarRef[] refs, OrderKey[] keys, InputInfo info) {
        super(info, SeqType.ITEM_ZM, new Var[0]);
        this.refs = refs;
        this.keys = keys;
    }

    @Override
    GFLWOR.Eval eval(final GFLWOR.Eval sub) {
        return new GFLWOR.Eval(){
            private Value[][] tpls;
            private Integer[] perm;
            int pos;

            @Override
            public boolean next(QueryContext qc) throws QueryException {
                if (this.tpls == null) {
                    this.sort(qc);
                }
                if (this.pos == this.tpls.length) {
                    return false;
                }
                int p = this.perm[this.pos++];
                Value[] tuple = this.tpls[p];
                this.tpls[p] = null;
                int rl = OrderBy.this.refs.length;
                int r = 0;
                while (r < rl) {
                    qc.set(((OrderBy)OrderBy.this).refs[r].var, tuple[r]);
                    ++r;
                }
                return true;
            }

            private void sort(QueryContext qc) throws QueryException {
                ArrayList<Value[]> tuples = new ArrayList<Value[]>();
                while (sub.next(qc)) {
                    int kl = OrderBy.this.keys.length;
                    Item[] key = new Item[kl];
                    int k = 0;
                    while (k < kl) {
                        key[k] = ((OrderBy)OrderBy.this).keys[k].expr.atomItem(qc, ((OrderBy)OrderBy.this).keys[k].info);
                        ++k;
                    }
                    tuples.add(key);
                    int rl = OrderBy.this.refs.length;
                    Value[] vals = new Value[rl];
                    int r = 0;
                    while (r < rl) {
                        vals[r] = OrderBy.this.refs[r].value(qc);
                        ++r;
                    }
                    tuples.add(vals);
                }
                int len = tuples.size() >>> 1;
                Item[][] ks = new Item[len][];
                this.perm = new Integer[len];
                this.tpls = new Value[len][];
                int i = 0;
                while (i < len) {
                    this.perm[i] = i;
                    this.tpls[i] = (Value[])tuples.get(i << 1 | 1);
                    ks[i] = (Item[])tuples.get(i << 1);
                    ++i;
                }
                tuples = null;
                try {
                    Arrays.sort(this.perm, (x, y) -> {
                        try {
                            Item[] a = ks[x];
                            Item[] b = ks[y];
                            int kl = OrderBy.this.keys.length;
                            int k = 0;
                            while (k < kl) {
                                int c;
                                OrderKey key = OrderBy.this.keys[k];
                                Item m = a[k];
                                Item n = b[k];
                                if (m == Dbl.NAN || m == Flt.NAN) {
                                    m = null;
                                }
                                if (n == Dbl.NAN || n == Flt.NAN) {
                                    n = null;
                                }
                                if (m != null && n != null && !m.comparable(n)) {
                                    throw QueryError.typeError(n, m.type, key.info);
                                }
                                int n2 = m == null ? (n == null ? 0 : (key.least ? -1 : 1)) : (n == null ? (key.least ? 1 : -1) : (c = m.diff(n, key.coll, key.info)));
                                if (c != 0) {
                                    return key.desc ? -c : c;
                                }
                                ++k;
                            }
                            return 0;
                        }
                        catch (QueryException ex) {
                            throw new QueryRTException(ex);
                        }
                    });
                }
                catch (QueryRTException ex) {
                    throw ex.getCause();
                }
            }
        };
    }

    @Override
    public boolean has(Flag ... flags) {
        OrderKey[] orderKeyArray = this.keys;
        int n = this.keys.length;
        int n2 = 0;
        while (n2 < n) {
            OrderKey key = orderKeyArray[n2];
            if (key.has(flags)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public OrderBy compile(CompileContext cc) throws QueryException {
        OrderKey[] orderKeyArray = this.keys;
        int n = this.keys.length;
        int n2 = 0;
        while (n2 < n) {
            OrderKey key = orderKeyArray[n2];
            key.compile(cc);
            ++n2;
        }
        return this;
    }

    @Override
    public OrderBy optimize(CompileContext cc) {
        return this;
    }

    @Override
    public boolean removable(Var var) {
        OrderKey[] orderKeyArray = this.keys;
        int n = this.keys.length;
        int n2 = 0;
        while (n2 < n) {
            OrderKey key = orderKeyArray[n2];
            if (!key.removable(var)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    @Override
    public VarUsage count(Var var) {
        return VarUsage.sum(var, this.keys);
    }

    @Override
    public Clause inline(Var var, Expr ex, CompileContext cc) throws QueryException {
        int r = this.refs.length;
        while (--r >= 0) {
            if (!var.is(this.refs[r].var)) continue;
            this.refs = Array.delete(this.refs, r);
        }
        return OrderBy.inlineAll(this.keys, var, ex, cc) ? this.optimize(cc) : null;
    }

    @Override
    public OrderBy copy(CompileContext cc, IntObjMap<Var> vm) {
        return this.copyType(new OrderBy((VarRef[])Arr.copyAll((CompileContext)cc, vm, (Expr[])this.refs), (OrderKey[])Arr.copyAll((CompileContext)cc, vm, (Expr[])this.keys), this.info));
    }

    @Override
    public boolean accept(ASTVisitor visitor) {
        return OrderBy.visitAll(visitor, this.keys);
    }

    @Override
    boolean clean(IntObjMap<Var> decl, BitArray used) {
        int len = this.refs.length;
        int r = this.refs.length;
        while (--r >= 0) {
            if (used.get(this.refs[r].var.id)) continue;
            this.refs = Array.delete(this.refs, r);
        }
        if (this.refs.length == used.cardinality()) {
            return this.refs.length != len;
        }
        int id = used.nextSet(0);
        while (id >= 0) {
            block5: {
                VarRef[] varRefArray = this.refs;
                int n = this.refs.length;
                int n2 = 0;
                while (n2 < n) {
                    VarRef ref = varRefArray[n2];
                    if (ref.var.id != id) {
                        ++n2;
                        continue;
                    }
                    break block5;
                }
                this.refs = Array.add(this.refs, new VarRef(this.info, decl.get(id)));
            }
            id = used.nextSet(id + 1);
        }
        return true;
    }

    @Override
    boolean skippable(Clause cl) {
        return cl instanceof Where;
    }

    @Override
    public void checkUp() throws QueryException {
        this.checkNoneUp(this.keys);
    }

    @Override
    public int exprSize() {
        int size = 0;
        ParseExpr[] parseExprArray = this.refs;
        int n = this.refs.length;
        int n2 = 0;
        while (n2 < n) {
            VarRef ref = parseExprArray[n2];
            size += ((Expr)ref).exprSize();
            ++n2;
        }
        parseExprArray = this.keys;
        n = this.keys.length;
        n2 = 0;
        while (n2 < n) {
            ParseExpr key = parseExprArray[n2];
            size += key.exprSize();
            ++n2;
        }
        return size;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof OrderBy)) {
            return false;
        }
        OrderBy o = (OrderBy)obj;
        return Array.equals(this.refs, o.refs) && Array.equals(this.keys, o.keys);
    }

    @Override
    public void plan(FElem plan) {
        FElem elem = this.planElem(new Object[0]);
        OrderKey[] orderKeyArray = this.keys;
        int n = this.keys.length;
        int n2 = 0;
        while (n2 < n) {
            OrderKey key = orderKeyArray[n2];
            key.plan(elem);
            ++n2;
        }
        plan.add(elem);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("order").append(' ').append("by");
        int kl = this.keys.length;
        int k = 0;
        while (k < kl) {
            sb.append(k == 0 ? " " : ", ").append(this.keys[k]);
            ++k;
        }
        return sb.toString();
    }
}

