/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr.ft;

import org.basex.core.MainOptions;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.expr.ft.FTTokens;
import org.basex.query.expr.ft.FTWildcard;
import org.basex.query.util.ft.FTMatches;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.ft.FTBitapSearch;
import org.basex.util.ft.FTFlag;
import org.basex.util.ft.FTIterator;
import org.basex.util.ft.FTLexer;
import org.basex.util.ft.FTOpt;
import org.basex.util.hash.TokenObjMap;
import org.basex.util.list.TokenList;
import org.basex.util.similarity.Levenshtein;

final class FTTokenizer {
    final FTBitapSearch.TokenComparator cmp;
    private final TokenObjMap<FTWildcard> wcCache = new TokenObjMap();
    private final TokenObjMap<FTTokens> cache = new TokenObjMap();
    private final InputInfo info;
    private final FTOpt opt;
    FTMatches matches = new FTMatches();
    boolean first;
    int pos;

    FTTokenizer(FTOpt opt, QueryContext qc, InputInfo info) {
        this(opt, new Levenshtein(qc.context.options.get(MainOptions.LSERROR)), info);
    }

    private FTTokenizer(FTOpt opt, Levenshtein ls, InputInfo info) {
        this.opt = opt;
        this.info = info;
        this.cmp = (in, qu) -> {
            FTWildcard ftw = null;
            if (opt.is(FTFlag.WC)) {
                ftw = this.wcCache.get(qu);
                if (ftw == null) {
                    ftw = new FTWildcard(qu);
                    if (!ftw.parse()) {
                        throw QueryError.FTWILDCARD_X.get(info, new Object[]{qu});
                    }
                    this.wcCache.put(qu, ftw);
                }
                if (ftw.simple()) {
                    ftw = null;
                }
            }
            return fTOpt.sw != null && fTOpt.sw.contains(qu) || !(opt.is(FTFlag.FZ) ? !ls.similar(in, qu) : (ftw != null ? !ftw.match(in) : !Token.eq(in, qu)));
        };
    }

    FTTokens cache(byte[] query) throws QueryException {
        FTTokens tokens = this.cache.get(query);
        if (tokens == null) {
            tokens = new FTTokens();
            this.cache.put(query, tokens);
            FTLexer quLex = new FTLexer(this.opt).init(query);
            TokenList quList = new TokenList(1);
            while (quLex.hasNext()) {
                quList.add(((FTIterator)quLex).nextToken());
            }
            tokens.add(quList);
            if (this.opt.th != null) {
                byte[][] byArray = this.opt.th.find(this.info, query);
                int n = byArray.length;
                int n2 = 0;
                while (n2 < n) {
                    byte[] ext = byArray[n2];
                    TokenList tl = new TokenList(1);
                    ((FTIterator)quLex).init(ext);
                    while (quLex.hasNext()) {
                        tl.add(((FTIterator)quLex).nextToken());
                    }
                    tokens.add(tl);
                    ++n2;
                }
            }
        }
        return tokens;
    }
}

