/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr.ft;

import org.basex.index.IndexType;
import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.expr.Single;
import org.basex.query.expr.ft.FTExpr;
import org.basex.query.expr.ft.FTIndexAccess;
import org.basex.query.func.fn.FnBoolean;
import org.basex.query.iter.Iter;
import org.basex.query.util.ASTVisitor;
import org.basex.query.util.Flag;
import org.basex.query.util.IndexInfo;
import org.basex.query.util.ft.FTMatches;
import org.basex.query.util.ft.FTPosData;
import org.basex.query.value.item.Bln;
import org.basex.query.value.item.Item;
import org.basex.query.value.node.DBNode;
import org.basex.query.value.node.FElem;
import org.basex.query.value.node.FTNode;
import org.basex.query.value.type.SeqType;
import org.basex.query.var.Var;
import org.basex.query.var.VarUsage;
import org.basex.util.InputInfo;
import org.basex.util.Util;
import org.basex.util.ft.FTLexer;
import org.basex.util.ft.FTOpt;
import org.basex.util.ft.Scoring;
import org.basex.util.hash.IntObjMap;

public final class FTContains
extends Single {
    public FTExpr ftexpr;

    public FTContains(Expr expr, FTExpr ftexpr, InputInfo info) {
        super(info, expr, SeqType.BLN_O);
        this.ftexpr = ftexpr;
    }

    @Override
    public Bln item(QueryContext qc, InputInfo ii) throws QueryException {
        FTLexer lexer;
        boolean scoring = qc.scoring;
        Iter iter = this.expr.iter(qc);
        FTLexer tmp = qc.ftLexer;
        qc.ftLexer = lexer = new FTLexer(new FTOpt());
        try {
            Item item;
            double score = 0.0;
            int c = 0;
            boolean f = false;
            FTPosData ftPosData = qc.ftPosData;
            while ((item = qc.next(iter)) != null) {
                lexer.init(item.string(this.info));
                FTNode it = this.ftexpr.item(qc, this.info);
                FTMatches all = it.matches();
                if (all.matches()) {
                    f = true;
                    if (scoring) {
                        score += it.score();
                    }
                    if (ftPosData != null && item instanceof DBNode) {
                        DBNode node = (DBNode)item;
                        ftPosData.add(node.data(), node.pre(), all);
                    }
                }
                ++c;
            }
            Bln bln = scoring ? Bln.get(f, Scoring.avg(score, c)) : Bln.get(f);
            return bln;
        }
        finally {
            qc.ftLexer = tmp;
        }
    }

    @Override
    public Expr compile(CompileContext cc) throws QueryException {
        super.compile(cc);
        this.ftexpr = this.ftexpr.compile(cc);
        return this.optimize(cc);
    }

    @Override
    public Expr optimize(CompileContext cc) {
        return this.expr.seqType().zero() ? FnBoolean.get(this.expr, this.info, cc.sc()) : this;
    }

    @Override
    public boolean has(Flag ... flags) {
        return super.has(flags) || this.ftexpr.has(flags);
    }

    @Override
    public boolean removable(Var var) {
        return super.removable(var) && this.ftexpr.removable(var);
    }

    @Override
    public VarUsage count(Var var) {
        return super.count(var).plus(this.ftexpr.count(var));
    }

    @Override
    public Expr inline(Var var, Expr ex, CompileContext cc) throws QueryException {
        FTExpr fte;
        Expr sub = this.expr.inline(var, ex, cc);
        if (sub != null) {
            this.expr = sub;
        }
        if ((fte = this.ftexpr.inline(var, ex, cc)) != null) {
            this.ftexpr = fte;
        }
        return sub != null || fte != null ? this.optimize(cc) : null;
    }

    @Override
    public boolean accept(ASTVisitor visitor) {
        return super.accept(visitor) && this.ftexpr.accept(visitor);
    }

    @Override
    public int exprSize() {
        return super.exprSize() + this.ftexpr.exprSize();
    }

    @Override
    public boolean indexAccessible(IndexInfo ii) throws QueryException {
        IndexType type = ii.type(this.expr, IndexType.FULLTEXT);
        if (type == null || !this.ftexpr.indexAccessible(ii)) {
            return false;
        }
        ii.create(new FTIndexAccess(this.info, this.ftexpr, ii.db), true, this.info, Util.info("apply % index for %", "full-text", this.ftexpr));
        return true;
    }

    @Override
    public Expr copy(CompileContext cc, IntObjMap<Var> vm) {
        return new FTContains(this.expr.copy(cc, vm), (FTExpr)this.ftexpr.copy(cc, (IntObjMap)vm), this.info);
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || obj instanceof FTContains && this.ftexpr.equals(((FTContains)obj).ftexpr) && super.equals(obj);
    }

    @Override
    public void plan(FElem plan) {
        FTContains.addPlan(plan, this.planElem(new Object[0]), this.expr, this.ftexpr);
    }

    @Override
    public String toString() {
        return this.expr + " " + "contains" + ' ' + "text" + ' ' + this.ftexpr;
    }
}

