/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import java.util.ArrayList;
import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Arr;
import org.basex.query.expr.Expr;
import org.basex.query.expr.ParseExpr;
import org.basex.query.expr.TypeswitchGroup;
import org.basex.query.iter.Iter;
import org.basex.query.util.ASTVisitor;
import org.basex.query.util.Flag;
import org.basex.query.value.Value;
import org.basex.query.value.node.FElem;
import org.basex.query.value.type.SeqType;
import org.basex.query.var.Var;
import org.basex.query.var.VarUsage;
import org.basex.util.Array;
import org.basex.util.InputInfo;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;
import org.basex.util.hash.IntObjMap;

public final class Typeswitch
extends ParseExpr {
    private TypeswitchGroup[] groups;
    private Expr cond;

    public Typeswitch(InputInfo info, Expr cond, TypeswitchGroup[] groups) {
        super(info, SeqType.ITEM_ZM);
        this.cond = cond;
        this.groups = groups;
    }

    @Override
    public void checkUp() throws QueryException {
        this.checkNoUp(this.cond);
        int gl = this.groups.length;
        Expr[] tmp = new Expr[gl];
        int g = 0;
        while (g < gl) {
            tmp[g] = this.groups[g].expr;
            ++g;
        }
        this.checkAllUp(tmp);
    }

    @Override
    public Expr compile(CompileContext cc) throws QueryException {
        this.cond = this.cond.compile(cc);
        TypeswitchGroup[] typeswitchGroupArray = this.groups;
        int n = this.groups.length;
        int n2 = 0;
        while (n2 < n) {
            TypeswitchGroup tg = typeswitchGroupArray[n2];
            tg.compile(cc);
            ++n2;
        }
        return this.optimize(cc);
    }

    @Override
    public Expr optimize(CompileContext cc) throws QueryException {
        int n;
        if (this.cond instanceof Value) {
            Value value = (Value)this.cond;
            TypeswitchGroup[] typeswitchGroupArray = this.groups;
            n = this.groups.length;
            int n2 = 0;
            while (n2 < n) {
                TypeswitchGroup tg = typeswitchGroupArray[n2];
                if (tg.matches(value)) {
                    tg.opt(cc, value);
                    return cc.replaceWith(this, tg.expr);
                }
                ++n2;
            }
        }
        ArrayList<SeqType> types = new ArrayList<SeqType>();
        ArrayList<TypeswitchGroup> newGroups = new ArrayList<TypeswitchGroup>(this.groups.length);
        TypeswitchGroup[] typeswitchGroupArray = this.groups;
        int n3 = this.groups.length;
        n = 0;
        while (n < n3) {
            TypeswitchGroup group = typeswitchGroupArray[n];
            if (group.removeTypes(cc, types)) {
                newGroups.add(group);
            }
            ++n;
        }
        if (this.groups.length != newGroups.size()) {
            this.groups = newGroups.toArray(new TypeswitchGroup[newGroups.size()]);
        }
        TypeswitchGroup tg = this.groups[0];
        boolean eq = tg.var == null;
        int gl = this.groups.length;
        int g = 1;
        while (eq && g < gl) {
            eq = tg.expr.equals(this.groups[g].expr);
            ++g;
        }
        if (eq) {
            return cc.replaceWith(this, tg.expr);
        }
        SeqType st = this.groups[0].seqType();
        int g2 = 1;
        while (g2 < gl) {
            st = st.union(this.groups[g2].seqType());
            ++g2;
        }
        this.exprType.assign(st);
        return this;
    }

    @Override
    public Iter iter(QueryContext qc) throws QueryException {
        Value seq = this.cond.value(qc);
        TypeswitchGroup[] typeswitchGroupArray = this.groups;
        int n = this.groups.length;
        int n2 = 0;
        while (n2 < n) {
            TypeswitchGroup tg = typeswitchGroupArray[n2];
            Iter iter = tg.iter(qc, seq);
            if (iter != null) {
                return iter;
            }
            ++n2;
        }
        throw Util.notExpected();
    }

    @Override
    public boolean isVacuous() {
        TypeswitchGroup[] typeswitchGroupArray = this.groups;
        int n = this.groups.length;
        int n2 = 0;
        while (n2 < n) {
            TypeswitchGroup tg = typeswitchGroupArray[n2];
            if (!tg.expr.isVacuous()) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    @Override
    public boolean has(Flag ... flags) {
        TypeswitchGroup[] typeswitchGroupArray = this.groups;
        int n = this.groups.length;
        int n2 = 0;
        while (n2 < n) {
            TypeswitchGroup tg = typeswitchGroupArray[n2];
            if (tg.has(flags)) {
                return true;
            }
            ++n2;
        }
        return this.cond.has(flags);
    }

    @Override
    public boolean removable(Var var) {
        TypeswitchGroup[] typeswitchGroupArray = this.groups;
        int n = this.groups.length;
        int n2 = 0;
        while (n2 < n) {
            TypeswitchGroup tg = typeswitchGroupArray[n2];
            if (!tg.removable(var)) {
                return false;
            }
            ++n2;
        }
        return this.cond.removable(var);
    }

    @Override
    public VarUsage count(Var var) {
        return this.cond.count(var).plus(VarUsage.maximum(var, this.groups));
    }

    @Override
    public Expr inline(Var var, Expr ex, CompileContext cc) throws QueryException {
        boolean changed = Typeswitch.inlineAll(this.groups, var, ex, cc);
        Expr c = this.cond.inline(var, ex, cc);
        if (c != null) {
            changed = true;
            this.cond = c;
        }
        return changed ? this.optimize(cc) : null;
    }

    @Override
    public void markTailCalls(CompileContext cc) {
        TypeswitchGroup[] typeswitchGroupArray = this.groups;
        int n = this.groups.length;
        int n2 = 0;
        while (n2 < n) {
            TypeswitchGroup tg = typeswitchGroupArray[n2];
            tg.markTailCalls(cc);
            ++n2;
        }
    }

    @Override
    public boolean accept(ASTVisitor visitor) {
        return this.cond.accept(visitor) && Typeswitch.visitAll(visitor, this.groups);
    }

    @Override
    public int exprSize() {
        int size = 1;
        TypeswitchGroup[] typeswitchGroupArray = this.groups;
        int n = this.groups.length;
        int n2 = 0;
        while (n2 < n) {
            TypeswitchGroup group = typeswitchGroupArray[n2];
            size += ((Expr)group).exprSize();
            ++n2;
        }
        return size + this.cond.exprSize();
    }

    @Override
    public Expr copy(CompileContext cc, IntObjMap<Var> vm) {
        return this.copyType(new Typeswitch(this.info, this.cond.copy(cc, vm), (TypeswitchGroup[])Arr.copyAll((CompileContext)cc, vm, (Expr[])this.groups)));
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Typeswitch)) {
            return false;
        }
        Typeswitch ts = (Typeswitch)obj;
        return this.cond.equals(ts.cond) && Array.equals(this.groups, ts.groups);
    }

    @Override
    public void plan(FElem plan) {
        Typeswitch.addPlan(plan, this.planElem(new Object[0]), new Object[]{this.groups, this.cond});
    }

    @Override
    public String toString() {
        return new TokenBuilder("typeswitch(" + this.cond + ")" + ' ').addSep(this.groups, " ").toString();
    }
}

