/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import java.util.ArrayList;
import java.util.Arrays;
import org.basex.data.Data;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.StaticContext;
import org.basex.query.ann.Annotation;
import org.basex.query.expr.Expr;
import org.basex.query.func.XQFunctionExpr;
import org.basex.query.iter.Iter;
import org.basex.query.util.Flag;
import org.basex.query.value.Value;
import org.basex.query.value.ValueBuilder;
import org.basex.query.value.array.Array;
import org.basex.query.value.item.ANum;
import org.basex.query.value.item.B64;
import org.basex.query.value.item.Bin;
import org.basex.query.value.item.Bln;
import org.basex.query.value.item.Dbl;
import org.basex.query.value.item.FItem;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.query.value.item.Str;
import org.basex.query.value.map.Map;
import org.basex.query.value.node.ANode;
import org.basex.query.value.node.FElem;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.ExprType;
import org.basex.query.value.type.NodeType;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Type;
import org.basex.util.InputInfo;
import org.basex.util.Token;

public abstract class ParseExpr
extends Expr {
    public final ExprType exprType;
    public InputInfo info;

    protected ParseExpr(InputInfo info, SeqType seqType) {
        this.info = info;
        this.exprType = new ExprType(seqType);
    }

    @Override
    public Iter iter(QueryContext qc) throws QueryException {
        Item item = this.item(qc, this.info);
        return item != null ? item.iter() : Empty.ITER;
    }

    @Override
    public Item item(QueryContext qc, InputInfo ii) throws QueryException {
        Item next;
        Iter iter = this.iter(qc);
        Item item = qc.next(iter);
        if (item != null && iter.size() != 1L && (next = iter.next()) != null) {
            ValueBuilder vb = new ValueBuilder(qc, item, next);
            if (iter.next() != null) {
                vb.add(Str.get("..."));
            }
            throw QueryError.SEQFOUND_X.get(this.info, vb.value());
        }
        return item;
    }

    @Override
    public Value value(QueryContext qc) throws QueryException {
        if (this.seqType().zeroOrOne()) {
            Item value = this.item(qc, this.info);
            return value == null ? Empty.SEQ : value;
        }
        return this.iter(qc).value(qc);
    }

    @Override
    public Value atomValue(QueryContext qc, InputInfo ii) throws QueryException {
        return this.value(qc).atomValue(qc, this.info);
    }

    @Override
    public final Item atomItem(QueryContext qc, InputInfo ii) throws QueryException {
        Item item = this.item(qc, this.info);
        return item == null ? null : item.atomItem(qc, this.info);
    }

    @Override
    public final Item ebv(QueryContext qc, InputInfo ii) throws QueryException {
        Item item;
        if (this.seqType().zeroOrOne()) {
            item = this.item(qc, this.info);
        } else {
            Item next;
            Iter iter = this.iter(qc);
            item = iter.next();
            if (item != null && !(item instanceof ANode) && (next = iter.next()) != null) {
                ValueBuilder vb = new ValueBuilder(qc, item, next);
                if (iter.next() != null) {
                    vb.add(Str.get("..."));
                }
                throw QueryError.EBV_X.get(this.info, vb.value());
            }
        }
        return item == null ? Bln.FALSE : item;
    }

    @Override
    public final Item test(QueryContext qc, InputInfo ii) throws QueryException {
        Item item = this.ebv(qc, this.info);
        return (item instanceof ANum ? item.dbl(this.info) == (double)qc.focus.pos : item.bool(this.info)) ? item : null;
    }

    @Override
    public final SeqType seqType() {
        return this.exprType.seqType();
    }

    @Override
    public final long size() {
        return this.exprType.size();
    }

    protected final <T extends ParseExpr> T copyType(T expr) {
        expr.exprType.assign(this);
        return expr;
    }

    public final ParseExpr adoptType(Expr expr) {
        this.exprType.assign(expr);
        return this;
    }

    protected <T extends XQFunctionExpr> T checkUp(T expr, boolean updating, StaticContext sc) throws QueryException {
        if (!sc.mixUpdates && updating != expr.annotations().contains(Annotation.UPDATING)) {
            if (!updating) {
                throw QueryError.FUNCUP_X.get(this.info, expr);
            }
            if (!expr.isVacuousBody()) {
                throw QueryError.FUNCNOTUP_X.get(this.info, expr);
            }
        }
        return expr;
    }

    protected void checkNoUp(Expr expr) throws QueryException {
        if (expr == null) {
            return;
        }
        expr.checkUp();
        if (expr.has(Flag.UPD)) {
            throw QueryError.UPNOT_X.get(this.info, this.description());
        }
    }

    protected final void checkNoneUp(Expr ... exprs) throws QueryException {
        if (exprs == null) {
            return;
        }
        this.checkAllUp(exprs);
        Expr[] exprArray = exprs;
        int n = exprs.length;
        int n2 = 0;
        while (n2 < n) {
            Expr expr = exprArray[n2];
            if (expr != null && expr.has(Flag.UPD)) {
                throw QueryError.UPNOT_X.get(this.info, this.description());
            }
            ++n2;
        }
    }

    protected void checkAllUp(Expr ... exprs) throws QueryException {
        int state = 0;
        Expr[] exprArray = exprs;
        int n = exprs.length;
        int n2 = 0;
        while (n2 < n) {
            Expr expr = exprArray[n2];
            expr.checkUp();
            if (!expr.isVacuous()) {
                boolean updating = expr.has(Flag.UPD);
                if (updating ? state == -1 : state == 1) {
                    throw QueryError.UPALL.get(this.info, new Object[0]);
                }
                state = updating ? 1 : -1;
            }
            ++n2;
        }
    }

    protected final Value ctxValue(QueryContext qc) throws QueryException {
        Value value = qc.focus.value;
        if (value != null) {
            return value;
        }
        throw QueryError.NOCTX_X.get(this.info, this);
    }

    protected final byte[] toToken(Expr expr, QueryContext qc) throws QueryException {
        Item item = expr.atomItem(qc, this.info);
        if (item == null) {
            throw QueryError.EMPTYFOUND_X.get(this.info, AtomType.STR);
        }
        return this.toToken(item);
    }

    protected final byte[] toEmptyToken(Expr expr, QueryContext qc) throws QueryException {
        Item item = expr.atomItem(qc, this.info);
        return item == null ? Token.EMPTY : this.toToken(item);
    }

    protected final byte[] toTokenOrNull(Expr expr, QueryContext qc) throws QueryException {
        Item item = expr.atomItem(qc, this.info);
        return item == null ? null : this.toToken(item);
    }

    protected final byte[] toToken(Item item) throws QueryException {
        Type type = item.type;
        if (type.isStringOrUntyped()) {
            return item.string(this.info);
        }
        throw item instanceof FItem ? QueryError.FIATOM_X.get(this.info, item.type) : QueryError.typeError(item, AtomType.STR, this.info);
    }

    protected final boolean toBoolean(Expr expr, QueryContext qc) throws QueryException {
        return this.toBoolean(expr.atomItem(qc, this.info));
    }

    protected final boolean toBoolean(Item item) throws QueryException {
        Type type = this.checkNoEmpty((Item)item, (Type)AtomType.BLN).type;
        if (type == AtomType.BLN) {
            return item.bool(this.info);
        }
        if (type.isUntyped()) {
            return Bln.parse(item, this.info);
        }
        throw QueryError.typeError(item, AtomType.BLN, this.info);
    }

    protected final double toDouble(Expr expr, QueryContext qc) throws QueryException {
        return this.toDouble(expr.atomItem(qc, this.info));
    }

    protected final double toDouble(Item item) throws QueryException {
        if (this.checkNoEmpty((Item)item, (Type)AtomType.DBL).type.isNumberOrUntyped()) {
            return item.dbl(this.info);
        }
        throw QueryError.numberError(this, item);
    }

    protected final ANum toNumber(Expr expr, QueryContext qc) throws QueryException {
        Item item = expr.atomItem(qc, this.info);
        return item == null ? null : this.toNumber(item);
    }

    protected ANum toNumber(Item item) throws QueryException {
        if (item.type.isUntyped()) {
            return Dbl.get(item.dbl(this.info));
        }
        if (item instanceof ANum) {
            return (ANum)item;
        }
        throw QueryError.numberError(this, item);
    }

    protected final float toFloat(Expr expr, QueryContext qc) throws QueryException {
        Item item = expr.atomItem(qc, this.info);
        if (this.checkNoEmpty((Item)item, (Type)AtomType.FLT).type.isNumberOrUntyped()) {
            return item.flt(this.info);
        }
        throw QueryError.numberError(this, item);
    }

    protected final long toLong(Expr expr, QueryContext qc) throws QueryException {
        return this.toLong(expr.atomItem(qc, this.info));
    }

    protected final long toLong(Item item) throws QueryException {
        Type type = this.checkNoEmpty((Item)item, (Type)AtomType.ITR).type;
        if (type.instanceOf(AtomType.ITR) || type.isUntyped()) {
            return item.itr(this.info);
        }
        throw QueryError.typeError(item, AtomType.ITR, this.info);
    }

    protected final ANode toNode(Expr expr, QueryContext qc) throws QueryException {
        return this.toNode(this.checkNoEmpty(expr.item(qc, this.info), NodeType.NOD));
    }

    protected final ANode toEmptyNode(Expr expr, QueryContext qc) throws QueryException {
        Item item = expr.item(qc, this.info);
        return item == null ? null : this.toNode(item);
    }

    protected final ANode toNode(Item item) throws QueryException {
        if (item instanceof ANode) {
            return (ANode)item;
        }
        throw QueryError.typeError(item, NodeType.NOD, this.info);
    }

    protected final ANode toEmptyNode(Item item) throws QueryException {
        return item == null ? null : this.toNode(item);
    }

    protected final Item toItem(Expr expr, QueryContext qc) throws QueryException {
        return this.checkNoEmpty(expr.item(qc, this.info));
    }

    protected final Item toItem(Expr expr, QueryContext qc, Type type) throws QueryException {
        return this.checkNoEmpty(expr.item(qc, this.info), type);
    }

    protected final Item toAtomItem(Expr expr, QueryContext qc) throws QueryException {
        return this.checkNoEmpty(expr.atomItem(qc, this.info));
    }

    protected final ANode toElem(Expr expr, QueryContext qc) throws QueryException {
        return (ANode)this.checkType(expr.item(qc, this.info), NodeType.ELM);
    }

    protected final Bin toBin(Expr expr, QueryContext qc) throws QueryException {
        return this.toBin(expr.atomItem(qc, this.info));
    }

    protected Bin toBin(Item item) throws QueryException {
        if (this.checkNoEmpty(item) instanceof Bin) {
            return (Bin)item;
        }
        throw QueryError.BINARY_X.get(this.info, item.type);
    }

    protected final byte[] toBytes(Expr expr, QueryContext qc) throws QueryException {
        return this.toBytes(expr.atomItem(qc, this.info));
    }

    protected final B64 toB64(Expr expr, QueryContext qc, boolean empty) throws QueryException {
        return this.toB64(expr.atomItem(qc, this.info), empty);
    }

    protected final B64 toB64(Item item, boolean empty) throws QueryException {
        if (empty && item == null) {
            return null;
        }
        return (B64)this.checkType(item, AtomType.B64);
    }

    protected final byte[] toBytes(Item item) throws QueryException {
        if (this.checkNoEmpty((Item)item).type.isStringOrUntyped()) {
            return item.string(this.info);
        }
        if (item instanceof Bin) {
            return ((Bin)item).binary(this.info);
        }
        throw QueryError.STRBIN_X_X.get(this.info, item.type, item);
    }

    protected final QNm toQNm(Expr expr, QueryContext qc, boolean empty) throws QueryException {
        return this.toQNm(expr.atomItem(qc, this.info), empty);
    }

    protected final QNm toQNm(Item item, boolean empty) throws QueryException {
        if (empty && item == null) {
            return null;
        }
        Type type = this.checkNoEmpty((Item)item, (Type)AtomType.QNM).type;
        if (type == AtomType.QNM) {
            return (QNm)item;
        }
        if (type.isUntyped()) {
            throw QueryError.NSSENS_X_X.get(this.info, type, AtomType.QNM);
        }
        throw QueryError.typeError(item, AtomType.QNM, this.info);
    }

    protected FItem toFunc(Expr expr, QueryContext qc) throws QueryException {
        return (FItem)this.checkType(this.toItem(expr, qc, SeqType.ANY_FUNC), SeqType.ANY_FUNC);
    }

    protected Map toMap(Expr expr, QueryContext qc) throws QueryException {
        return this.toMap(this.toItem(expr, qc, SeqType.ANY_MAP));
    }

    protected Map toMap(Item item) throws QueryException {
        if (item instanceof Map) {
            return (Map)item;
        }
        throw QueryError.typeError(item, SeqType.ANY_MAP, this.info);
    }

    protected Array toArray(Expr expr, QueryContext qc) throws QueryException {
        return this.toArray(this.toItem(expr, qc, SeqType.ANY_ARRAY));
    }

    protected Array toArray(Item item) throws QueryException {
        if (item instanceof Array) {
            return (Array)item;
        }
        throw QueryError.typeError(item, SeqType.ANY_ARRAY, this.info);
    }

    protected Item checkType(Expr expr, QueryContext qc, AtomType type) throws QueryException {
        return this.checkType(expr.atomItem(qc, this.info), type);
    }

    protected Item checkType(Item item, Type type) throws QueryException {
        if (this.checkNoEmpty((Item)item, (Type)type).type.instanceOf(type)) {
            return item;
        }
        throw QueryError.typeError(item, type, this.info);
    }

    protected final Item checkNoEmpty(Item item) throws QueryException {
        if (item != null) {
            return item;
        }
        throw QueryError.EMPTYFOUND.get(this.info, new Object[0]);
    }

    protected Item checkNoEmpty(Item item, Type type) throws QueryException {
        if (item != null) {
            return item;
        }
        throw QueryError.EMPTYFOUND_X.get(this.info, type);
    }

    @Override
    protected final FElem planElem(Object ... atts) {
        Data data;
        ArrayList<Object> tmp = new ArrayList<Object>(Arrays.asList(atts));
        if (!this.seqType().eq(SeqType.ITEM_ZM)) {
            tmp.add("type");
            tmp.add(this.seqType());
        }
        if (this.size() != -1L) {
            tmp.add("size");
            tmp.add(this.size());
        }
        if ((data = this.data()) != null) {
            tmp.add("database");
            tmp.add(data.meta.name);
        }
        return super.planElem(tmp.toArray());
    }
}

