/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.StaticContext;
import org.basex.query.expr.CmpG;
import org.basex.query.expr.Expr;
import org.basex.query.iter.Iter;
import org.basex.query.util.collation.Collation;
import org.basex.query.util.hash.HashItemSet;
import org.basex.query.value.Value;
import org.basex.query.value.item.Bln;
import org.basex.query.value.item.Item;
import org.basex.query.var.Var;
import org.basex.util.InputInfo;
import org.basex.util.hash.IntObjMap;

public final class CmpHashG
extends CmpG {
    private final ThreadLocal<CmpCache> caches = new ThreadLocal();

    public CmpHashG(Expr expr1, Expr expr2, CmpG.OpG op, Collation coll, StaticContext sc, InputInfo info) {
        super(expr1, expr2, op, coll, sc, info);
    }

    @Override
    public Expr optimize(CompileContext cc) throws QueryException {
        Expr expr = super.optimize(cc);
        if (expr instanceof Value) {
            this.caches.remove();
        }
        return expr;
    }

    @Override
    Bln compare(Iter iter1, Iter iter2, long is1, long is2, QueryContext qc) throws QueryException {
        Value value2 = iter2.value();
        if (value2 != null && value2.size() > 1L) {
            CmpCache cache = this.caches.get();
            if (cache == null) {
                cache = new CmpCache();
                this.caches.set(cache);
            }
            if (cache.active(value2, iter2)) {
                Item item1;
                HashItemSet set = cache.set;
                Iter ir2 = cache.iter;
                while ((item1 = qc.next(iter1)) != null) {
                    Item item2;
                    if (set.contains(item1, this.info)) {
                        CmpCache cmpCache = cache;
                        cmpCache.hits = cmpCache.hits + 1;
                        return Bln.TRUE;
                    }
                    if (ir2 == null) continue;
                    while ((item2 = qc.next(ir2)) != null) {
                        set.add(item2, this.info);
                        if (!set.contains(item1, this.info)) continue;
                        return Bln.TRUE;
                    }
                    cache.iter = null;
                    ir2 = null;
                }
                return Bln.FALSE;
            }
        }
        return super.compare(iter1, iter2, is1, is2, qc);
    }

    @Override
    public CmpG copy(CompileContext cc, IntObjMap<Var> vm) {
        return new CmpHashG(this.exprs[0].copy(cc, vm), this.exprs[1].copy(cc, vm), this.op, this.coll, this.sc, this.info);
    }

    @Override
    public String description() {
        return "hashed " + super.description();
    }

    private final class CmpCache {
        private HashItemSet set = new HashItemSet(true);
        private Value value;
        private Iter iter;
        private int hits = Integer.MAX_VALUE;

        private CmpCache() {
        }

        private boolean active(Value val, Iter ir) {
            if (this.set == null) {
                return false;
            }
            if (this.value != val) {
                if (this.hits < 1) {
                    this.set = null;
                    this.value = null;
                    this.iter = null;
                    return false;
                }
                this.set = new HashItemSet(true);
                this.value = val;
                this.iter = ir;
                this.hits = 0;
            }
            return true;
        }
    }
}

