/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.function.BiFunction;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.value.item.ADate;
import org.basex.query.value.item.ANum;
import org.basex.query.value.item.DTDur;
import org.basex.query.value.item.Dat;
import org.basex.query.value.item.Dbl;
import org.basex.query.value.item.Dec;
import org.basex.query.value.item.Dtm;
import org.basex.query.value.item.Dur;
import org.basex.query.value.item.Flt;
import org.basex.query.value.item.Int;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.Tim;
import org.basex.query.value.item.YMDur;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.Type;
import org.basex.util.InputInfo;

public enum Calc {
    PLUS("+"){

        @Override
        public Item eval(Item item1, Item item2, InputInfo info) throws QueryException {
            boolean num2;
            Type type1 = item1.type;
            Type type2 = item2.type;
            boolean num1 = type1.isNumberOrUntyped();
            if (num1 ^ (num2 = type2.isNumberOrUntyped())) {
                throw QueryError.numberError(num1 ? item2 : item1, info);
            }
            if (num1) {
                Type type = 1.type(type1, type2);
                if (type == AtomType.ITR) {
                    long itr1 = item1.itr(info);
                    long itr2 = item2.itr(info);
                    if (itr2 > 0L ? itr1 > Long.MAX_VALUE - itr2 : itr1 < Long.MIN_VALUE - itr2) {
                        throw QueryError.RANGE_X.get(info, String.valueOf(itr1) + " + " + itr2);
                    }
                    return Int.get(itr1 + itr2);
                }
                if (type == AtomType.DBL) {
                    return Dbl.get(item1.dbl(info) + item2.dbl(info));
                }
                if (type == AtomType.FLT) {
                    return Flt.get(item1.flt(info) + item2.flt(info));
                }
                return Dec.get(item1.dec(info).add(item2.dec(info)));
            }
            if (type1 == type2) {
                if (!(item1 instanceof Dur)) {
                    throw QueryError.numberError(item1, info);
                }
                if (type1 == AtomType.YMD) {
                    return new YMDur((YMDur)item1, (YMDur)item2, true, info);
                }
                if (type1 == AtomType.DTD) {
                    return new DTDur((DTDur)item1, (DTDur)item2, true, info);
                }
            }
            if (type1 == AtomType.DTM) {
                return new Dtm((Dtm)item1, 1.dur(info, item2), true, info);
            }
            if (type2 == AtomType.DTM) {
                return new Dtm((Dtm)item2, 1.dur(info, item1), true, info);
            }
            if (type1 == AtomType.DAT) {
                return new Dat((Dat)item1, 1.dur(info, item2), true, info);
            }
            if (type2 == AtomType.DAT) {
                return new Dat((Dat)item2, 1.dur(info, item1), true, info);
            }
            if (type1 == AtomType.TIM && type2 == AtomType.DTD) {
                return new Tim((Tim)item1, (DTDur)item2, true);
            }
            if (type2 == AtomType.TIM && type1 == AtomType.DTD) {
                return new Tim((Tim)item2, (DTDur)item1, true);
            }
            throw this.typeError(info, type1, type2);
        }

        @Override
        public Expr optimize(Expr ex1, Expr ex2) {
            BiFunction<Expr, Expr, Expr> func = (expr1, expr2) -> expr1 instanceof ANum && ((ANum)expr1).dbl() == 0.0 ? expr2 : null;
            Expr expr = func.apply(ex1, ex2);
            return expr != null ? expr : func.apply(ex2, ex1);
        }
    }
    ,
    MINUS("-"){

        @Override
        public Item eval(Item item1, Item item2, InputInfo info) throws QueryException {
            boolean num2;
            Type type1 = item1.type;
            Type type2 = item2.type;
            boolean num1 = type1.isNumberOrUntyped();
            if (num1 ^ (num2 = type2.isNumberOrUntyped())) {
                throw QueryError.numberError(num1 ? item2 : item1, info);
            }
            if (num1) {
                Type type = 2.type(type1, type2);
                if (type == AtomType.ITR) {
                    long itr1 = item1.itr(info);
                    long itr2 = item2.itr(info);
                    if (itr2 < 0L ? itr1 > Long.MAX_VALUE + itr2 : itr1 < Long.MIN_VALUE + itr2) {
                        throw QueryError.RANGE_X.get(info, String.valueOf(itr1) + " - " + itr2);
                    }
                    return Int.get(itr1 - itr2);
                }
                if (type == AtomType.DBL) {
                    return Dbl.get(item1.dbl(info) - item2.dbl(info));
                }
                if (type == AtomType.FLT) {
                    return Flt.get(item1.flt(info) - item2.flt(info));
                }
                return Dec.get(item1.dec(info).subtract(item2.dec(info)));
            }
            if (type1 == type2) {
                if (type1 == AtomType.DTM || type1 == AtomType.DAT || type1 == AtomType.TIM) {
                    return new DTDur((ADate)item1, (ADate)item2, info);
                }
                if (type1 == AtomType.YMD) {
                    return new YMDur((YMDur)item1, (YMDur)item2, false, info);
                }
                if (type1 == AtomType.DTD) {
                    return new DTDur((DTDur)item1, (DTDur)item2, false, info);
                }
                throw QueryError.numberError(item1, info);
            }
            if (type1 == AtomType.DTM) {
                return new Dtm((Dtm)item1, 2.dur(info, item2), false, info);
            }
            if (type1 == AtomType.DAT) {
                return new Dat((Dat)item1, 2.dur(info, item2), false, info);
            }
            if (type1 == AtomType.TIM && type2 == AtomType.DTD) {
                return new Tim((Tim)item1, (DTDur)item2, false);
            }
            throw this.typeError(info, type1, type2);
        }

        @Override
        public Expr optimize(Expr ex1, Expr ex2) {
            return ex2 instanceof ANum && ((ANum)ex2).dbl() == 0.0 ? ex1 : (ex1.equals(ex2) ? Calc.zero(ex1) : null);
        }
    }
    ,
    MULT("*"){

        @Override
        public Item eval(Item item1, Item item2, InputInfo info) throws QueryException {
            boolean num2;
            Type type1 = item1.type;
            Type type2 = item2.type;
            if (type1 == AtomType.YMD) {
                if (item2 instanceof ANum) {
                    return new YMDur((Dur)item1, item2.dbl(info), true, info);
                }
                throw QueryError.numberError(item2, info);
            }
            if (type2 == AtomType.YMD) {
                if (item1 instanceof ANum) {
                    return new YMDur((Dur)item2, item1.dbl(info), true, info);
                }
                throw QueryError.numberError(item1, info);
            }
            if (type1 == AtomType.DTD) {
                if (item2 instanceof ANum) {
                    return new DTDur((Dur)item1, item2.dbl(info), true, info);
                }
                throw QueryError.numberError(item2, info);
            }
            if (type2 == AtomType.DTD) {
                if (item1 instanceof ANum) {
                    return new DTDur((Dur)item2, item1.dbl(info), true, info);
                }
                throw QueryError.numberError(item1, info);
            }
            boolean num1 = type1.isNumberOrUntyped();
            if (num1 ^ (num2 = type2.isNumberOrUntyped())) {
                throw this.typeError(info, type1, type2);
            }
            if (num1) {
                Type type = 3.type(type1, type2);
                if (type == AtomType.ITR) {
                    long l1 = item1.itr(info);
                    long l2 = item2.itr(info);
                    if (l2 > 0L ? l1 > Long.MAX_VALUE / l2 || l1 < Long.MIN_VALUE / l2 : (l2 < -1L ? l1 > Long.MIN_VALUE / l2 || l1 < Long.MAX_VALUE / l2 : l2 == -1L && l1 == Long.MIN_VALUE)) {
                        throw QueryError.RANGE_X.get(info, String.valueOf(l1) + " * " + l2);
                    }
                    return Int.get(l1 * l2);
                }
                if (type == AtomType.DBL) {
                    return Dbl.get(item1.dbl(info) * item2.dbl(info));
                }
                if (type == AtomType.FLT) {
                    return Flt.get(item1.flt(info) * item2.flt(info));
                }
                return Dec.get(item1.dec(info).multiply(item2.dec(info)));
            }
            throw QueryError.numberError(item1, info);
        }

        @Override
        public Expr optimize(Expr ex1, Expr ex2) {
            BiFunction<Expr, Expr, Expr> func = (expr1, expr2) -> {
                double dbl1;
                double d = dbl1 = expr1 instanceof ANum ? ((ANum)expr1).dbl() : Double.NaN;
                return dbl1 == 1.0 ? expr2 : (dbl1 == 0.0 ? Calc.zero(expr1) : null);
            };
            Expr expr = func.apply(ex1, ex2);
            return expr != null ? expr : func.apply(ex2, ex1);
        }
    }
    ,
    DIV("div"){

        @Override
        public Item eval(Item item1, Item item2, InputInfo info) throws QueryException {
            Type type1 = item1.type;
            Type type2 = item2.type;
            if (type1 == type2) {
                if (type1 == AtomType.YMD) {
                    BigDecimal bd = BigDecimal.valueOf(((YMDur)item2).ymd());
                    if (bd.doubleValue() == 0.0) {
                        throw Calc.zeroError(info, item1);
                    }
                    return Dec.get(BigDecimal.valueOf(((YMDur)item1).ymd()).divide(bd, MathContext.DECIMAL64));
                }
                if (type1 == AtomType.DTD) {
                    BigDecimal bd = ((DTDur)item2).dtd();
                    if (bd.doubleValue() == 0.0) {
                        throw Calc.zeroError(info, item1);
                    }
                    return Dec.get(((DTDur)item1).dtd().divide(bd, MathContext.DECIMAL64));
                }
            }
            if (type1 == AtomType.YMD) {
                if (item2 instanceof ANum) {
                    return new YMDur((Dur)item1, item2.dbl(info), false, info);
                }
                throw QueryError.numberError(item2, info);
            }
            if (type1 == AtomType.DTD) {
                if (item2 instanceof ANum) {
                    return new DTDur((Dur)item1, item2.dbl(info), false, info);
                }
                throw QueryError.numberError(item2, info);
            }
            4.checkNum(info, item1, item2);
            Type type = 4.type(type1, type2);
            if (type == AtomType.DBL) {
                return Dbl.get(item1.dbl(info) / item2.dbl(info));
            }
            if (type == AtomType.FLT) {
                return Flt.get(item1.flt(info) / item2.flt(info));
            }
            BigDecimal dec1 = item1.dec(info);
            BigDecimal dec2 = item2.dec(info);
            if (dec2.signum() == 0) {
                throw Calc.zeroError(info, item1);
            }
            int scale = Math.max(18, Math.max(dec1.scale(), dec2.scale()));
            return Dec.get(dec1.divide(dec2, scale, RoundingMode.HALF_EVEN));
        }

        @Override
        public Expr optimize(Expr ex1, Expr ex2) {
            return ex2 instanceof ANum && ((ANum)ex2).dbl() == 1.0 ? ex1 : (ex1.equals(ex2) ? Calc.one(ex1) : null);
        }
    }
    ,
    IDIV("idiv"){

        @Override
        public Int eval(Item item1, Item item2, InputInfo info) throws QueryException {
            5.checkNum(info, item1, item2);
            Type type = 5.type(item1.type, item2.type);
            if (type == AtomType.DBL || type == AtomType.FLT) {
                double dbl1 = item1.dbl(info);
                double dbl2 = item2.dbl(info);
                if (dbl2 == 0.0) {
                    throw Calc.zeroError(info, item1);
                }
                double dbl = dbl1 / dbl2;
                if (Double.isNaN(dbl) || Double.isInfinite(dbl)) {
                    throw QueryError.DIVFLOW_X.get(info, String.valueOf(dbl1) + " idiv " + dbl2);
                }
                if (dbl < -9.223372036854776E18 || dbl > 9.223372036854776E18) {
                    throw QueryError.RANGE_X.get(info, String.valueOf(dbl1) + " idiv " + dbl2);
                }
                return Int.get((long)dbl);
            }
            if (type == AtomType.ITR) {
                long itr1 = item1.itr(info);
                long itr2 = item2.itr(info);
                if (itr2 == 0L) {
                    throw Calc.zeroError(info, item1);
                }
                if (itr1 == Integer.MIN_VALUE && itr2 == -1L) {
                    throw QueryError.RANGE_X.get(info, String.valueOf(itr1) + " idiv " + itr2);
                }
                return Int.get(itr1 / itr2);
            }
            BigDecimal dec1 = item1.dec(info);
            BigDecimal dec2 = item2.dec(info);
            if (dec2.signum() == 0) {
                throw Calc.zeroError(info, item1);
            }
            BigDecimal res = dec1.divideToIntegralValue(dec2);
            if (MIN_LONG.compareTo(res) > 0 || res.compareTo(MAX_LONG) > 0) {
                throw QueryError.RANGE_X.get(info, dec1 + " idiv " + dec2);
            }
            return Int.get(res.longValueExact());
        }

        @Override
        public Expr optimize(Expr ex1, Expr ex2) {
            return ex2 instanceof ANum && ((ANum)ex2).dbl() == 1.0 ? ex1 : (ex1.equals(ex2) ? Calc.one(ex1) : null);
        }
    }
    ,
    MOD("mod"){

        @Override
        public Item eval(Item item1, Item item2, InputInfo info) throws QueryException {
            6.checkNum(info, item1, item2);
            Type type = 6.type(item1.type, item2.type);
            if (type == AtomType.DBL) {
                return Dbl.get(item1.dbl(info) % item2.dbl(info));
            }
            if (type == AtomType.FLT) {
                return Flt.get(item1.flt(info) % item2.flt(info));
            }
            if (type == AtomType.ITR) {
                long itr1 = item1.itr(info);
                long itr2 = item2.itr(info);
                if (itr2 == 0L) {
                    throw Calc.zeroError(info, item1);
                }
                return Int.get(itr1 % itr2);
            }
            BigDecimal dec1 = item1.dec(info);
            BigDecimal dec2 = item2.dec(info);
            if (dec2.signum() == 0) {
                throw Calc.zeroError(info, item1);
            }
            BigDecimal sub = dec1.divide(dec2, 0, RoundingMode.DOWN);
            return Dec.get(dec1.subtract(sub.multiply(dec2)));
        }

        @Override
        public Expr optimize(Expr ex1, Expr ex2) {
            return null;
        }
    };

    private static final BigDecimal MIN_LONG;
    private static final BigDecimal MAX_LONG;
    final String name;

    static {
        MIN_LONG = BigDecimal.valueOf(Long.MIN_VALUE);
        MAX_LONG = BigDecimal.valueOf(Long.MAX_VALUE);
    }

    private Calc(String name) {
        this.name = name;
    }

    public abstract Item eval(Item var1, Item var2, InputInfo var3) throws QueryException;

    public abstract Expr optimize(Expr var1, Expr var2);

    public static Type type(Type type1, Type type2) {
        if (type1 == AtomType.DBL || type2 == AtomType.DBL || type1.isUntyped() || type2.isUntyped()) {
            return AtomType.DBL;
        }
        if (type1 == AtomType.FLT || type2 == AtomType.FLT) {
            return AtomType.FLT;
        }
        if (type1 == AtomType.DEC || type2 == AtomType.DEC) {
            return AtomType.DEC;
        }
        return AtomType.ITR;
    }

    private static Expr zero(Expr expr) {
        Type type = expr.seqType().type;
        return type == AtomType.DEC ? Dec.ZERO : (type.instanceOf(AtomType.ITR) ? Int.ZERO : null);
    }

    private static Expr one(Expr expr) {
        Type type = expr.seqType().type;
        return type == AtomType.DEC ? Dec.ONE : (type.instanceOf(AtomType.ITR) ? Int.ONE : null);
    }

    private static QueryException zeroError(InputInfo info, Item item) {
        return QueryError.DIVZERO_X.get(info, new Object[]{QueryError.chop(item, info)});
    }

    final QueryException typeError(InputInfo info, Type type1, Type type2) {
        return QueryError.CALCTYPE_X_X_X.get(info, this.info(), type1, type2);
    }

    static Dur dur(InputInfo info, Item item) throws QueryException {
        if (item instanceof Dur) {
            if (item.type == AtomType.DUR) {
                throw QueryError.NOSUBDUR_X.get(info, item);
            }
            return (Dur)item;
        }
        throw QueryError.NODUR_X_X.get(info, item.type, item);
    }

    static void checkNum(InputInfo info, Item item1, Item item2) throws QueryException {
        if (!item1.type.isNumberOrUntyped()) {
            throw QueryError.numberError(item1, info);
        }
        if (!item2.type.isNumberOrUntyped()) {
            throw QueryError.numberError(item2, info);
        }
    }

    final String info() {
        return String.valueOf('\'') + this.name + "' operator";
    }

    public String toString() {
        return this.name;
    }

    /* synthetic */ Calc(String string, int n, String string2, Calc calc) {
        this(string2);
    }
}

