/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.CmpR;
import org.basex.query.expr.CmpSR;
import org.basex.query.expr.Expr;
import org.basex.query.expr.Intersect;
import org.basex.query.expr.ItrPos;
import org.basex.query.expr.Logical;
import org.basex.query.expr.Or;
import org.basex.query.expr.Pos;
import org.basex.query.util.Flag;
import org.basex.query.util.IndexCosts;
import org.basex.query.util.IndexInfo;
import org.basex.query.util.list.ExprList;
import org.basex.query.value.item.Bln;
import org.basex.query.value.item.Item;
import org.basex.query.var.Var;
import org.basex.util.InputInfo;
import org.basex.util.ft.Scoring;
import org.basex.util.hash.IntObjMap;

public final class And
extends Logical {
    public And(InputInfo info, Expr ... exprs) {
        super(info, exprs);
    }

    @Override
    public Expr optimize(CompileContext cc) throws QueryException {
        return this.optimize(cc, true, ex -> new Or(this.info, (Expr)ex));
    }

    @Override
    void simplify(CompileContext cc, ExprList list) {
        int es = this.exprs.length;
        int e = 0;
        while (e < es) {
            Expr tmp;
            Expr expr = this.exprs[e];
            if (expr instanceof ItrPos) {
                while (e + 1 < es && this.exprs[e + 1] instanceof ItrPos) {
                    expr = ((ItrPos)expr).intersect((ItrPos)this.exprs[e + 1], this.info);
                    ++e;
                }
            } else if (expr instanceof Pos) {
                while (e + 1 < es && this.exprs[e + 1] instanceof Pos) {
                    tmp = ((Pos)expr).intersect((Pos)this.exprs[e + 1], this.info);
                    if (tmp != null) {
                        expr = tmp;
                        ++e;
                        continue;
                    }
                    break;
                }
            } else if (expr instanceof CmpR) {
                while (e + 1 < es && this.exprs[e + 1] instanceof CmpR) {
                    tmp = ((CmpR)expr).intersect((CmpR)this.exprs[e + 1]);
                    if (tmp != null) {
                        expr = tmp;
                        ++e;
                        continue;
                    }
                    break;
                }
            } else if (expr instanceof CmpSR) {
                while (e + 1 < es && this.exprs[e + 1] instanceof CmpSR) {
                    tmp = ((CmpSR)expr).intersect((CmpSR)this.exprs[e + 1]);
                    if (tmp != null) {
                        expr = tmp;
                        ++e;
                        continue;
                    }
                    break;
                }
            }
            if (!list.contains(expr) || expr.has(Flag.NDT)) {
                list.add(cc.replaceWith(this.exprs[e], expr));
            } else {
                cc.info("remove % from %", this.exprs[e], this.description());
            }
            ++e;
        }
    }

    @Override
    public Item item(QueryContext qc, InputInfo ii) throws QueryException {
        if (qc.scoring) {
            double score = 0.0;
            Expr[] exprArray = this.exprs;
            int n = this.exprs.length;
            int n2 = 0;
            while (n2 < n) {
                Expr expr = exprArray[n2];
                Item item = expr.ebv(qc, this.info);
                if (!item.bool(this.info)) {
                    return Bln.FALSE;
                }
                score += item.score();
                ++n2;
            }
            return Bln.get(true, Scoring.avg(score, this.exprs.length));
        }
        Expr[] exprArray = this.exprs;
        int n = this.exprs.length;
        int n3 = 0;
        while (n3 < n) {
            Expr expr = exprArray[n3];
            if (!expr.ebv(qc, this.info).bool(this.info)) {
                return Bln.FALSE;
            }
            ++n3;
        }
        return Bln.TRUE;
    }

    @Override
    public And copy(CompileContext cc, IntObjMap<Var> vars) {
        return new And(this.info, And.copyAll((CompileContext)cc, vars, (Expr[])this.exprs));
    }

    @Override
    public boolean indexAccessible(IndexInfo ii) throws QueryException {
        IndexCosts costs = IndexCosts.ZERO;
        ExprList list = new ExprList(this.exprs.length);
        Expr[] exprArray = this.exprs;
        int n = this.exprs.length;
        int n2 = 0;
        while (n2 < n) {
            Expr expr = exprArray[n2];
            if (!expr.indexAccessible(ii)) {
                return false;
            }
            if (ii.costs.results() == 0) {
                return true;
            }
            costs = IndexCosts.add(costs, ii.costs);
            list.add(ii.expr);
            ++n2;
        }
        ii.costs = costs;
        ii.expr = new Intersect(this.info, (Expr[])list.finish());
        return true;
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || obj instanceof And && super.equals(obj);
    }

    @Override
    public String toString() {
        return this.toString(" and ");
    }
}

