/*
 * Decompiled with CFR 0.152.
 */
package org.basex.io.serial;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.Normalizer;
import org.basex.io.in.BufferInput;
import org.basex.io.serial.OutputSerializer;
import org.basex.io.serial.SerializerOptions;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryIOException;
import org.basex.query.value.Value;
import org.basex.query.value.array.Array;
import org.basex.query.value.item.FItem;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.StrLazy;
import org.basex.query.value.node.ANode;
import org.basex.query.value.type.NodeType;
import org.basex.query.value.type.Type;
import org.basex.util.Strings;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.hash.IntObjMap;

public abstract class StandardSerializer
extends OutputSerializer {
    protected final Normalizer.Form form;
    protected final IntObjMap<byte[]> map;
    protected boolean sep;
    protected boolean atomic;

    protected StandardSerializer(OutputStream os, SerializerOptions sopts) throws IOException {
        super(os, sopts);
        this.itemsep(null);
        String norm = sopts.get(SerializerOptions.NORMALIZATION_FORM);
        if (norm.equals(SerializerOptions.NORMALIZATION_FORM.value())) {
            this.form = null;
        } else {
            try {
                this.form = Normalizer.Form.valueOf(norm);
            }
            catch (IllegalArgumentException ex) {
                Util.debug(ex);
                throw QueryError.SERNORM_X.getIO(norm);
            }
        }
        String maps = sopts.get(SerializerOptions.USE_CHARACTER_MAPS);
        if (maps.isEmpty()) {
            this.map = null;
        } else {
            this.map = new IntObjMap();
            String[] stringArray = Strings.split(maps, ',');
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                String[] kv = Strings.split(s, '=', 2);
                if (kv.length < 2) {
                    throw QueryError.SERMAP_X.getIO(maps);
                }
                this.map.put(kv[0].charAt(0), Token.token(kv[1]));
                ++n2;
            }
        }
        boolean bom = sopts.yes(SerializerOptions.BYTE_ORDER_MARK);
        if (bom) {
            if (this.encoding == "UTF-8") {
                this.out.write(239);
                this.out.write(187);
                this.out.write(191);
            } else if (this.encoding == "UTF-16LE") {
                this.out.write(255);
                this.out.write(254);
            } else if (this.encoding == "UTF-16BE") {
                this.out.write(254);
                this.out.write(255);
            }
        }
    }

    @Override
    public void serialize(Item item) throws IOException {
        if (this.more && this.itemsep != null) {
            this.out.print(this.itemsep);
            this.sep = false;
        }
        super.serialize(item);
    }

    @Override
    public void reset() {
        this.sep = false;
        this.atomic = false;
        super.reset();
    }

    @Override
    protected void node(ANode node) throws IOException {
        Type type = node.type;
        if (type == NodeType.ATT) {
            throw QueryError.SERATTR_X.getIO(node);
        }
        if (type == NodeType.NSP) {
            throw QueryError.SERNS_X.getIO(node);
        }
        super.node(node);
    }

    @Override
    protected void function(FItem item) throws IOException {
        if (!(item instanceof Array)) {
            throw QueryError.SERFUNC_X.getIO(item.seqType());
        }
        for (Value value : ((Array)item).members()) {
            for (Item it : value) {
                this.serialize(it);
            }
        }
    }

    @Override
    protected void atomic(Item item) throws IOException {
        block14: {
            if (this.sep && this.atomic) {
                this.out.print(32);
            }
            try {
                if (item instanceof StrLazy && this.form == null) {
                    Throwable throwable = null;
                    Object var3_5 = null;
                    try (BufferInput is = item.input(null);){
                        int cp;
                        while ((cp = ((InputStream)is).read()) != -1) {
                            this.printChar(cp);
                        }
                        break block14;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                this.printChars(this.norm(item.string(null)));
            }
            catch (QueryException ex) {
                throw new QueryIOException(ex);
            }
        }
        this.sep = true;
        this.atomic = true;
    }

    protected final byte[] norm(byte[] text) {
        return this.form == null || Token.ascii(text) ? text : Token.token(Normalizer.normalize(Token.string(text), this.form));
    }
}

