/*
 * Decompiled with CFR 0.152.
 */
package org.basex.io.random;

import java.io.Closeable;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.basex.io.IOFile;
import org.basex.io.random.Buffer;
import org.basex.io.random.Buffers;
import org.basex.util.Util;

public final class DataAccess
implements Closeable {
    private final Buffers bm = new Buffers();
    private final RandomAccessFile raf;
    private long length;
    private boolean changed;
    private int off;

    public DataAccess(IOFile file) throws IOException {
        RandomAccessFile f = null;
        try {
            f = new RandomAccessFile(file.file(), "rw");
            this.length = f.length();
            this.raf = f;
            this.cursor(0L);
        }
        catch (IOException ex) {
            if (f != null) {
                f.close();
            }
            throw ex;
        }
    }

    public synchronized void flush() {
        try {
            Buffer[] bufferArray = this.bm.all();
            int n = bufferArray.length;
            int n2 = 0;
            while (n2 < n) {
                Buffer b = bufferArray[n2];
                if (b.dirty) {
                    this.writeBlock(b);
                }
                ++n2;
            }
            if (this.changed) {
                this.raf.setLength(this.length);
                this.changed = false;
            }
        }
        catch (IOException ex) {
            Util.stack(ex);
        }
    }

    @Override
    public synchronized void close() {
        this.flush();
        try {
            this.raf.close();
        }
        catch (IOException ex) {
            Util.stack(ex);
        }
    }

    public long cursor() {
        return this.buffer((boolean)false).pos + (long)this.off;
    }

    public long length() {
        return this.length;
    }

    public boolean more() {
        return this.cursor() < this.length;
    }

    public synchronized byte read1(long pos) {
        this.cursor(pos);
        return this.read1();
    }

    public synchronized byte read1() {
        return (byte)this.read();
    }

    public synchronized int read4(long pos) {
        this.cursor(pos);
        return this.read4();
    }

    public synchronized int read4() {
        return (this.read() << 24) + (this.read() << 16) + (this.read() << 8) + this.read();
    }

    public synchronized long read5(long pos) {
        this.cursor(pos);
        return this.read5();
    }

    public synchronized long read5() {
        return ((long)this.read() << 32) + ((long)this.read() << 24) + (long)(this.read() << 16) + (long)(this.read() << 8) + (long)this.read();
    }

    public synchronized int readNum(long p) {
        this.cursor(p);
        return this.readNum();
    }

    public synchronized byte[] readToken(long p) {
        this.cursor(p);
        return this.readToken();
    }

    public synchronized byte[] readToken() {
        int l = this.readNum();
        return this.readBytes(l);
    }

    public synchronized byte[] readBytes(long pos, int len) {
        this.cursor(pos);
        return this.readBytes(len);
    }

    public synchronized byte[] readBytes(int len) {
        int l = len;
        int ll = 4096 - this.off;
        byte[] b = new byte[l];
        System.arraycopy(this.buffer((boolean)false).data, this.off, b, 0, Math.min(l, ll));
        if (l > ll) {
            l -= ll;
            while (l > 4096) {
                System.arraycopy(this.buffer((boolean)true).data, 0, b, ll, 4096);
                ll += 4096;
                l -= 4096;
            }
            System.arraycopy(this.buffer((boolean)true).data, 0, b, ll, l);
        }
        this.off += l;
        return b;
    }

    public void cursor(long pos) {
        this.off = (int)(pos & 0xFFFL);
        long b = pos - (long)this.off;
        if (!this.bm.cursor(b)) {
            return;
        }
        Buffer bf = this.bm.current();
        try {
            if (bf.dirty) {
                this.writeBlock(bf);
            }
            bf.pos = b;
            this.raf.seek(bf.pos);
            if (bf.pos < this.raf.length()) {
                this.raf.readFully(bf.data, 0, (int)Math.min(this.length - bf.pos, 4096L));
            }
        }
        catch (IOException ex) {
            Util.stack(ex);
        }
    }

    public synchronized int readNum() {
        int value = this.read();
        switch (value & 0xC0) {
            case 0: {
                return value;
            }
            case 64: {
                return (value - 64 << 8) + this.read();
            }
            case 128: {
                return (value - 128 << 24) + (this.read() << 16) + (this.read() << 8) + this.read();
            }
        }
        return (this.read() << 24) + (this.read() << 16) + (this.read() << 8) + this.read();
    }

    public void write5(long pos, long value) {
        this.cursor(pos);
        this.write((byte)(value >>> 32));
        this.write((byte)(value >>> 24));
        this.write((byte)(value >>> 16));
        this.write((byte)(value >>> 8));
        this.write((byte)value);
    }

    public void write4(long pos, int value) {
        this.cursor(pos);
        this.write4(value);
    }

    public void write4(int value) {
        this.write(value >>> 24);
        this.write(value >>> 16);
        this.write(value >>> 8);
        this.write(value);
    }

    public void writeNum(int value) {
        if (value < 0 || value > 0x3FFFFFFF) {
            this.write(192);
            this.write(value >>> 24);
            this.write(value >>> 16);
            this.write(value >>> 8);
            this.write(value);
        } else if (value > 16383) {
            this.write(value >>> 24 | 0x80);
            this.write(value >>> 16);
            this.write(value >>> 8);
            this.write(value);
        } else if (value > 63) {
            this.write(value >>> 8 | 0x40);
            this.write(value);
        } else {
            this.write(value);
        }
    }

    public void writeBytes(byte[] buffer, int offset, int len) {
        int last = offset + len;
        int o = offset;
        while (o < last) {
            Buffer bf = this.buffer();
            int l = Math.min(last - o, 4096 - this.off);
            System.arraycopy(buffer, o, bf.data, this.off, l);
            bf.dirty = true;
            this.off += l;
            o += l;
            long nl = bf.pos + (long)this.off;
            if (nl <= this.length) continue;
            this.length(nl);
        }
    }

    public void writeToken(long pos, byte[] values) {
        this.cursor(pos);
        this.writeToken(values, 0, values.length);
    }

    public long free(long pos, int size) {
        int os = this.readNum(pos) + (int)(this.cursor() - pos);
        this.cursor(pos + (long)os);
        while (pos + (long)os < this.length && os < size && this.read() == 255) {
            ++os;
        }
        long o = pos;
        if (pos + (long)os == this.length) {
            this.length(pos);
        } else {
            int t = size;
            if (os < size) {
                this.cursor(pos);
                t = 0;
                o = this.length;
            } else {
                this.cursor(pos + (long)size);
            }
            while (t++ < os) {
                this.write(255);
            }
        }
        return o;
    }

    private synchronized void length(long len) {
        if (len != this.length) {
            this.changed = true;
            this.length = len;
        }
    }

    private int read() {
        Buffer bf = this.buffer();
        return bf.data[this.off++] & 0xFF;
    }

    private void write(int value) {
        Buffer bf = this.buffer();
        bf.dirty = true;
        bf.data[this.off++] = (byte)value;
        long nl = bf.pos + (long)this.off;
        if (nl > this.length) {
            this.length(nl);
        }
    }

    private void writeToken(byte[] buffer, int offset, int len) {
        this.writeNum(len);
        this.writeBytes(buffer, offset, len);
    }

    private void writeBlock(Buffer buffer) throws IOException {
        long pos = buffer.pos;
        long len = Math.min(4096L, this.length - pos);
        this.raf.seek(pos);
        this.raf.write(buffer.data, 0, (int)len);
        buffer.dirty = false;
    }

    private Buffer buffer() {
        return this.buffer(this.off == 4096);
    }

    private Buffer buffer(boolean next) {
        if (next) {
            this.cursor(this.bm.current().pos + 4096L);
        }
        return this.bm.current();
    }
}

