/*
 * Decompiled with CFR 0.152.
 */
package org.basex.io.parse.json;

import org.basex.build.json.JsonParserOptions;
import org.basex.io.parse.json.JsonConstants;
import org.basex.io.parse.json.JsonXmlConverter;
import org.basex.query.value.node.FElem;

public final class JsonAttsConverter
extends JsonXmlConverter {
    private byte[] nm;

    JsonAttsConverter(JsonParserOptions opts) {
        super(opts);
    }

    @Override
    void openObject() {
        this.addType(JsonConstants.OBJECT);
    }

    @Override
    void openPair(byte[] name, boolean add) {
        if (add) {
            FElem elem = new FElem(JsonConstants.PAIR).add(JsonConstants.NAME, name);
            this.curr.add(elem);
            this.curr = elem;
            this.nm = name;
        }
    }

    @Override
    void closePair(boolean add) {
        if (add) {
            this.curr = (FElem)this.curr.parent();
        }
    }

    @Override
    void closeObject() {
    }

    @Override
    void openArray() {
        this.addType(JsonConstants.ARRAY);
        this.nm = null;
    }

    @Override
    void openItem() {
        FElem elem = new FElem(JsonConstants.ITEM);
        this.curr.add(elem);
        this.curr = elem;
    }

    @Override
    void closeItem() {
        this.curr = (FElem)this.curr.parent();
    }

    @Override
    void closeArray() {
    }

    @Override
    public void numberLit(byte[] value) {
        this.addType(JsonConstants.NUMBER).add(value);
    }

    @Override
    public void stringLit(byte[] value) {
        this.addType(JsonConstants.STRING).add(value);
    }

    @Override
    public void nullLit() {
        this.addType(JsonConstants.NULL);
    }

    @Override
    public void booleanLit(byte[] value) {
        this.addType(JsonConstants.BOOLEAN).add(value);
    }

    private FElem addType(byte[] type) {
        FElem elem = this.element();
        this.addType(elem, this.nm, type);
        return elem;
    }
}

