/*
 * Decompiled with CFR 0.152.
 */
package org.basex.io.in;

import org.basex.util.Util;
import org.basex.util.list.ByteList;

public final class TarEntry {
    private static final String LONGNAME = "././@LongLink";
    private final long size;
    private final byte type;
    private String name;

    TarEntry(byte[] buffer) {
        ByteList result = new ByteList();
        int i = 0;
        while (i < 100) {
            if (buffer[i] == 0) break;
            result.add(buffer[i]);
            ++i;
        }
        this.name = TarEntry.name(result);
        long s = 0L;
        boolean p = true;
        int i2 = 124;
        while (i2 < 136) {
            byte b = buffer[i2];
            if (!p || b != 32 && b != 48) {
                if (b == 0 || b == 32) break;
                s = (s << 3) + (long)(b - 48);
                p = false;
            }
            ++i2;
        }
        this.size = s;
        this.type = buffer[156];
    }

    public long getSize() {
        return this.size;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String nm) {
        this.name = nm;
    }

    public boolean isDirectory() {
        return this.type == 53 || this.name.endsWith("/");
    }

    public boolean isLongName() {
        return this.type == 76 && this.name.equals(LONGNAME);
    }

    static String name(ByteList result) {
        try {
            return new String(result.toArray());
        }
        catch (Exception ex) {
            Util.debug(ex);
            return result.toString();
        }
    }

    public String toString() {
        return String.valueOf(Util.className(this)) + '[' + this.name + ", " + this.size + " bytes]";
    }
}

