/*
 * Decompiled with CFR 0.152.
 */
package org.basex.index.value;

import java.io.IOException;
import org.basex.data.Data;
import org.basex.index.IndexType;
import org.basex.index.value.DiskValues;
import org.basex.index.value.ValueCache;
import org.basex.util.FreeSlots;
import org.basex.util.Num;
import org.basex.util.Util;
import org.basex.util.list.IntList;
import org.basex.util.list.TokenList;

public final class UpdatableDiskValues
extends DiskValues {
    private final FreeSlots free = new FreeSlots();

    public UpdatableDiskValues(Data data, IndexType type) throws IOException {
        super(data, type, UpdatableDiskValues.fileSuffix(type));
    }

    @Override
    protected int pre(int id) {
        return this.data.pre(id);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public synchronized void add(ValueCache values) {
        newKeys = new TokenList();
        index = 0;
        sz = this.size();
        for (byte[] key : values) {
            index = this.get(key, index, sz);
            if (index >= 0) {
                ids = values.ids(key);
                pos = values.pos(key);
                off = this.idxr.read5((long)index * 5L);
                oldSize = this.idxl.readNum(off);
                newSize = oldSize + ids.size();
                newIds = new IntList(newSize);
                newPos = pos != null ? new IntList(newSize) : null;
                o = 0;
                c = 0;
                while (o < oldSize) {
                    newIds.add(c += this.idxl.readNum());
                    if (newPos != null) {
                        newPos.add(this.idxl.readNum());
                    }
                    ++o;
                }
                newIds.add(ids.finish());
                if (newPos != null) {
                    newPos.add(pos.finish());
                }
                this.free.add((int)(this.idxl.cursor() - off), off);
                this.writeIds(key, newIds, newPos, index++);
                continue;
            }
            index = -(index + 1);
            newKeys.add(key);
        }
        ns = newKeys.size();
        j = ns - 1;
        oldIndex = sz - 1;
        newIndex = sz + j;
        while (j >= 0) {
            key = (byte[])newKeys.get(j);
            idx = -(1 + this.get(key, 0, oldIndex + 1));
            if (idx >= 0) ** GOTO lbl47
            throw Util.notExpected("Key should not exist: '%'", new Object[]{key});
lbl-1000:
            // 1 sources

            {
                off = this.idxr.read5((long)oldIndex * 5L);
                this.writeIndex(newIndex--, off, this.ctext.put(oldIndex--, null));
lbl47:
                // 2 sources

                ** while (oldIndex >= idx)
            }
lbl48:
            // 1 sources

            this.writeIds(key, values.ids(key), values.pos(key), newIndex--);
            --j;
        }
        this.size(sz + ns);
    }

    @Override
    public synchronized void delete(ValueCache values) {
        IntList keys = new IntList();
        int p = 0;
        int sz = this.size();
        for (byte[] key : values) {
            p = this.get(key, p, sz);
            if (p < 0) {
                throw Util.notExpected("Key does not exist: '%'", new Object[]{key});
            }
            if (this.deleteIds(p, key, values)) {
                keys.add(p);
            }
            ++p;
        }
        this.deleteKeys(keys);
    }

    private boolean deleteIds(int index, byte[] key, ValueCache values) {
        long off = this.idxr.read5((long)index * 5L);
        IntList ids = values.ids(key).sort();
        boolean pos = values.pos(key) != null;
        int oldSize = this.idxl.readNum(off);
        int delSize = ids.size();
        int newSize = oldSize - delSize;
        IntList newIds = new IntList(newSize);
        IntList newPos = pos ? new IntList(newSize) : null;
        int o = 0;
        int d = 0;
        int currId = 0;
        while (o < oldSize) {
            int currPos;
            int n = currPos = pos ? this.idxl.readNum() : 0;
            if (d < delSize && (currId += this.idxl.readNum()) == ids.get(d)) {
                ++d;
            } else {
                newIds.add(currId);
                if (newPos != null) {
                    newPos.add(currPos);
                }
            }
            ++o;
        }
        this.free.add((int)(this.idxl.cursor() - off), off);
        if (newSize == 0) {
            this.cache.delete(key);
            return true;
        }
        this.writeIds(key, newIds, newPos, index);
        return false;
    }

    private void deleteKeys(IntList keys) {
        if (keys.isEmpty()) {
            return;
        }
        int sz = this.size();
        int kl = keys.size();
        byte[] tmp = this.idxr.readBytes(0L, sz * 5);
        int k = 0;
        int newIndex = keys.get(k++);
        int oldIndex = newIndex + 1;
        while (oldIndex < sz) {
            if (k < kl && oldIndex == keys.get(k)) {
                ++k;
            } else {
                this.copy(tmp, oldIndex, newIndex++);
            }
            ++oldIndex;
        }
        this.size(sz -= kl);
        this.idxr.cursor(0L);
        this.idxr.writeBytes(tmp, 0, sz * 5);
    }

    private void copy(byte[] tmp, int oldIndex, int newIndex) {
        System.arraycopy(tmp, oldIndex * 5, tmp, newIndex * 5, 5);
        this.ctext.put(newIndex, this.ctext.put(oldIndex, null));
    }

    private void writeIds(byte[] key, IntList ids, IntList pos, int index) {
        int[] nums = UpdatableDiskValues.prepare(ids, pos);
        int bytes = Num.length(nums.length);
        int[] nArray = nums;
        int n = nums.length;
        int n2 = 0;
        while (n2 < n) {
            int num = nArray[n2];
            bytes += Num.length(num);
            ++n2;
        }
        long offset = this.free.get(bytes, this.idxl.length());
        int sz = ids.size();
        this.writeIndex(index, offset, key);
        this.idxl.cursor(offset);
        this.idxl.writeNum(sz);
        int[] nArray2 = nums;
        int n3 = nums.length;
        int n4 = 0;
        while (n4 < n3) {
            int num = nArray2[n4];
            this.idxl.writeNum(num);
            ++n4;
        }
        this.cache.add(key, sz, offset + (long)Num.length(sz));
    }

    private void writeIndex(int index, long offset, byte[] key) {
        this.idxr.write5((long)index * 5L, offset);
        this.ctext.put(index, key);
    }

    private void size(int sz) {
        this.size.set(sz);
        this.idxl.write4(0L, sz);
    }

    private static int[] prepare(IntList ids, IntList pos) {
        int is = ids.size();
        IntList result = new IntList(pos == null ? is : is << 1);
        int[] order = null;
        if (pos == null) {
            ids.sort();
        } else {
            order = ids.createOrder();
        }
        int lastId = 0;
        int i = 0;
        while (i < is) {
            int id = ids.get(i);
            result.add(id - lastId);
            lastId = id;
            if (pos != null) {
                result.add(pos.get(order[i]));
            }
            ++i;
        }
        return result.finish();
    }

    @Override
    public String toString() {
        return String.valueOf(super.toString()) + this.free;
    }
}

