/*
 * Decompiled with CFR 0.152.
 */
package org.basex.index.value;

import java.util.ArrayList;
import java.util.Arrays;
import org.basex.core.MainOptions;
import org.basex.core.Text;
import org.basex.data.Data;
import org.basex.data.MemData;
import org.basex.index.IndexType;
import org.basex.index.query.EntryIterator;
import org.basex.index.query.IndexEntries;
import org.basex.index.query.IndexIterator;
import org.basex.index.query.IndexToken;
import org.basex.index.stats.IndexStats;
import org.basex.index.value.ValueCache;
import org.basex.index.value.ValueIndex;
import org.basex.query.util.IndexCosts;
import org.basex.util.Array;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.hash.TokenSet;
import org.basex.util.list.BoolList;
import org.basex.util.list.IntList;

public final class MemValues
extends ValueIndex {
    private final TokenSet values;
    private ArrayList<int[]> idsList;
    private IntList lenList;
    private BoolList reorder;

    public MemValues(Data data, IndexType type) {
        super(data, type);
        this.values = type == IndexType.TOKEN ? new TokenSet() : ((MemData)data).values(type == IndexType.TEXT);
        int s = this.values.size() + 1;
        this.idsList = new ArrayList(s);
        this.lenList = new IntList(s);
        this.reorder = new BoolList(s);
    }

    @Override
    public IndexIterator iter(IndexToken token) {
        int[] pres;
        int id = this.values.id(token.get());
        if (id == 0) {
            return IndexIterator.EMPTY;
        }
        final int len = this.lenList.get(id);
        int[] ids = this.idsList.get(id);
        if (this.data.meta.updindex) {
            IntList tmp = new IntList();
            int i = 0;
            while (i < len) {
                tmp.add(this.data.pre(ids[i]));
                ++i;
            }
            pres = tmp.sort().finish();
        } else {
            pres = ids;
        }
        return new IndexIterator(){
            int p;

            @Override
            public boolean more() {
                return this.p < len;
            }

            @Override
            public int pre() {
                return pres[this.p++];
            }

            @Override
            public int size() {
                return len;
            }
        };
    }

    @Override
    public IndexCosts costs(IndexToken it) {
        return IndexCosts.get(this.lenList.get(this.values.id(it.get())));
    }

    @Override
    public EntryIterator entries(IndexEntries entries) {
        final byte[] prefix = entries.get();
        return new EntryIterator(){
            final int s;
            int p;
            {
                this.s = MemValues.this.values.size();
            }

            @Override
            public byte[] next() {
                while (++this.p <= this.s) {
                    byte[] key;
                    if (MemValues.this.lenList.get(this.p) == 0 || !Token.startsWith(key = MemValues.this.values.key(this.p), prefix)) continue;
                    return key;
                }
                return null;
            }

            @Override
            public int count() {
                return MemValues.this.lenList.get(this.p);
            }
        };
    }

    @Override
    public byte[] info(MainOptions options) {
        TokenBuilder tb = new TokenBuilder();
        tb.add("- Structure: ").add("Hash").add(Text.NL);
        tb.add("- Names: ").add(this.data.meta.names(this.type)).add(Text.NL);
        IndexStats stats = new IndexStats(options.get(MainOptions.MAXSTAT));
        int s = this.values.size();
        int p = 1;
        while (p <= s) {
            int oc = this.lenList.get(p);
            if (oc > 0 && stats.adding(oc)) {
                stats.add(this.values.key(p), oc);
            }
            ++p;
        }
        stats.print(tb);
        return tb.finish();
    }

    @Override
    public int size() {
        int ll = this.lenList.size();
        int s = 0;
        int c = 1;
        while (c < ll) {
            if (this.lenList.get(c) > 0) {
                ++s;
            }
            ++c;
        }
        return s;
    }

    @Override
    public boolean drop() {
        this.idsList = null;
        this.lenList = null;
        return true;
    }

    @Override
    public void add(ValueCache cache) {
        for (byte[] key : cache) {
            IntList vals = cache.ids(key);
            if (vals.isEmpty()) continue;
            this.add(key, vals.sort().finish());
        }
        this.finish();
    }

    @Override
    public void delete(ValueCache cache) {
        for (byte[] key : cache) {
            this.delete(key, cache.ids(key).sort().finish());
        }
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
    }

    void add(byte[] key, int ... vals) {
        int id = this.type == IndexType.TOKEN ? this.values.put(key) : this.values.id(key);
        int vl = vals.length;
        while (this.idsList.size() < id + 1) {
            this.idsList.add(null);
        }
        if (this.lenList.size() < id + 1) {
            this.lenList.set(id, 0);
        }
        int len = this.lenList.get(id);
        int size = len + vl;
        int[] ids = this.idsList.get(id);
        if (ids == null) {
            ids = vals;
        } else {
            if (ids.length < size) {
                ids = Arrays.copyOf(ids, Array.newSize(size));
            }
            System.arraycopy(vals, 0, ids, len, vl);
            if (ids[len - 1] > vals[0]) {
                if (this.reorder == null) {
                    this.reorder = new BoolList(this.values.size());
                }
                this.reorder.set(id, true);
            }
        }
        this.idsList.set(id, ids);
        this.lenList.set(id, size);
    }

    void finish() {
        if (this.reorder == null) {
            return;
        }
        int i = 1;
        while (i < this.reorder.size()) {
            if (this.reorder.get(i)) {
                Arrays.sort(this.idsList.get(i), 0, this.lenList.get(i));
            }
            ++i;
        }
        this.reorder = null;
    }

    void delete(byte[] key, int ... vals) {
        int id = this.values.id(key);
        int vl = vals.length;
        int l = this.lenList.get(id);
        int s = l - vl;
        int[] ids = this.idsList.get(id);
        int i = 0;
        int n = 0;
        int v = 0;
        while (i < l) {
            if (v == vl || ids[i] != vals[v]) {
                ids[n++] = ids[i];
            } else {
                ++v;
            }
            ++i;
        }
        this.lenList.set(id, s);
        if (s == 0) {
            this.idsList.set(id, null);
        }
    }

    public String toString(boolean all) {
        TokenBuilder tb = new TokenBuilder();
        tb.addExt((Object)this.type, new Object[0]).add(" INDEX, '").add(this.data.meta.name).add("':\n");
        int s = this.lenList.size();
        int m = 1;
        while (m < s) {
            int len = this.lenList.get(m);
            if (len != 0) {
                int[] ids = this.idsList.get(m);
                tb.add("  ").addInt(m);
                if (all) {
                    tb.add(", key: \"").add(this.data.text(this.data.pre(ids[0]), this.type == IndexType.TEXT)).add(34);
                }
                tb.add(", ids");
                if (all) {
                    tb.add("/pres");
                }
                tb.add(": ");
                int n = 0;
                while (n < len) {
                    if (n != 0) {
                        tb.add(",");
                    }
                    tb.addInt(ids[n]);
                    if (all) {
                        tb.add(47).addInt(this.data.pre(ids[n]));
                    }
                    ++n;
                }
                tb.add("\n");
            }
            ++m;
        }
        return tb.toString();
    }

    public String toString() {
        return this.toString(false);
    }
}

