/*
 * Decompiled with CFR 0.152.
 */
package org.basex.index.ft;

import java.io.IOException;
import org.basex.core.MainOptions;
import org.basex.core.Text;
import org.basex.data.Data;
import org.basex.index.IndexCache;
import org.basex.index.IndexEntry;
import org.basex.index.IndexType;
import org.basex.index.query.EntryIterator;
import org.basex.index.query.FTIndexIterator;
import org.basex.index.query.IndexEntries;
import org.basex.index.query.IndexIterator;
import org.basex.index.query.IndexToken;
import org.basex.index.stats.IndexStats;
import org.basex.index.value.ValueCache;
import org.basex.index.value.ValueIndex;
import org.basex.io.random.DataAccess;
import org.basex.query.expr.ft.FTWildcard;
import org.basex.query.util.IndexCosts;
import org.basex.query.util.ft.FTMatches;
import org.basex.util.Array;
import org.basex.util.Performance;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;
import org.basex.util.ft.FTFlag;
import org.basex.util.ft.FTLexer;
import org.basex.util.ft.FTOpt;
import org.basex.util.hash.IntObjMap;
import org.basex.util.list.IntList;
import org.basex.util.similarity.Levenshtein;

public final class FTIndex
extends ValueIndex {
    private static final int ENTRY = 9;
    private final IntObjMap<byte[]> ctext = new IntObjMap();
    private final Levenshtein ls = new Levenshtein();
    private final DataAccess inX;
    private final DataAccess inY;
    private final DataAccess inZ;
    private final IndexCache cache = new IndexCache();
    private final int[] tp;

    public FTIndex(Data data) throws IOException {
        super(data, IndexType.FULLTEXT);
        this.inY = new DataAccess(data.meta.dbfile("ftxy"));
        this.inZ = new DataAccess(data.meta.dbfile("ftxz"));
        this.inX = new DataAccess(data.meta.dbfile("ftxx"));
        this.tp = new int[data.meta.maxlen + 3];
        int tl = this.tp.length;
        int i = 0;
        while (i < tl) {
            this.tp[i] = -1;
            ++i;
        }
        int is = this.inX.readNum();
        while (--is >= 0) {
            int p = this.inX.readNum();
            this.tp[p] = this.inX.read4();
        }
        this.tp[tl - 1] = (int)this.inY.length();
    }

    @Override
    public synchronized IndexCosts costs(IndexToken it) {
        byte[] tok = it.get();
        if (tok.length > this.data.meta.maxlen) {
            return null;
        }
        FTOpt opt = ((FTLexer)it).ftOpt();
        return IndexCosts.get(opt.is(FTFlag.FZ) || opt.is(FTFlag.WC) ? Math.max(1, this.data.meta.size >> 4) : this.entry((byte[])tok).size);
    }

    @Override
    public synchronized IndexIterator iter(IndexToken it) {
        byte[] tok = it.get();
        FTLexer lexer = (FTLexer)it;
        FTOpt opt = lexer.ftOpt();
        if (opt.is(FTFlag.WC)) {
            return this.wc(tok);
        }
        if (opt.is(FTFlag.FZ)) {
            return this.fuzzy(tok, lexer.lserror(tok));
        }
        IndexEntry e = this.entry(tok);
        return e.size > 0 ? FTIndex.iter(e.offset, e.size, this.inZ, tok) : FTIndexIterator.FTEMPTY;
    }

    private IndexEntry entry(byte[] token) {
        IndexEntry e = this.cache.get(token);
        if (e != null) {
            return e;
        }
        long p = this.token(token);
        return p == -1L ? new IndexEntry(token, 0, 0L) : this.cache.add(token, this.size(p, token.length), this.pointer(p, token.length));
    }

    @Override
    public EntryIterator entries(IndexEntries entries) {
        final byte[] prefix = entries.get();
        return new EntryIterator(){
            int ti;
            int i;
            int e;
            int nr;
            boolean inner;
            {
                this.ti = byArray.length - 1;
            }

            @Override
            public synchronized byte[] next() {
                byte[] entry;
                if (this.inner && this.i < this.e && Token.startsWith(entry = FTIndex.this.inY.readBytes(this.i, this.ti), prefix)) {
                    long poi = FTIndex.this.inY.read5();
                    this.nr = FTIndex.this.inY.read4();
                    if (prefix.length != 0) {
                        FTIndex.this.cache.add(entry, this.nr, poi);
                    }
                    this.i += this.ti + 9;
                    return entry;
                }
                int tl = FTIndex.this.tp.length;
                while (++this.ti < tl - 1) {
                    this.i = FTIndex.this.tp[this.ti];
                    if (this.i == -1) continue;
                    int c = this.ti + 1;
                    do {
                        this.e = FTIndex.this.tp[c++];
                    } while (this.e == -1);
                    this.nr = 0;
                    this.inner = true;
                    this.i = FTIndex.this.find(prefix, this.i, this.e, this.ti);
                    byte[] n = this.next();
                    if (n == null) continue;
                    return n;
                }
                return null;
            }

            @Override
            public int count() {
                return this.nr;
            }
        };
    }

    private int find(byte[] token, int start, int end, int ti) {
        int tl = ti + 9;
        int l = 0;
        int h = (end - start) / tl;
        while (l <= h) {
            int d;
            int m = l + h >>> 1;
            int p = start + m * tl;
            byte[] txt = this.ctext.get(p);
            if (txt == null) {
                txt = this.inY.readBytes(p, ti);
                this.ctext.put(p, txt);
            }
            if ((d = Token.diff(txt, token)) == 0) {
                return start + m * tl;
            }
            if (d < 0) {
                l = m + 1;
                continue;
            }
            h = m - 1;
        }
        return start + l * tl;
    }

    @Override
    public synchronized byte[] info(MainOptions options) {
        TokenBuilder tb = new TokenBuilder();
        long l = this.inX.length() + this.inY.length() + this.inZ.length();
        tb.add("- Names: ").add(this.data.meta.ftinclude).add(Text.NL);
        tb.add("- Size: " + Performance.format(l) + Text.NL);
        IndexStats stats = new IndexStats(options.get(MainOptions.MAXSTAT));
        this.addOccs(stats);
        stats.print(tb);
        return tb.finish();
    }

    @Override
    public boolean drop() {
        return this.data.meta.drop("ftx.");
    }

    @Override
    public synchronized void close() {
        this.inX.close();
        this.inY.close();
        this.inZ.close();
    }

    @Override
    public int size() {
        int tl = this.tp.length;
        int size = 0;
        int t = tl - 1;
        while (true) {
            int e = t;
            while (this.tp[--t] == -1) {
                if (t != 0) continue;
                return size;
            }
            size += (this.tp[e] - this.tp[t]) / (t + 9);
        }
    }

    private int token(byte[] token) {
        int r;
        int tl = token.length;
        int l = this.tp[tl];
        if (l == -1) {
            return -1;
        }
        int i = 1;
        while ((r = this.tp[tl + i++]) == -1) {
        }
        int x = r;
        int o = tl + 9;
        while (l < r) {
            int m = l + (r - l >> 1) / o * o;
            int c = Token.diff(this.inY.readBytes(m, tl), token);
            if (c == 0) {
                return m;
            }
            if (c < 0) {
                l = m + o;
                continue;
            }
            r = m - o;
        }
        return r != x && l == r && Token.eq(this.inY.readBytes(l, tl), token) ? l : -1;
    }

    private void addOccs(IndexStats stats) {
        int i = 0;
        int tl = this.tp.length;
        while (i < tl && this.tp[i] == -1) {
            ++i;
        }
        int p = this.tp[i];
        int j = i + 1;
        while (j < tl && this.tp[j] == -1) {
            ++j;
        }
        int max = this.tp[tl - 1];
        while (p < max) {
            int oc = this.size(p, i);
            if (stats.adding(oc)) {
                stats.add(this.inY.readBytes(p, i), oc);
            }
            if ((p += i + 9) != this.tp[j]) continue;
            i = j;
            while (j + 1 < tl && this.tp[++j] == -1) {
            }
        }
    }

    private long pointer(long pt, int lt) {
        return this.inY.read5(pt + (long)lt);
    }

    private int size(long pt, int lt) {
        return this.inY.read4(pt + (long)lt + 5L);
    }

    private synchronized IndexIterator fuzzy(byte[] token, int k) {
        FTIndexIterator it = FTIndexIterator.FTEMPTY;
        int tokl = token.length;
        int tl = this.tp.length;
        int e = Math.min(tl - 1, tokl + k);
        int s = Math.max(1, tokl - k) - 1;
        while (++s <= e) {
            int p = this.tp[s];
            if (p == -1) continue;
            int t = s + 1;
            int r = -1;
            while (t < tl && r == -1) {
                r = this.tp[t++];
            }
            while (p < r) {
                if (this.ls.similar(this.inY.readBytes(p, s), token, k)) {
                    it = FTIndexIterator.union(FTIndex.iter(this.pointer(p, s), this.size(p, s), this.inZ, token), it);
                }
                p += s + 9;
            }
        }
        return it;
    }

    private synchronized IndexIterator wc(byte[] token) {
        FTIndexIterator it = FTIndexIterator.FTEMPTY;
        FTWildcard wc = new FTWildcard(token);
        if (!wc.parse()) {
            return it;
        }
        IntList pr = new IntList();
        IntList ps = new IntList();
        byte[] pref = wc.prefix();
        int pl = pref.length;
        int tl = this.tp.length;
        int l = Math.min(tl - 1, wc.max());
        int ti = pl;
        while (ti <= l) {
            int i = this.tp[ti];
            if (i != -1) {
                int c = ti + 1;
                int e = -1;
                while (c < tl && e == -1) {
                    e = this.tp[c++];
                }
                i = this.find(pref, i, e, ti);
                while (i < e) {
                    byte[] t = this.inY.readBytes(i, ti);
                    if (!Token.startsWith(t, pref)) break;
                    if (wc.match(t)) {
                        this.inZ.cursor(this.pointer(i, ti));
                        int s = this.size(i, ti);
                        int d = 0;
                        while (d < s) {
                            pr.add(this.inZ.readNum());
                            ps.add(this.inZ.readNum());
                            ++d;
                        }
                    }
                    i += ti + 9;
                }
            }
            ++ti;
        }
        return FTIndex.iter(new FTCache(pr, ps), token);
    }

    private static FTIndexIterator iter(long off, int size, DataAccess da, byte[] token) {
        da.cursor(off);
        IntList pr = new IntList(size);
        IntList ps = new IntList(size);
        int c = 0;
        while (c < size) {
            pr.add(da.readNum());
            ps.add(da.readNum());
            ++c;
        }
        return FTIndex.iter(new FTCache(pr, ps), token);
    }

    private static synchronized FTIndexIterator iter(final FTCache ftc, final byte[] token) {
        final int size = ftc.pre.size();
        return new FTIndexIterator(){
            final FTMatches all = new FTMatches();
            int pos;
            int pre;
            int c;

            @Override
            public synchronized boolean more() {
                if (this.c == size) {
                    return false;
                }
                this.all.reset(this.pos);
                this.pre = ftc.pre.get(ftc.order[this.c]);
                this.all.or(ftc.pos.get(ftc.order[this.c++]));
                while (this.c < size && this.pre == ftc.pre.get(ftc.order[this.c])) {
                    this.all.or(ftc.pos.get(ftc.order[this.c++]));
                }
                return true;
            }

            @Override
            public synchronized FTMatches matches() {
                return this.all;
            }

            @Override
            public synchronized int pre() {
                return this.pre;
            }

            @Override
            public void pos(int p) {
                this.pos = p;
            }

            @Override
            public synchronized int size() {
                return size;
            }

            public String toString() {
                return new TokenBuilder(token).add(40).addExt(size, new Object[0]).add("x)").toString();
            }
        };
    }

    @Override
    public void add(ValueCache vc) {
        throw Util.notExpected();
    }

    @Override
    public void delete(ValueCache vc) {
        throw Util.notExpected();
    }

    @Override
    public void flush() {
    }

    private static final class FTCache {
        private final int[] order;
        private final IntList pre;
        private final IntList pos;

        private FTCache(IntList pr, IntList ps) {
            int s = pr.size();
            double[] v = new double[s];
            int i = 0;
            while (i < s) {
                v[i] = (long)pr.get(i) << 32 | (long)ps.get(i);
                ++i;
            }
            this.order = Array.createOrder(v, true);
            this.pre = pr;
            this.pos = ps;
        }
    }
}

