/*
 * Decompiled with CFR 0.152.
 */
package org.basex.index;

import org.basex.index.IndexType;
import org.basex.util.Num;
import org.basex.util.Prop;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.hash.TokenIntMap;
import org.basex.util.list.BoolList;
import org.basex.util.list.IntList;
import org.basex.util.list.TokenList;

public class IndexTree {
    protected static final double FACTOR = 1.2;
    public final TokenList keys = new TokenList(1.2);
    public TokenList ids = new TokenList(1.2);
    protected TokenIntMap maps = new TokenIntMap();
    protected int cn;
    private final IntList tree = new IntList(1.2);
    private final BoolList mod = new BoolList();
    private final boolean tokenize;
    private int root = -1;

    public IndexTree(IndexType type) {
        this.tokenize = type == IndexType.TOKEN;
    }

    public final void add(byte[] key, int id, int pos) {
        this.add(key, id, pos, true);
    }

    protected final int add(byte[] key, int id, int pos, boolean exist) {
        if (this.root == -1) {
            this.root = this.newNode(key, id, pos, -1, exist);
            return this.root;
        }
        int n = this.root;
        while (true) {
            int ch;
            int diff;
            if ((diff = Token.diff(key, (byte[])this.keys.get(n))) == 0) {
                if (exist) {
                    this.addIds(id, pos, n);
                } else {
                    int i = this.maps.get(Num.num(n));
                    if (i < 0) {
                        this.maps.put(Num.num(n), this.ids.size());
                        this.addNewIds(id, pos);
                    } else {
                        this.addIds(id, pos, i);
                    }
                }
                return n;
            }
            int n2 = ch = diff < 0 ? this.left(n) : this.right(n);
            if (ch == -1) {
                ch = this.newNode(key, id, pos, n, exist);
                if (diff < 0) {
                    this.setLeft(n, ch);
                    this.adjust(this.left(n));
                } else {
                    this.setRight(n, ch);
                    this.adjust(this.right(n));
                }
                return ch;
            }
            n = ch;
        }
    }

    public final int size() {
        return this.ids.size();
    }

    public final void init() {
        this.cn = this.root;
        if (this.cn != -1) {
            while (this.left(this.cn) != -1) {
                this.cn = this.left(this.cn);
            }
        }
    }

    public final boolean more() {
        return this.cn != -1;
    }

    public final int next() {
        int ln = this.cn;
        if (this.right(this.cn) == -1) {
            int t = this.cn;
            this.cn = this.parent(this.cn);
            while (this.cn != -1 && t == this.right(this.cn)) {
                t = this.cn;
                this.cn = this.parent(this.cn);
            }
        } else {
            this.cn = this.right(this.cn);
            while (this.left(this.cn) != -1) {
                this.cn = this.left(this.cn);
            }
        }
        return ln;
    }

    private void addNewIds(int id, int pos) {
        byte[] vs = Num.newNum(id);
        if (this.tokenize) {
            vs = Num.add(vs, pos);
        }
        this.ids.add(vs);
    }

    private void addIds(int id, int pos, int n) {
        byte[] vs = (byte[])this.ids.get(n);
        vs = Num.add(vs, id);
        if (this.tokenize) {
            vs = Num.add(vs, pos);
        }
        this.ids.set(n, vs);
    }

    private int newNode(byte[] key, int id, int pos, int par, boolean exist) {
        this.tree.add(-1);
        this.tree.add(-1);
        this.tree.add(par);
        this.mod.add(false);
        this.keys.add(key);
        this.addNewIds(id, pos);
        if (!exist) {
            this.maps.put(Num.num(this.keys.size() - 1), this.ids.size() - 1);
        }
        return this.mod.size() - 1;
    }

    private int left(int nd) {
        return this.tree.get((nd << 1) + nd);
    }

    private int right(int nd) {
        return this.tree.get((nd << 1) + nd + 1);
    }

    private int parent(int nd) {
        return this.tree.get((nd << 1) + nd + 2);
    }

    private void setLeft(int nd, int val) {
        this.tree.set((nd << 1) + nd, val);
    }

    private void setRight(int nd, int val) {
        this.tree.set((nd << 1) + nd + 1, val);
    }

    private void setParent(int nd, int val) {
        this.tree.set((nd << 1) + nd + 2, val);
    }

    private void adjust(int nd) {
        int n = nd;
        this.mod.set(n, true);
        while (n != -1 && n != this.root && this.mod.get(this.parent(n))) {
            int y;
            if (this.parent(n) == this.left(this.parent(this.parent(n)))) {
                y = this.right(this.parent(this.parent(n)));
                if (y != -1 && this.mod.get(y)) {
                    this.mod.set(this.parent(n), false);
                    this.mod.set(y, false);
                    this.mod.set(this.parent(this.parent(n)), true);
                    n = this.parent(this.parent(n));
                    continue;
                }
                if (n == this.right(this.parent(n))) {
                    n = this.parent(n);
                    this.rotateLeft(n);
                }
                this.mod.set(this.parent(n), false);
                this.mod.set(this.parent(this.parent(n)), true);
                if (this.parent(this.parent(n)) == -1) continue;
                this.rotateRight(this.parent(this.parent(n)));
                continue;
            }
            y = this.left(this.parent(this.parent(n)));
            if (y != -1 && this.mod.get(y)) {
                this.mod.set(this.parent(n), false);
                this.mod.set(y, false);
                this.mod.set(this.parent(this.parent(n)), true);
                n = this.parent(this.parent(n));
                continue;
            }
            if (n == this.left(this.parent(n))) {
                n = this.parent(n);
                this.rotateRight(n);
            }
            this.mod.set(this.parent(n), false);
            this.mod.set(this.parent(this.parent(n)), true);
            if (this.parent(this.parent(n)) == -1) continue;
            this.rotateLeft(this.parent(this.parent(n)));
        }
        this.mod.set(this.root, false);
    }

    private void rotateLeft(int n) {
        int r = this.right(n);
        this.setRight(n, this.left(r));
        if (this.left(r) != -1) {
            this.setParent(this.left(r), n);
        }
        this.setParent(r, this.parent(n));
        if (this.parent(n) == -1) {
            this.root = r;
        } else if (this.left(this.parent(n)) == n) {
            this.setLeft(this.parent(n), r);
        } else {
            this.setRight(this.parent(n), r);
        }
        this.setLeft(r, n);
        this.setParent(n, r);
    }

    private void rotateRight(int n) {
        int l = this.left(n);
        this.setLeft(n, this.right(l));
        if (this.right(l) != -1) {
            this.setParent(this.right(l), n);
        }
        this.setParent(l, this.parent(n));
        if (this.parent(n) == -1) {
            this.root = l;
        } else if (this.right(this.parent(n)) == n) {
            this.setRight(this.parent(n), l);
        } else {
            this.setLeft(this.parent(n), l);
        }
        this.setRight(l, n);
        this.setParent(n, l);
    }

    public String toString() {
        TokenBuilder tb = new TokenBuilder();
        tb.add("IndexTree[Root: ").addInt(this.root).add(Prop.NL);
        int size = this.keys.size();
        int c = 0;
        while (c < size) {
            tb.add("  \"").add((byte[])this.keys.get(c)).add("\": ").add("ids");
            if (this.tokenize) {
                tb.add("/pos");
            }
            tb.add(": (").add(Num.toString((byte[])this.ids.get(c))).add(41);
            int left = this.tree.get(c * 3);
            int right = this.tree.get(c * 3 + 1);
            if (left >= 0) {
                tb.add(", left:").addInt(left);
            }
            if (right >= 0) {
                tb.add(", right:").addInt(right);
            }
            tb.add(Prop.NL);
            ++c;
        }
        tb.add("]");
        return tb.toString();
    }
}

