/*
 * Decompiled with CFR 0.152.
 */
package org.basex.index;

import java.io.IOException;
import org.basex.core.BaseXException;
import org.basex.core.MainOptions;
import org.basex.core.Text;
import org.basex.core.jobs.Job;
import org.basex.data.Data;
import org.basex.index.IndexNames;
import org.basex.index.IndexType;
import org.basex.index.value.ValueIndex;
import org.basex.util.Performance;
import org.basex.util.Prop;
import org.basex.util.Util;

public abstract class IndexBuilder
extends Job {
    private final Performance perf = new Performance();
    protected final Data data;
    protected final int size;
    protected final IndexType type;
    protected final boolean text;
    private final int splitSize;
    private final long maxMem = (long)((double)Runtime.getRuntime().maxMemory() * 0.8);
    private final IndexNames includeNames;
    protected int pre;
    protected long count;
    protected int splits;
    private int gcCount;

    protected IndexBuilder(Data data, IndexType type) {
        this.data = data;
        this.type = type;
        this.splitSize = (int)Math.min(Integer.MAX_VALUE, (long)data.meta.splitsize * (long)this.splitFactor());
        this.size = data.meta.size;
        this.includeNames = new IndexNames(type, data);
        boolean bl = this.text = type == IndexType.TEXT || type == IndexType.FULLTEXT;
        if (Performance.memory() >= this.maxMem) {
            this.clean();
        }
    }

    public abstract ValueIndex build() throws IOException;

    protected void check() throws IOException {
        this.checkStop();
        if (Prop.debug && (this.pre & 0x1FFFFF) == 0) {
            Util.err(".", new Object[0]);
        }
    }

    protected final boolean indexEntry() {
        return this.data.kind(this.pre) == (this.text ? 2 : 3) && this.includeNames.contains(this.pre, this.text);
    }

    protected final boolean splitRequired() throws IOException {
        boolean split;
        if (this.splitSize > 0) {
            split = this.count >= ((long)this.splits + 1L) * (long)this.splitSize;
        } else {
            split = Performance.memory() >= this.maxMem;
            int gc = this.gcCount;
            if (split) {
                if (gc >= 0) {
                    throw new BaseXException(String.valueOf(Text.OUT_OF_MEM) + Text.H_OUT_OF_MEM, new Object[0]);
                }
                gc = 30;
            } else {
                gc = Math.max(-1, gc - 1);
            }
            this.gcCount = gc;
        }
        if (split && Prop.debug) {
            Util.err("|", new Object[0]);
        }
        return split;
    }

    protected final void clean() {
        if (this.splitSize <= 0) {
            Performance.gc(2);
        }
    }

    protected final void finishIndex() {
        if (!Prop.debug) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(' ').append((double)(this.count / 10000L) / 100.0).append(" M operations, ");
        sb.append(this.perf).append(" (").append(Performance.getMemory()).append(").");
        if (this.splits > 1 && this.splitSize <= 0) {
            sb.append(" Recommended ").append(MainOptions.SPLITSIZE.name()).append(": ");
            sb.append((int)Math.ceil((double)this.count / (double)this.splits / (double)this.splitFactor())).append('.');
        }
        Util.errln(sb, new Object[0]);
    }

    private int splitFactor() {
        return this.type == IndexType.FULLTEXT ? 1000000 : 100000;
    }

    @Override
    public final String shortInfo() {
        return Text.CREATING_INDEXES;
    }

    @Override
    public final double progressInfo() {
        return (double)this.pre / ((double)this.size + (this.splits > 0 ? (double)this.size / 50.0 : 0.0));
    }

    @Override
    public final String detailedInfo() {
        switch (this.type) {
            case TEXT: {
                return Text.INDEX_TEXTS_D;
            }
            case ATTRIBUTE: {
                return Text.INDEX_ATTRIBUTES_D;
            }
            case TOKEN: {
                return Text.INDEX_TOKENS_D;
            }
            case FULLTEXT: {
                return Text.INDEX_FULLTEXT_D;
            }
        }
        throw Util.notExpected();
    }
}

