/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.view.project;

import java.io.IOException;
import java.util.HashSet;
import java.util.TreeMap;
import java.util.regex.Pattern;
import org.basex.core.Context;
import org.basex.gui.view.project.ProjectCache;
import org.basex.io.IO;
import org.basex.io.IOFile;
import org.basex.io.in.TextInput;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryProcessor;
import org.basex.util.InputInfo;
import org.basex.util.Performance;
import org.basex.util.Strings;
import org.basex.util.Token;
import org.basex.util.TokenParser;
import org.basex.util.Util;
import org.basex.util.XMLToken;
import org.basex.util.list.IntList;
import org.basex.util.list.StringList;

final class ProjectFiles {
    private static final int MAXHITS = 256;
    private static long parseId;
    private static long filterId;
    private TreeMap<String, InputInfo> errors = new TreeMap();
    private ProjectCache cache;

    ProjectFiles() {
    }

    void reset() {
        this.cache = null;
        ++filterId;
        ++parseId;
    }

    TreeMap<String, InputInfo> errors() {
        return this.errors;
    }

    String[] filter(String files, String contents, IOFile root) throws InterruptedException {
        long id = ++filterId;
        StringList results = new StringList();
        int[] search = new TokenParser(Token.lc(Token.token(contents))).toArray();
        ProjectCache pc = this.cache(root);
        if (files.contains("*") || files.contains("?")) {
            Pattern pt = Pattern.compile(IOFile.regex(files));
            for (String path : pc) {
                if (pt.matcher(path).matches() && ProjectFiles.filterContent(path, search)) {
                    results.add(path);
                    if (results.size() >= 256) break;
                }
                if (id == filterId) continue;
                throw new InterruptedException();
            }
        } else {
            ProjectFiles.filter(files, search, id, results, pc);
        }
        return (String[])results.finish();
    }

    void parse(IOFile root, Context ctx) throws InterruptedException {
        IOFile file;
        long id = ++parseId;
        HashSet<String> parsed = new HashSet<String>();
        TreeMap<String, InputInfo> errs = new TreeMap<String, InputInfo>();
        ProjectCache pc = this.cache(root);
        StringList mods = new StringList();
        StringList lmods = new StringList();
        for (String path : pc) {
            file = new IOFile(path);
            if (!file.hasSuffix(IO.XQSUFFIXES)) continue;
            (file.hasSuffix(".xqm") ? lmods : mods).add(path);
        }
        mods.add(lmods);
        for (String path : mods) {
            if (id != parseId) {
                throw new InterruptedException();
            }
            if (parsed.contains(path)) continue;
            file = new IOFile(path);
            try {
                Throwable throwable = null;
                Object var14_15 = null;
                try (TextInput ti = new TextInput(file);){
                    try {
                        Throwable throwable2 = null;
                        Object var17_21 = null;
                        try (QueryContext qc = new QueryContext(ctx);){
                            String input = ti.cache().toString();
                            boolean lib = QueryProcessor.isLibrary(input);
                            qc.parse(input, lib, path, null);
                            parsed.add(path);
                            for (byte[] mod : qc.modParsed) {
                                parsed.add(Token.string(mod));
                            }
                        }
                        catch (Throwable throwable3) {
                            if (throwable2 == null) {
                                throwable2 = throwable3;
                            } else if (throwable2 != throwable3) {
                                throwable2.addSuppressed(throwable3);
                            }
                            throw throwable2;
                        }
                    }
                    catch (QueryException ex) {
                        errs.put(path, ex.info());
                        parsed.add(path);
                    }
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    throw throwable;
                }
            }
            catch (IOException ex) {
                Util.debug(ex);
            }
        }
        this.errors = errs;
    }

    /*
     * Unable to fully structure code
     */
    private ProjectCache cache(IOFile root) throws InterruptedException {
        block1: {
            pc = this.cache;
            if (pc != null) ** GOTO lbl10
            this.cache = new ProjectCache();
            this.add(root, this.cache);
            this.cache.finish();
            break block1;
lbl-1000:
            // 1 sources

            {
                Performance.sleep(1L);
                if (pc == this.cache) continue;
                throw new InterruptedException();
lbl10:
                // 2 sources

                ** while (!pc.valid())
            }
        }
        return this.cache;
    }

    private void add(IOFile root, ProjectCache pc) throws InterruptedException {
        IOFile file;
        IOFile[] files;
        if (pc != this.cache) {
            throw new InterruptedException();
        }
        IOFile[] iOFileArray = files = root.children();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            file = iOFileArray[n2];
            if (file.name().equals(".ignore")) {
                return;
            }
            ++n2;
        }
        iOFileArray = files;
        n = files.length;
        n2 = 0;
        while (n2 < n) {
            file = iOFileArray[n2];
            if (file.isDir()) {
                this.add(file, pc);
            } else {
                pc.add(file.path());
            }
            ++n2;
        }
    }

    private static void filter(String files, int[] search, long id, StringList results, ProjectCache cache) throws InterruptedException {
        String query = files.replace('\\', '/');
        HashSet<String> exclude = new HashSet<String>();
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        boolean[] blArray2 = blArray;
        int n = blArray.length;
        int n2 = 0;
        while (n2 < n) {
            boolean onlyName = blArray2[n2];
            int mode = 0;
            while (mode < 5) {
                for (String path : cache) {
                    String file;
                    if (exclude.contains(path)) continue;
                    String string = file = onlyName ? path.substring(path.lastIndexOf(47) + 1) : path;
                    if (mode == 0 ? Strings.startsWith(file, query) : (mode == 1 ? Strings.contains(file, query) : Strings.matches(file, query))) {
                        if (ProjectFiles.filterContent(path, search)) {
                            results.add(path);
                            if (results.size() >= 256) {
                                return;
                            }
                        }
                        exclude.add(path);
                    }
                    if (id == filterId) continue;
                    throw new InterruptedException();
                }
                ++mode;
            }
            ++n2;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean filterContent(String path, int[] search) {
        int cl = search.length;
        if (cl == 0) {
            return true;
        }
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try {
                TextInput ti = new TextInput(new IOFile(path));
                try {
                    IntList il = new IntList(cl - 1);
                    int c = 0;
                    while (true) {
                        block16: {
                            if (!il.isEmpty()) {
                                if (il.remove(0) == search[c++]) continue;
                                c = 0;
                            }
                            do {
                                int cp;
                                if ((cp = ti.read()) == -1) return false;
                                if (!XMLToken.valid(cp)) {
                                    return false;
                                }
                                int lc = Token.lc(cp);
                                if (c > 0) {
                                    il.add(lc);
                                }
                                if (lc != search[c]) break block16;
                            } while (++c != cl);
                            return true;
                        }
                        c = 0;
                    }
                }
                finally {
                    if (ti == null) return false;
                    ti.close();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (IOException ex) {
            Util.debug(ex);
            return false;
        }
    }
}

