/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.view.explore;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.text.JTextComponent;
import org.basex.core.Text;
import org.basex.core.cmd.Find;
import org.basex.data.Data;
import org.basex.gui.GUIOptions;
import org.basex.gui.layout.BaseXBack;
import org.basex.gui.layout.BaseXCombo;
import org.basex.gui.layout.BaseXDSlider;
import org.basex.gui.layout.BaseXLabel;
import org.basex.gui.layout.BaseXLayout;
import org.basex.gui.layout.BaseXPanel;
import org.basex.gui.layout.BaseXTextField;
import org.basex.gui.layout.BaseXWindow;
import org.basex.gui.layout.TableLayout;
import org.basex.gui.view.explore.ExploreView;
import org.basex.index.name.Names;
import org.basex.index.stats.Stats;
import org.basex.index.stats.StatsType;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;
import org.basex.util.list.StringList;
import org.basex.util.list.TokenList;

final class ExploreArea
extends BaseXPanel
implements ActionListener {
    private static final int COMPW = 150;
    private static final String PATEX = "[% = \"%\"]";
    private static final String PATSUB = "[% contains text \"%\"]";
    private static final String PATNUM = "[% >= % and % <= %]";
    private static final String PATSIMPLE = "[%]";
    private final ExploreView main;
    private final BaseXBack panel;
    private final BaseXTextField all;
    private String last = "";

    ExploreArea(ExploreView m) {
        super(m.gui);
        this.main = m;
        this.layout(new BorderLayout(0, 5)).setOpaque(false);
        this.all = new BaseXTextField(this.gui);
        this.all.addKeyListener(this.main);
        this.all.addKeyListener(e -> this.query(false));
        this.add((Component)this.all, "North");
        this.panel = new BaseXBack(false).layout(new TableLayout(32, 2, 10, 5));
        this.add((Component)this.panel, "Center");
    }

    void init() {
        this.panel.removeAll();
        this.panel.revalidate();
        this.panel.repaint();
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Data data = this.gui.context.data();
        if (!this.main.visible() || data == null || this.panel.getComponentCount() != 0) {
            return;
        }
        this.addKeys(this.gui.context.data());
        this.panel.revalidate();
        this.panel.repaint();
    }

    private void addInput(int pos) {
        BaseXTextField txt = new BaseXTextField(this.gui);
        BaseXLayout.setWidth(txt, 150);
        txt.setPreferredSize(new Dimension(this.getPreferredSize().width, txt.getFont().getSize() + 11));
        txt.setMargin(new Insets(0, 0, 0, 10));
        txt.addKeyListener(e -> this.query(false));
        txt.addKeyListener(this.main);
        this.panel.add((Component)txt, pos);
    }

    private void addKeys(Data data) {
        TokenList tl = new TokenList();
        int cs = this.panel.getComponentCount();
        int c = 0;
        while (c < cs) {
            String elem;
            BaseXCombo combo = (BaseXCombo)this.panel.getComponent(c);
            if (combo.getSelectedIndex() != 0 && !(elem = combo.getSelectedItem()).startsWith("@")) {
                tl.add(Token.token(elem));
            }
            c += 2;
        }
        String[] entries = ExploreArea.entries(data.paths.desc(tl, true, false));
        BaseXCombo cm = new BaseXCombo((BaseXWindow)this.gui, entries);
        cm.addActionListener(this);
        cm.addKeyListener(this.main);
        if (entries.length == 1) {
            cm.setEnabled(false);
        }
        this.panel.add(cm);
        this.panel.add(new BaseXLabel(""));
    }

    private void addCombo(String[] values, int pos) {
        BaseXCombo cm = new BaseXCombo((BaseXWindow)this.gui, values);
        BaseXLayout.setWidth(cm, 150);
        cm.addActionListener(this);
        cm.addKeyListener(this.main);
        this.panel.add((Component)cm, pos);
    }

    private void addSlider(double min, double max, int pos, boolean itr) {
        BaseXDSlider sl = new BaseXDSlider(this.gui, min, max, this);
        BaseXLayout.setWidth(sl, 450);
        sl.itr = itr;
        sl.addKeyListener(this.main);
        this.panel.add((Component)sl, pos);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e != null) {
            Object source = e.getSource();
            int cp = 0;
            int cs = this.panel.getComponentCount();
            int c = 0;
            while (c < cs) {
                if (this.panel.getComponent(c) == source) {
                    cp = c;
                }
                ++c;
            }
            if (!(cp & true)) {
                boolean selected;
                BaseXCombo combo = (BaseXCombo)source;
                this.panel.remove(cp + 1);
                Data data = this.gui.context.data();
                boolean bl = selected = combo.getSelectedIndex() != 0;
                if (selected) {
                    String item = combo.getSelectedItem();
                    boolean att = item.startsWith("@");
                    Names names = att ? data.attrNames : data.elemNames;
                    byte[] key = Token.token(att ? item.substring(1) : item);
                    Stats stats = names.stats(names.id(key));
                    if (StatsType.isInteger(stats.type)) {
                        this.addSlider(stats.min, stats.max, cp + 1, true);
                    } else if (StatsType.isDouble(stats.type)) {
                        this.addSlider(stats.min, stats.max, cp + 1, false);
                    } else if (StatsType.isCategory(stats.type)) {
                        this.addCombo(ExploreArea.entries(new TokenList(stats.values)), cp + 1);
                    } else if (StatsType.isString(stats.type)) {
                        this.addInput(cp + 1);
                    } else {
                        this.panel.add((Component)new BaseXLabel(""), cp + 1);
                    }
                } else {
                    this.panel.add((Component)new BaseXLabel(""), cp + 1);
                }
                while (cp + 2 < this.panel.getComponentCount()) {
                    this.panel.remove(cp + 2);
                    this.panel.remove(cp + 2);
                }
                if (selected) {
                    this.addKeys(data);
                }
                this.panel.revalidate();
                this.panel.repaint();
            }
        }
        this.query(false);
    }

    private void query(boolean force) {
        String simple;
        TokenBuilder tb = new TokenBuilder();
        Data data = this.gui.context.data();
        int cs = this.panel.getComponentCount();
        int c = 0;
        while (c < cs) {
            BaseXCombo com = (BaseXCombo)this.panel.getComponent(c);
            int k = com.getSelectedIndex();
            if (k > 0) {
                String key = com.getSelectedItem().replaceAll("^(@?)(.*):", "$1*:");
                boolean attr = key.startsWith("@");
                Component comp = this.panel.getComponent(c + 1);
                String pattern = "";
                String val1 = null;
                String val2 = null;
                if (comp instanceof BaseXTextField) {
                    val1 = ((JTextComponent)comp).getText();
                    if (!val1.isEmpty()) {
                        if (val1.startsWith("\"")) {
                            val1 = val1.replaceAll("\"", "");
                            pattern = PATEX;
                        } else {
                            pattern = (attr ? data.meta.attrindex : data.meta.textindex) ? PATSUB : PATEX;
                        }
                    }
                } else if (comp instanceof BaseXCombo) {
                    BaseXCombo combo = (BaseXCombo)comp;
                    if (combo.getSelectedIndex() != 0) {
                        val1 = combo.getSelectedItem();
                        pattern = PATEX;
                    }
                } else if (comp instanceof BaseXDSlider) {
                    BaseXDSlider slider = (BaseXDSlider)comp;
                    if (slider.currMin != slider.min || slider.currMax != slider.max) {
                        double m = slider.currMin;
                        double n = slider.currMax;
                        val1 = (double)((long)m) == m ? Long.toString((long)m) : Double.toString(m);
                        val2 = (double)((long)n) == n ? Long.toString((long)n) : Double.toString(n);
                        pattern = PATNUM;
                    }
                }
                if (attr) {
                    key = "descendant-or-self::node()/" + key;
                    if (tb.isEmpty()) {
                        tb.add("//*");
                    }
                    if (pattern.isEmpty()) {
                        pattern = PATSIMPLE;
                    }
                } else {
                    tb.add("//" + key);
                    key = "text()";
                }
                tb.addExt(pattern, key, val1, key, val2);
            }
            c += 2;
        }
        String qu = tb.toString();
        boolean root = this.gui.context.root();
        boolean rt = this.gui.gopts.get(GUIOptions.FILTERRT);
        if (!(qu.isEmpty() || rt || root)) {
            qu = String.valueOf('.') + qu;
        }
        if (!(simple = this.all.getText().trim()).isEmpty()) {
            simple = Find.find(simple, this.gui.context, rt);
            String string = qu = qu.isEmpty() ? simple : String.valueOf(simple) + " | " + qu;
        }
        if (qu.isEmpty()) {
            String string = qu = rt || root ? "/" : ".";
        }
        if (!force && this.last.equals(qu)) {
            return;
        }
        this.last = qu;
        this.gui.simpleQuery(qu);
    }

    private static String[] entries(TokenList names) {
        StringList entries = new StringList();
        entries.add(Util.info(Text.ENTRIES_X, names.size()));
        for (byte[] k : names) {
            entries.add(Token.string(k));
        }
        return (String[])entries.sort(true, true, 1).finish();
    }
}

