/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.view.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Font;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import org.basex.build.json.JsonParserOptions;
import org.basex.core.Text;
import org.basex.core.cmd.Execute;
import org.basex.core.cmd.Test;
import org.basex.core.cmd.XQuery;
import org.basex.core.parse.CommandParser;
import org.basex.gui.GUIConstants;
import org.basex.gui.GUIMenu;
import org.basex.gui.GUIMenuCmd;
import org.basex.gui.GUIOptions;
import org.basex.gui.layout.BaseXBack;
import org.basex.gui.layout.BaseXButton;
import org.basex.gui.layout.BaseXDialog;
import org.basex.gui.layout.BaseXFileChooser;
import org.basex.gui.layout.BaseXHeader;
import org.basex.gui.layout.BaseXImages;
import org.basex.gui.layout.BaseXKeys;
import org.basex.gui.layout.BaseXLabel;
import org.basex.gui.layout.BaseXLayout;
import org.basex.gui.layout.BaseXSplit;
import org.basex.gui.layout.BaseXTabs;
import org.basex.gui.layout.GUICode;
import org.basex.gui.layout.TableLayout;
import org.basex.gui.text.SearchBar;
import org.basex.gui.text.SearchEditor;
import org.basex.gui.text.TextPanel;
import org.basex.gui.view.View;
import org.basex.gui.view.ViewNotifier;
import org.basex.gui.view.editor.EditorArea;
import org.basex.gui.view.project.ProjectView;
import org.basex.io.IO;
import org.basex.io.IOContent;
import org.basex.io.IOFile;
import org.basex.io.in.ArrayInput;
import org.basex.io.in.InputException;
import org.basex.io.in.NewlineInput;
import org.basex.io.parse.json.JsonConverter;
import org.basex.io.parse.xml.XmlParser;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryIOException;
import org.basex.query.QueryProcessor;
import org.basex.util.InputInfo;
import org.basex.util.Performance;
import org.basex.util.Prop;
import org.basex.util.Strings;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.list.BoolList;
import org.basex.util.list.StringList;
import org.xml.sax.SAXParseException;

public final class EditorView
extends View {
    private static final int WAIT_DELAY = 250;
    private static final int SEARCH_DELAY = 100;
    private static final Pattern LINK = Pattern.compile("(.*?), ([0-9]+)/([0-9]+)");
    final ProjectView project;
    final AbstractButton go;
    private final AbstractButton history;
    private final AbstractButton stop;
    private final AbstractButton test;
    private final SearchBar search;
    private final BaseXLabel info;
    private final BaseXLabel pos;
    private final BaseXSplit split;
    private final BaseXHeader header;
    private final BaseXTabs tabs;
    private IOFile execFile;
    private int statusID;
    private volatile QueryContext parseQC;
    private InputInfo inputInfo;
    public final GUICode posCode = new GUICode(){

        @Override
        public void execute(Object arg) {
            int[] lc = EditorView.this.getEditor().pos();
            EditorView.this.pos.setText(String.valueOf(lc[0]) + " : " + lc[1]);
        }
    };

    public EditorView(ViewNotifier notifier) {
        super("editor", notifier);
        this.layout(new BorderLayout());
        this.setBackground(GUIConstants.PANEL);
        this.header = new BaseXHeader(Text.EDITOR);
        this.tabs = new BaseXTabs(this.gui);
        this.tabs.setFocusable(Prop.MAC);
        this.tabs.addDragDrop();
        this.tabs.setTabLayoutPolicy(1);
        this.tabs.addMouseListener(e -> {
            Component comp;
            int i = this.tabs.indexAtLocation(e.getX(), e.getY());
            if (i != -1 && SwingUtilities.isMiddleMouseButton(e) && (comp = this.tabs.getComponentAt(i)) instanceof EditorArea) {
                this.close((EditorArea)comp);
            }
        });
        SearchEditor center = new SearchEditor(this.gui, this.tabs, null);
        this.search = center.bar();
        AbstractButton newB = BaseXButton.command(GUIMenuCmd.C_EDITNEW, this.gui);
        AbstractButton openB = BaseXButton.command(GUIMenuCmd.C_EDITOPEN, this.gui);
        AbstractButton saveB = BaseXButton.get("c_save", Text.SAVE, false, this.gui);
        AbstractButton find = this.search.button(Text.FIND_REPLACE);
        AbstractButton vars = BaseXButton.command(GUIMenuCmd.C_VARS, this.gui);
        this.history = BaseXButton.get("c_history", Text.RECENTLY_OPENED, false, this.gui);
        this.stop = BaseXButton.get("c_stop", Text.STOP, false, this.gui);
        this.stop.setEnabled(false);
        this.go = BaseXButton.get("c_go", BaseXLayout.addShortcut(Text.RUN_QUERY, BaseXKeys.EXEC1.toString()), false, this.gui);
        this.test = BaseXButton.get("c_test", BaseXLayout.addShortcut(Text.RUN_TESTS, BaseXKeys.UNIT.toString()), false, this.gui);
        BaseXBack buttons = new BaseXBack(false);
        buttons.layout(new TableLayout(1, 11)).border(0, 0, 4, 0);
        buttons.add(newB);
        buttons.add(openB);
        buttons.add(saveB);
        buttons.add(this.history);
        buttons.add(Box.createHorizontalStrut(4));
        buttons.add(find);
        buttons.add(Box.createHorizontalStrut(4));
        buttons.add(this.stop);
        buttons.add(this.go);
        buttons.add(vars);
        buttons.add(this.test);
        BaseXBack north = new BaseXBack(false).layout(new BorderLayout());
        north.add((Component)buttons, "West");
        north.add((Component)this.header, "East");
        this.search.editor(this.addTab(), false);
        this.info = new BaseXLabel().setText("OK", GUIConstants.Msg.SUCCESS);
        this.info.setFont(GUIConstants.font);
        this.pos = new BaseXLabel(" ");
        this.pos.setFont(GUIConstants.font);
        this.posCode.invokeLater();
        BaseXBack south = new BaseXBack(false).border(4, 0, 0, 0);
        south.layout(new BorderLayout(4, 0));
        south.add((Component)this.info, "Center");
        south.add((Component)this.pos, "East");
        BaseXBack main = new BaseXBack().border(5);
        main.setOpaque(false);
        main.layout(new BorderLayout());
        main.add((Component)north, "North");
        main.add((Component)center, "Center");
        main.add((Component)south, "South");
        this.project = new ProjectView(this);
        this.split = new BaseXSplit(true);
        this.split.setOpaque(false);
        this.split.add(this.project);
        this.split.add(main);
        this.split.init(new double[]{0.3, 0.7}, new double[]{0.0, 1.0});
        this.toggleProject();
        this.add((Component)this.split, "Center");
        this.refreshLayout();
        saveB.addActionListener(e -> {
            JPopupMenu pop = new JPopupMenu();
            StringBuilder mnem = new StringBuilder();
            JMenuItem sa = GUIMenu.newItem(GUIMenuCmd.C_EDITSAVE, this.gui, mnem);
            JMenuItem sas = GUIMenu.newItem(GUIMenuCmd.C_EDITSAVEAS, this.gui, mnem);
            sa.setEnabled(GUIMenuCmd.C_EDITSAVE.enabled(this.gui));
            sas.setEnabled(GUIMenuCmd.C_EDITSAVEAS.enabled(this.gui));
            pop.add(sa);
            pop.add(sas);
            pop.show(saveB, 0, saveB.getHeight());
        });
        this.history.addActionListener(e -> {
            JPopupMenu pm = new JPopupMenu();
            ActionListener al = ac -> this.open(new IOFile(ac.getActionCommand().replaceAll("(.*) \\[(.*)]", "$2/$1")));
            StringList opened = new StringList();
            EditorArea[] editorAreaArray = this.editors();
            int n = editorAreaArray.length;
            int n2 = 0;
            while (n2 < n) {
                EditorArea ea = editorAreaArray[n2];
                opened.add(ea.file().path());
                ++n2;
            }
            StringList hst = new StringList(18);
            StringList all = new StringList(this.gui.gopts.get(GUIOptions.EDITOR));
            int fl = Math.min(all.size(), e == null ? 18 : 7);
            int f = 0;
            while (f < fl) {
                hst.add((String)all.get(f));
                ++f;
            }
            Font f2 = null;
            for (String en : hst.sort(Prop.CASE)) {
                JMenuItem item = new JMenuItem(en.replaceAll("(.*)[/\\\\](.*)", "$2 [$1]"));
                if (opened.contains(en)) {
                    if (f2 == null) {
                        f2 = item.getFont().deriveFont(1);
                    }
                    item.setFont(f2);
                }
                pm.add(item).addActionListener(al);
            }
            al = ac -> this.history.getActionListeners()[0].actionPerformed(null);
            if (e != null && pm.getComponentCount() == 7) {
                pm.add(new JMenuItem("...")).addActionListener(al);
            }
            pm.show(this.history, 0, this.history.getHeight());
        });
        this.refreshHistory(null);
        this.info.addMouseListener(e -> this.markError(true));
        this.stop.addActionListener(e -> {
            this.stop.setEnabled(false);
            this.go.setEnabled(false);
            this.test.setEnabled(false);
            this.gui.stop();
        });
        this.go.addActionListener(e -> this.run(this.getEditor(), TextPanel.Action.EXECUTE));
        this.test.addActionListener(e -> this.run(this.getEditor(), TextPanel.Action.TEST));
        this.tabs.addChangeListener(e -> {
            EditorArea ea = this.getEditor();
            if (ea == null) {
                return;
            }
            this.search.editor(ea, true);
            this.gui.refreshControls();
            this.posCode.invokeLater();
            this.refreshMark();
            this.run(ea, TextPanel.Action.PARSE);
            this.gui.setTitle();
        });
        BaseXLayout.addDrop(this, file -> {
            if (file instanceof File) {
                this.open(new IOFile((File)file));
            }
        });
    }

    @Override
    public void refreshInit() {
    }

    @Override
    public void refreshFocus() {
    }

    @Override
    public void refreshMark() {
        boolean script = this.getEditor().file().hasSuffix(".bxs");
        boolean realtime = this.gui.gopts.get(GUIOptions.EXECRT);
        this.go.setEnabled(script || !realtime);
        this.test.setEnabled(!script);
    }

    @Override
    public void refreshContext(boolean more, boolean quick) {
    }

    @Override
    public void refreshLayout() {
        EditorArea[] editorAreaArray = this.editors();
        int n = editorAreaArray.length;
        int n2 = 0;
        while (n2 < n) {
            EditorArea edit = editorAreaArray[n2];
            edit.refreshLayout(GUIConstants.mfont);
            ++n2;
        }
        this.project.refreshLayout();
    }

    @Override
    public void refreshUpdate() {
    }

    @Override
    public boolean visible() {
        return this.gui.gopts.get(GUIOptions.SHOWEDITOR);
    }

    @Override
    public void visible(boolean v) {
        this.gui.gopts.set(GUIOptions.SHOWEDITOR, v);
    }

    @Override
    protected boolean db() {
        return false;
    }

    public void showProject() {
        if (!this.gui.gopts.get(GUIOptions.SHOWPROJECT).booleanValue()) {
            this.gui.gopts.invert(GUIOptions.SHOWPROJECT);
            this.split.visible(true);
        }
    }

    public void toggleProject() {
        boolean show = this.gui.gopts.get(GUIOptions.SHOWPROJECT);
        this.split.visible(show);
        if (show) {
            this.project.focus();
        } else {
            this.focusEditor();
        }
    }

    public void findFiles() {
        this.project.findFiles(this.getEditor());
    }

    public void focusEditor() {
        SwingUtilities.invokeLater(() -> {
            boolean bl = this.getEditor().requestFocusInWindow();
        });
    }

    public void jumpToFile() {
        EditorArea editor = this.getEditor();
        this.project.jumpTo(editor.file(), true);
    }

    public void tab(boolean next) {
        int s = this.tabs.getTabCount();
        int i = (s + this.tabs.getSelectedIndex() + (next ? 1 : -1)) % s;
        this.tabs.setSelectedIndex(i);
    }

    public void init(ArrayList<IOFile> files) {
        String[] fs;
        String[] stringArray = fs = this.gui.gopts.get(GUIOptions.OPEN);
        int n = fs.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            this.open(new IOFile(string), false, false);
            ++n2;
        }
        for (IOFile iOFile : files) {
            this.open(iOFile);
        }
        if (this.project.dir() == null) {
            IOFile iOFile;
            Object object = fs.length == 0 ? (files.isEmpty() ? null : files.get(0)) : (iOFile = new IOFile(fs[0]));
            if (iOFile != null) {
                this.project.rootPath(iOFile.parent(), false);
            }
        }
        this.gui.setTitle();
    }

    public void open() {
        BaseXFileChooser fc = new BaseXFileChooser(this.gui, Text.OPEN, this.gui.gopts.get(GUIOptions.WORKPATH));
        fc.filter("XQuery Files", IO.XQSUFFIXES);
        fc.filter("Command Scripts", ".bxs");
        fc.textFilters();
        IOFile[] iOFileArray = fc.multi().selectAll(BaseXFileChooser.Mode.FOPEN);
        int n = iOFileArray.length;
        int n2 = 0;
        while (n2 < n) {
            IOFile f = iOFileArray[n2];
            this.open(f);
            ++n2;
        }
    }

    public boolean save() {
        EditorArea edit = this.getEditor();
        return edit.opened() ? edit.save() : this.saveAs();
    }

    public boolean saveAs() {
        EditorArea edit = this.getEditor();
        String path = edit.opened() ? edit.file().path() : this.gui.gopts.get(GUIOptions.WORKPATH);
        BaseXFileChooser fc = new BaseXFileChooser(this.gui, Text.SAVE_AS, path);
        fc.filter("XQuery Files", IO.XQSUFFIXES);
        fc.filter("Command Scripts", ".bxs");
        fc.textFilters();
        fc.suffix(".xq");
        IOFile file = fc.select(BaseXFileChooser.Mode.FSAVE);
        if (file == null) {
            return false;
        }
        if (!edit.save(file)) {
            return false;
        }
        this.run(edit, TextPanel.Action.PARSE);
        return true;
    }

    public void newFile() {
        if (!this.visible()) {
            GUIMenuCmd.C_SHOWEDITOR.execute(this.gui);
        }
        this.refreshControls(this.addTab(), true);
    }

    public boolean delete(IOFile file) {
        EditorArea edit = this.find(file);
        if (edit != null) {
            this.close(edit);
        }
        return file.delete();
    }

    public EditorArea open(IOFile file) {
        return this.open(file, true, true);
    }

    private EditorArea open(IOFile file, boolean parse, boolean error) {
        EditorArea edit;
        if (!this.visible()) {
            GUIMenuCmd.C_SHOWEDITOR.execute(this.gui);
        }
        if ((edit = this.find(file)) != null) {
            this.tabs.setSelectedComponent(edit);
        } else {
            byte[] text;
            block9: {
                try {
                    text = this.read(file);
                    if (text != null) break block9;
                    return null;
                }
                catch (IOException ex) {
                    this.refreshHistory(null);
                    Util.debug(ex);
                    if (error) {
                        BaseXDialog.error(this.gui, Util.info(Text.FILE_NOT_OPENED_X, file));
                    }
                    return null;
                }
            }
            edit = this.getEditor();
            if (edit.opened() || edit.modified()) {
                edit = this.addTab();
            }
            edit.initText(text);
            edit.file(file, error);
            if (parse) {
                this.run(edit, TextPanel.Action.PARSE);
            }
        }
        this.focusEditor();
        return edit;
    }

    void run(EditorArea editor, TextPanel.Action action) {
        IOFile file;
        this.refreshControls(editor, false);
        byte[] text = editor.getText();
        if (Token.eq(text, editor.last) && action == TextPanel.Action.CHECK) {
            return;
        }
        editor.last = text;
        if (this.gui.gopts.get(GUIOptions.SAVERUN).booleanValue() && (action == TextPanel.Action.EXECUTE || action == TextPanel.Action.TEST)) {
            EditorArea[] editorAreaArray = this.editors();
            int n = editorAreaArray.length;
            int n2 = 0;
            while (n2 < n) {
                EditorArea edit = editorAreaArray[n2];
                if (edit.opened()) {
                    edit.save();
                }
                ++n2;
            }
        }
        boolean xquery = (file = editor.file()).hasSuffix(IO.XQSUFFIXES) || !file.name().contains(".");
        boolean script = file.hasSuffix(".bxs");
        if (action == TextPanel.Action.TEST) {
            if (xquery) {
                this.gui.execute(true, new Test(file.path()));
            }
        } else if (action == TextPanel.Action.EXECUTE && script) {
            this.gui.execute(true, new Execute(Token.string(text)));
        } else if (action == TextPanel.Action.EXECUTE || xquery) {
            String input = Token.string(text);
            if (action == TextPanel.Action.EXECUTE || this.gui.gopts.get(GUIOptions.EXECRT).booleanValue()) {
                if (!xquery || QueryProcessor.isLibrary(input)) {
                    EditorArea ea = this.execEditor();
                    if (ea == null) {
                        return;
                    }
                    file = ea.file();
                    input = Token.string(ea.getText());
                }
                this.gui.execute(true, new XQuery(input).baseURI(file.path()));
                this.execFile = file;
            } else {
                this.parse(input.isEmpty() ? "()" : input, file, QueryProcessor.isLibrary(input));
            }
        } else if (file.hasSuffix(".json")) {
            try {
                IOContent io = new IOContent(text);
                io.name(file.path());
                JsonConverter.get(new JsonParserOptions()).convert(io);
                this.info(null);
            }
            catch (IOException ex) {
                this.info(ex);
            }
        } else if (script || file.hasSuffix(IO.XMLSUFFIXES) || file.hasSuffix(IO.XSLSUFFIXES)) {
            ArrayInput ai = new ArrayInput(text);
            try {
                if (Token.startsWith(text, 60) || !script) {
                    new XmlParser().parse(ai);
                }
                if (script) {
                    CommandParser.get(Token.string(text), this.gui.context).parse();
                }
                this.info(null);
            }
            catch (Exception ex) {
                this.info(ex);
            }
        } else if (action != TextPanel.Action.CHECK) {
            this.info(null);
        } else {
            this.info.setText("OK", GUIConstants.Msg.SUCCESS);
        }
    }

    private void info(Exception ex) {
        this.info(ex, false, false);
    }

    private EditorArea execEditor() {
        IOFile file = this.execFile;
        if (file != null) {
            EditorArea[] editorAreaArray = this.editors();
            int n = editorAreaArray.length;
            int n2 = 0;
            while (n2 < n) {
                EditorArea edit = editorAreaArray[n2];
                if (edit.file().path().equals(file.path())) {
                    return edit;
                }
                ++n2;
            }
            this.execFile = null;
        }
        return null;
    }

    private byte[] read(IOFile file) throws IOException {
        try {
            return new NewlineInput(file).validate(true).content();
        }
        catch (InputException ex) {
            Util.debug(ex);
            String button = BaseXDialog.yesNoCancel(this.gui, Text.H_FILE_BINARY, new String[0]);
            if (button == Text.B_NO) {
                return new NewlineInput(file).content();
            }
            if (button == Text.B_YES) {
                try {
                    file.open();
                }
                catch (IOException ioex) {
                    Util.debug(ioex);
                    Desktop.getDesktop().open(file.file());
                }
            }
            return null;
        }
    }

    void refreshHistory(IOFile file) {
        StringList paths = new StringList();
        if (file != null) {
            String path = file.path();
            this.gui.gopts.set(GUIOptions.WORKPATH, file.dir());
            paths.add(path);
            this.tabs.setToolTipTextAt(this.tabs.getSelectedIndex(), path);
        }
        String[] old = this.gui.gopts.get(GUIOptions.EDITOR);
        int ol = old.length;
        int p = 0;
        while (paths.size() < 18 && p < ol) {
            IO fl = IO.get(old[p]);
            if (fl.exists() && !fl.eq(file)) {
                paths.add(fl.path());
            }
            ++p;
        }
        this.gui.gopts.set(GUIOptions.EDITOR, (String[])paths.finish());
        this.history.setEnabled(!paths.isEmpty());
    }

    public void closeAll() {
        EditorArea[] editorAreaArray = this.editors();
        int n = editorAreaArray.length;
        int n2 = 0;
        while (n2 < n) {
            EditorArea ea = editorAreaArray[n2];
            this.closeEditor(ea);
            ++n2;
        }
        this.gui.saveOptions();
    }

    public void close(EditorArea edit) {
        this.closeEditor(edit);
        this.gui.saveOptions();
    }

    private void closeEditor(EditorArea edit) {
        EditorArea ea = edit != null ? edit : this.getEditor();
        int t = this.tabs.getTabCount();
        if (t == 1 && !ea.modified() && !ea.opened() || !this.confirm(ea)) {
            return;
        }
        if (this.execFile != null && ea.file().path().equals(this.execFile.path())) {
            this.execFile = null;
        }
        this.tabs.remove(ea);
        if (t == 1) {
            this.addTab();
            SwingUtilities.invokeLater(this::toggleProject);
        } else {
            this.focusEditor();
        }
    }

    public void pleaseWait(final int id) {
        new Timer(true).schedule(new TimerTask(){

            @Override
            public void run() {
                if (EditorView.this.gui.running(id)) {
                    EditorView.this.info.setText(Text.PLEASE_WAIT_D, GUIConstants.Msg.SUCCESS).setToolTipText(null);
                    EditorView.this.stop.setEnabled(true);
                }
            }
        }, 250L);
    }

    private void parse(final String input, final IO file, final boolean lib) {
        final int id = ++this.statusID;
        new Timer(true).schedule(new TimerTask(){

            @Override
            public void run() {
                while (EditorView.this.parseQC != null) {
                    Performance.sleep(1L);
                }
                if (id != EditorView.this.statusID) {
                    return;
                }
                try {
                    try {
                        Throwable throwable = null;
                        Object var2_4 = null;
                        try (QueryContext qc = new QueryContext(EditorView.this.gui.context);){
                            EditorView.this.parseQC = qc;
                            qc.parse(input, lib, file.path(), null);
                            if (id == EditorView.this.statusID) {
                                EditorView.this.info(null);
                            }
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    catch (QueryException ex) {
                        if (id == EditorView.this.statusID) {
                            EditorView.this.info(ex);
                        }
                        EditorView.this.parseQC = null;
                    }
                }
                finally {
                    EditorView.this.parseQC = null;
                }
            }
        }, 100L);
    }

    public void info(Throwable th, boolean stopped, boolean refresh) {
        if (!refresh && this.stop.isEnabled()) {
            return;
        }
        ++this.statusID;
        EditorArea editor = this.getEditor();
        String path = "";
        if (editor != null) {
            path = editor.file().path();
            editor.resetError();
        }
        if (refresh) {
            this.stop.setEnabled(false);
            this.refreshMark();
        }
        if (stopped || th == null) {
            this.info.setCursor(GUIConstants.CURSORARROW);
            this.info.setText(stopped ? Text.INTERRUPTED : "OK", GUIConstants.Msg.SUCCESS);
            this.info.setToolTipText(null);
            this.inputInfo = null;
        } else {
            this.info.setCursor(GUIConstants.CURSORHAND);
            this.info.setText(th.getLocalizedMessage(), GUIConstants.Msg.ERROR);
            String tt = th.getMessage().replace("<", "&lt;").replace(">", "&gt;").replaceAll("\r?\n", "<br/>").replaceAll("(<br/>.*?)<br/>.*", "$1");
            this.info.setToolTipText("<html>" + tt + "</html>");
            if (th instanceof QueryIOException) {
                this.inputInfo = ((QueryIOException)th).getCause().info();
            } else if (th instanceof QueryException) {
                this.inputInfo = ((QueryException)th).info();
            } else if (th instanceof SAXParseException) {
                SAXParseException ex = (SAXParseException)th;
                this.inputInfo = new InputInfo(path, ex.getLineNumber(), ex.getColumnNumber());
            } else {
                this.inputInfo = new InputInfo(path, 1, 1);
            }
            this.markError(false);
        }
    }

    public void jump(String link) {
        Matcher m = LINK.matcher(link);
        if (m.matches()) {
            this.inputInfo = new InputInfo(m.group(1), Strings.toInt(m.group(2)), Strings.toInt(m.group(3)));
            this.markError(true);
        } else {
            Util.stack("No match found: " + link);
        }
    }

    public void markError(boolean jump) {
        EditorArea edit;
        String path;
        boolean error;
        InputInfo ii = this.inputInfo;
        boolean bl = error = ii == null;
        if (error) {
            TreeMap<String, InputInfo> errors = this.project.errors();
            if (errors.isEmpty()) {
                return;
            }
            path = errors.get(errors.keySet().iterator().next()).path();
        } else {
            path = ii.path();
        }
        if (path == null) {
            return;
        }
        IOFile file = new IOFile(path);
        EditorArea ea = this.find(file);
        if (jump) {
            edit = this.open(file, error, true);
            if (ea == null && error) {
                ii = this.inputInfo;
            }
        } else {
            edit = ea;
        }
        if (edit == null || ii == null) {
            return;
        }
        int ep = EditorView.pos(edit.last, ii.line(), ii.column());
        edit.error(ep);
        if (jump) {
            edit.setCaret(ep);
            this.posCode.invokeLater();
            if (ea == null && this.project.getWidth() != 0) {
                this.project.jumpTo(edit.file(), false);
            }
        }
    }

    private static int pos(byte[] text, int line, int col) {
        int ll;
        int ep = ll = text.length;
        int p = 0;
        int l = 1;
        int c = 1;
        while (p < ll) {
            if (l > line || l == line && c == col) {
                ep = p;
                break;
            }
            if (text[p] == 10) {
                ++l;
                c = 0;
            }
            ++c;
            p += Token.cl(text, p);
        }
        if (ep < ll && Character.isLetterOrDigit(Token.cp(text, ep))) {
            while (ep > 0 && Character.isLetterOrDigit(Token.cp(text, ep - 1))) {
                --ep;
            }
        }
        return ep;
    }

    public String[] openFiles() {
        StringList files = new StringList();
        EditorArea[] editorAreaArray = this.editors();
        int n = editorAreaArray.length;
        int n2 = 0;
        while (n2 < n) {
            EditorArea edit = editorAreaArray[n2];
            if (edit.opened()) {
                files.add(edit.file().path());
            }
            ++n2;
        }
        return (String[])files.finish();
    }

    public EditorArea getEditor() {
        Component c = this.tabs.getSelectedComponent();
        return c instanceof EditorArea ? (EditorArea)c : null;
    }

    public void rename(IOFile old, IOFile renamed) {
        try {
            boolean dir = renamed.isDir();
            String oldPath = String.valueOf(old.file().getCanonicalPath()) + (dir ? File.separator : "");
            Component[] componentArray = this.tabs.getComponents();
            int n = componentArray.length;
            int n2 = 0;
            while (n2 < n) {
                EditorArea ea;
                Component c = componentArray[n2];
                if (c instanceof EditorArea && (ea = (EditorArea)c).opened()) {
                    String editPath = ea.file().file().getCanonicalPath();
                    if (dir) {
                        if (editPath.startsWith(oldPath)) {
                            ea.file(new IOFile(renamed, editPath.substring(oldPath.length())), true);
                        }
                    } else if (oldPath.equals(editPath)) {
                        ea.file(renamed, true);
                        ea.label.setText(renamed.name());
                        break;
                    }
                }
                ++n2;
            }
        }
        catch (IOException ex) {
            Util.errln(ex, new Object[0]);
        }
    }

    void refreshControls(EditorArea edit, boolean force) {
        boolean mod;
        boolean bl = mod = edit.hist != null && edit.hist.modified();
        if (mod == edit.modified() && !force) {
            return;
        }
        edit.modified(mod);
        String title = edit.file().name();
        if (mod) {
            title = String.valueOf(title) + '*';
        }
        edit.label.setText(title);
        this.gui.refreshControls();
        this.gui.setTitle();
        this.posCode.invokeLater();
        this.refreshMark();
    }

    private EditorArea find(IO file) {
        EditorArea[] editorAreaArray = this.editors();
        int n = editorAreaArray.length;
        int n2 = 0;
        while (n2 < n) {
            EditorArea edit = editorAreaArray[n2];
            if (edit.file().eq(file)) {
                return edit;
            }
            ++n2;
        }
        return null;
    }

    private IOFile newTabFile() {
        BoolList bl = new BoolList();
        EditorArea[] editorAreaArray = this.editors();
        int n = editorAreaArray.length;
        int n2 = 0;
        while (n2 < n) {
            EditorArea edit = editorAreaArray[n2];
            if (!edit.opened()) {
                String n3 = edit.file().name().substring(Text.FILE.length());
                bl.set(n3.isEmpty() ? 1 : Integer.parseInt(n3), true);
            }
            ++n2;
        }
        int b = 0;
        int bs = bl.size();
        while (++b < bs && bl.get(b)) {
        }
        return new IOFile(this.gui.gopts.get(GUIOptions.WORKPATH), String.valueOf(Text.FILE) + (b == 1 ? "" : Integer.valueOf(b)));
    }

    private EditorArea addTab() {
        EditorArea edit = new EditorArea(this, this.newTabFile());
        edit.setFont(GUIConstants.mfont);
        BaseXBack tab = new BaseXBack(false).layout(new BorderLayout(10, 0));
        tab.add((Component)edit.label, "Center");
        AbstractButton close = this.tabButton("e_close", "e_close2");
        close.addActionListener(e -> this.close(edit));
        tab.add((Component)close, "East");
        this.tabs.add((Component)edit, tab, this.tabs.getTabCount());
        return edit;
    }

    private AbstractButton tabButton(String icon, String rollover) {
        AbstractButton close = BaseXButton.get(icon, null, false, this.gui);
        close.setBorder(BaseXLayout.border(2, 0, 2, 0));
        close.setContentAreaFilled(false);
        close.setFocusable(false);
        close.setRolloverIcon(BaseXImages.icon(rollover));
        return close;
    }

    public boolean confirm(EditorArea edit) {
        String[] stringArray;
        EditorArea[] editorAreaArray;
        boolean all;
        boolean bl = all = edit == null;
        if (all) {
            editorAreaArray = this.editors();
        } else {
            EditorArea[] editorAreaArray2 = new EditorArea[1];
            editorAreaArray = editorAreaArray2;
            editorAreaArray2[0] = edit;
        }
        EditorArea[] eas = editorAreaArray;
        if (all && eas.length > 1) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = Text.CLOSE_ALL;
        } else {
            stringArray = new String[]{};
        }
        String[] buttons = stringArray;
        EditorArea[] editorAreaArray3 = eas;
        int n = eas.length;
        int n2 = 0;
        while (n2 < n) {
            EditorArea ea = editorAreaArray3[n2];
            this.tabs.setSelectedComponent(ea);
            if (ea.modified() && (ea.opened() || ea.getText().length != 0)) {
                String msg = Util.info(Text.CLOSE_FILE_X, ea.file().name());
                String action = BaseXDialog.yesNoCancel(this.gui, msg, buttons);
                if (action == null || action.equals(Text.B_YES) && !this.save()) {
                    return false;
                }
                if (action.equals(Text.CLOSE_ALL)) break;
            }
            ++n2;
        }
        return true;
    }

    private EditorArea[] editors() {
        ArrayList<EditorArea> edits = new ArrayList<EditorArea>();
        Component[] componentArray = this.tabs.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component c = componentArray[n2];
            if (c instanceof EditorArea) {
                edits.add((EditorArea)c);
            }
            ++n2;
        }
        return edits.toArray(new EditorArea[edits.size()]);
    }
}

