/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.view.editor;

import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.IOException;
import javax.swing.SwingUtilities;
import org.basex.core.Text;
import org.basex.gui.GUIOptions;
import org.basex.gui.layout.BaseXDialog;
import org.basex.gui.layout.BaseXImages;
import org.basex.gui.layout.BaseXKeys;
import org.basex.gui.layout.BaseXLabel;
import org.basex.gui.text.SearchBar;
import org.basex.gui.text.TextPanel;
import org.basex.gui.view.editor.EditorView;
import org.basex.io.IOFile;
import org.basex.util.Util;

public final class EditorArea
extends TextPanel {
    final BaseXLabel label;
    private IOFile file;
    private boolean modified;
    byte[] last;
    private final EditorView view;
    private long tstamp;

    EditorArea(EditorView view, IOFile file) {
        super(view.gui, true);
        this.view = view;
        this.file = file;
        this.label = new BaseXLabel(file.name());
        this.label.setIcon(BaseXImages.file(new IOFile(".xq")));
        this.setSyntax(file, false);
        this.addFocusListener(e -> {
            this.gui.gopts.set(GUIOptions.WORKPATH, this.file.dir());
            SwingUtilities.invokeLater(() -> this.reopen(false));
        });
    }

    public boolean opened() {
        return this.tstamp != 0L;
    }

    public boolean modified() {
        return this.modified;
    }

    void modified(boolean mod) {
        this.modified = mod;
    }

    public IOFile file() {
        return this.file;
    }

    void initText(byte[] t) {
        this.last = t;
        super.setText(t);
        this.hist.init(this.getText());
    }

    @Override
    public void setText(byte[] t) {
        this.last = this.getText();
        super.setText(t);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        super.mouseReleased(e);
        this.view.posCode.invokeLater();
    }

    @Override
    public void keyPressed(KeyEvent e) {
        byte[] text = this.editor.text();
        super.keyPressed(e);
        if (text != this.editor.text()) {
            this.resetError();
        }
        this.view.posCode.invokeLater();
    }

    @Override
    public void keyTyped(KeyEvent e) {
        byte[] text = this.editor.text();
        super.keyTyped(e);
        if (text != this.editor.text()) {
            this.resetError();
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
        boolean exec = this.gui.editor.go.isEnabled();
        if (BaseXKeys.EXEC1.is(e)) {
            if (exec) {
                this.release(TextPanel.Action.EXECUTE);
            }
        } else if (BaseXKeys.UNIT.is(e)) {
            if (exec) {
                this.release(TextPanel.Action.TEST);
            }
        } else if ((!e.isActionKey() || BaseXKeys.MOVEDOWN.is(e) || BaseXKeys.MOVEUP.is(e)) && !BaseXKeys.modifier(e)) {
            this.release(TextPanel.Action.CHECK);
        }
    }

    @Override
    protected void release(TextPanel.Action action) {
        this.view.run(this, action);
    }

    public void reopen(boolean enforce) {
        if (this.opened()) {
            long ts = this.file.timeStamp();
            if (!(this.tstamp == ts && !enforce || this.modified && !BaseXDialog.confirm(this.gui, Util.info(Text.REOPEN_FILE_X, this.file.name())))) {
                try {
                    this.setText(this.file.read());
                    this.file(this.file, false);
                    this.release(TextPanel.Action.PARSE);
                }
                catch (IOException ex) {
                    Util.debug(ex);
                    BaseXDialog.error(this.gui, Util.info(Text.FILE_NOT_OPENED_X, this.file));
                }
            }
            this.tstamp = ts;
        }
    }

    boolean save() {
        return this.save(this.file);
    }

    boolean save(IOFile io) {
        boolean rename;
        boolean bl = rename = io != this.file;
        if (rename || this.modified) {
            try {
                io.write(this.getText());
                this.file(io, true);
                this.view.project.save(io, rename);
                return true;
            }
            catch (Exception ex) {
                Util.debug(ex);
                BaseXDialog.error(this.gui, Util.info(Text.FILE_NOT_SAVED_X, io));
            }
        }
        return false;
    }

    public void jump(String string) {
        this.search.activate(string, false);
        this.jump(SearchBar.SearchDir.CURRENT, true);
    }

    void file(IOFile io, boolean save) {
        if (io != this.file) {
            this.file = io;
            this.label.setIcon(BaseXImages.file(io));
            this.setSyntax(io, true);
            this.repaint();
        }
        this.tstamp = this.file.timeStamp();
        this.hist.save();
        this.view.refreshHistory(this.file);
        this.view.refreshControls(this, true);
        if (save) {
            this.gui.saveOptions();
        }
    }
}

