/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.text;

import java.text.Collator;
import java.util.Arrays;
import java.util.Comparator;
import org.basex.core.Text;
import org.basex.core.jobs.JobException;
import org.basex.gui.GUI;
import org.basex.gui.GUIOptions;
import org.basex.gui.text.ReplaceContext;
import org.basex.gui.text.SearchBar;
import org.basex.gui.text.SearchContext;
import org.basex.gui.text.Syntax;
import org.basex.util.FTToken;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;
import org.basex.util.XMLToken;
import org.basex.util.list.ByteList;
import org.basex.util.list.IntList;
import org.basex.util.list.TokenList;

public final class TextEditor {
    private static final char[] ALLOWED = new char[]{':', '-'};
    private static final String OPENING = "{([";
    private static final String CLOSING = "})]";
    IntList[] searchResults = new IntList[]{new IntList(), new IntList()};
    int start = -1;
    int end = -1;
    int error = -1;
    private final GUI gui;
    private SearchContext searchContext;
    private Thread searchThread;
    private byte[] text = Token.EMPTY;
    private int lines = -1;
    private int pos;

    TextEditor(GUI gui) {
        this.gui = gui;
    }

    boolean text(byte[] txt) {
        if (Token.eq(txt, this.text)) {
            return false;
        }
        int tl = txt.length;
        this.text = txt;
        this.lines = -1;
        this.noSelect();
        this.search(this.searchContext, false);
        if (this.pos > tl) {
            this.pos = tl;
        }
        return true;
    }

    void search(SearchContext sc, boolean jump) {
        if (sc == null) {
            return;
        }
        Thread t = this.searchThread;
        if (t != null) {
            t.interrupt();
        }
        t = new Thread(() -> {
            try {
                this.searchResults = sc.search(this.text, jump);
                this.searchContext = sc;
                this.searchThread = null;
            }
            catch (JobException jobException) {
            }
            catch (Exception ex) {
                String info = Util.message(ex).replaceAll(String.valueOf(Text.NL) + ".*", "");
                this.gui.status.setError(String.valueOf(Text.REGULAR_EXPR) + ": " + info);
            }
        });
        t.setDaemon(true);
        t.start();
        this.searchThread = t;
    }

    int[] replace(ReplaceContext rc) {
        int ts = this.size();
        int s = Math.min(this.start, this.end);
        int e = Math.max(this.start, this.end);
        boolean sel = this.selected();
        if (sel) {
            int p = s - 1;
            while (++p < e && this.text[p] != 10) {
            }
            boolean bl = sel = p < e;
        }
        if (!sel) {
            s = 0;
            e = ts;
        }
        return rc.replace(this.searchContext, this.text, s, e);
    }

    int lines() {
        if (this.lines == -1) {
            int c = 1;
            byte[] byArray = this.text;
            int n = this.text.length;
            int n2 = 0;
            while (n2 < n) {
                byte ch = byArray[n2];
                if (ch == 10) {
                    ++c;
                }
                ++n2;
            }
            this.lines = c;
        }
        return this.lines;
    }

    private void forward(boolean select) {
        if (select || !this.selected()) {
            this.next();
        } else {
            this.pos(Math.max(this.start, this.end));
        }
    }

    void next(boolean select) {
        if (select && !this.selected()) {
            this.startSelect();
        }
        this.forward(select);
        if (select) {
            this.endSelection();
        }
    }

    void previous(boolean select) {
        if (select && !this.selected()) {
            this.startSelect();
        }
        this.back(select);
        if (select) {
            this.endSelection();
        }
    }

    /*
     * Unable to fully structure code
     */
    void nextWord(boolean select) {
        block8: {
            block10: {
                block9: {
                    if (select && !this.selected()) {
                        this.startSelect();
                    }
                    ch = this.curr();
                    this.forward(select);
                    if (ch == 10) break block8;
                    if (!FTToken.lod(ch)) break block9;
                    while (FTToken.lod(ch)) {
                        ch = this.next();
                    }
                    while (ch != 10 && FTToken.ws(ch)) {
                        ch = this.next();
                    }
                    break block10;
                }
                if (!FTToken.ws(ch)) ** GOTO lbl21
                while (ch != 10 && FTToken.ws(ch)) {
                    ch = this.next();
                }
                break block10;
lbl-1000:
                // 1 sources

                {
                    ch = this.next();
lbl21:
                    // 2 sources

                    ** while (ch != 10 && !FTToken.lod((int)ch) && !FTToken.ws((int)ch))
                }
lbl22:
                // 2 sources

                while (ch != 10 && FTToken.ws(ch)) {
                    ch = this.next();
                }
            }
            if (this.pos != this.size()) {
                this.prev();
            }
        }
        if (select) {
            this.endSelection();
        }
    }

    /*
     * Unable to fully structure code
     */
    void prevWord(boolean select) {
        block7: {
            block9: {
                block8: {
                    if (select && !this.selected()) {
                        this.startSelect();
                    }
                    if ((ch = this.back(select)) == 10) break block7;
                    if (!FTToken.lod(ch)) break block8;
                    while (FTToken.lod(ch)) {
                        ch = this.prev();
                    }
                    break block9;
                }
                if (!FTToken.ws(ch)) ** GOTO lbl19
                while (ch != 10 && FTToken.ws(ch)) {
                    ch = this.prev();
                }
                while (FTToken.lod(ch)) {
                    ch = this.prev();
                }
                break block9;
lbl-1000:
                // 1 sources

                {
                    ch = this.prev();
lbl19:
                    // 2 sources

                    ** while (ch != 10 && !FTToken.lod((int)ch) && !FTToken.ws((int)ch))
                }
            }
            if (this.pos != 0) {
                this.next();
            }
        }
        if (select) {
            this.endSelection();
        }
    }

    int completionStart() {
        int p = this.pos;
        while (p > 0 && TextEditor.completeMore(this.text[p - 1])) {
            --p;
        }
        return p;
    }

    private static boolean completeMore(byte ch) {
        if (Token.letterOrDigit(ch)) {
            return true;
        }
        char[] cArray = ALLOWED;
        int n = ALLOWED.length;
        int n2 = 0;
        while (n2 < n) {
            char a = cArray[n2];
            if (ch == a) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    void textStart(boolean select) {
        this.startSelection(select);
        this.pos = 0;
        if (select) {
            this.endSelection();
        }
    }

    void textEnd(boolean select) {
        this.startSelection(select);
        this.pos = this.size();
        if (select) {
            this.endSelection();
        }
    }

    public byte[] text() {
        return this.text;
    }

    private int indent() {
        return Math.max(1, this.gui.gopts.get(GUIOptions.INDENT));
    }

    private byte[] spaces() {
        byte[] spaces;
        if (this.gui.gopts.get(GUIOptions.TABSPACES).booleanValue()) {
            spaces = new byte[this.indent()];
            Arrays.fill(spaces, (byte)32);
        } else {
            spaces = new byte[]{9};
        }
        return spaces;
    }

    private int bol(boolean select) {
        if (this.pos == 0) {
            if (!select) {
                this.noSelect();
            }
            return 0;
        }
        int ind = this.indent();
        int c = 0;
        do {
            c += this.curr() == 9 ? ind : 1;
        } while (this.back(select) != 10);
        if (this.pos != 0 || this.curr() == 10) {
            this.forward(select);
        }
        return c;
    }

    void lineStart(boolean select) {
        if (select && !this.selected()) {
            this.startSelect();
        }
        int p = this.pos;
        boolean s = true;
        while (this.back(select) != 10) {
            s &= FTToken.ws(this.curr());
        }
        if (this.pos != 0 || this.curr() == 10) {
            this.forward(select);
        }
        if (p == this.pos || !s) {
            while (FTToken.ws(this.curr()) && this.curr() != 10) {
                this.forward(select);
            }
        }
        if (select) {
            this.endSelection();
        }
    }

    void lineEnd(boolean select) {
        this.startSelection(select);
        this.forward(Integer.MAX_VALUE, select);
        if (select) {
            this.endSelection();
        }
    }

    private int back(boolean select) {
        if (select || !this.selected()) {
            return this.prev();
        }
        this.pos(Math.min(this.start, this.end));
        return this.curr();
    }

    private int prev() {
        if (this.pos == 0) {
            return 10;
        }
        while (--this.pos > 0 && this.text[this.pos] < -64) {
        }
        return this.curr();
    }

    private void forward(int p, boolean select) {
        int ind = this.indent();
        int nc = 0;
        while (this.curr() != 10) {
            if ((nc += this.curr() == 9 ? ind : 1) >= p) {
                return;
            }
            this.forward(select);
        }
    }

    int linesUp(int l, boolean select, int lastCol) {
        this.startSelection(select);
        int col = this.bol(select);
        if (this.pos() == 0) {
            col = -1;
        } else {
            if (lastCol != -1) {
                col = lastCol;
            }
            int i = 0;
            while (i < l) {
                this.back(select);
                this.bol(select);
                ++i;
            }
            this.forward(col, select);
        }
        if (select) {
            this.endSelection();
        }
        return col;
    }

    int linesDown(int l, boolean select, int lastCol) {
        this.startSelection(select);
        int lc = lastCol == -1 ? this.bol(select) : lastCol;
        int i = 0;
        while (i < l) {
            this.forward(Integer.MAX_VALUE, select);
            this.forward(select);
            ++i;
        }
        this.forward(lc, select);
        if (this.pos() == this.size()) {
            lc = -1;
        }
        if (select) {
            this.endSelection();
        }
        return lc;
    }

    void add(String str) {
        int cl = str.length();
        TokenBuilder tb = new TokenBuilder(cl);
        int c = 0;
        while (c < cl) {
            int ch = str.charAt(c);
            if (ch != 13 && (ch >= 32 || Token.ws(ch))) {
                if (Character.isHighSurrogate((char)ch) && c + 1 < cl) {
                    ch = Character.toCodePoint((char)ch, str.charAt(++c));
                }
                tb.add(ch);
            }
            ++c;
        }
        this.insert(tb.finish(), this.pos, this.pos);
        this.pos += tb.size();
    }

    boolean comment(Syntax syntax) {
        int off;
        byte[] st = syntax.commentOpen();
        byte[] en = syntax.commentEnd();
        byte[] ste = Token.concat(st, Token.SPACE);
        byte[] ene = Token.concat(Token.SPACE, en);
        int sl = st.length;
        int el = en.length;
        int sle = ste.length;
        int ele = ene.length;
        if (!this.selected()) {
            this.start = this.pos;
            this.end = this.pos;
            while (this.start > 0 && this.text[this.start - 1] != 10) {
                --this.start;
            }
            while (this.end < this.size() && this.text[this.end] != 10) {
                ++this.end;
            }
        } else if (this.start > this.end) {
            int s = this.start;
            this.start = this.end;
            this.end = s;
        }
        while (this.start < this.end && Token.ws(this.text[this.start])) {
            ++this.start;
        }
        while (this.end > this.start && Token.ws(this.text[this.end - 1])) {
            --this.end;
        }
        int min = this.start;
        int max = this.end;
        if (this.selected() && this.text[max - 1] == 10) {
            --max;
        }
        TokenBuilder tb = new TokenBuilder();
        int mx = Math.max(min + sl, max - el);
        int mxe = Math.max(min + sle, max - ele);
        if (Token.indexOf(this.text, ste, min) == min && Token.indexOf(this.text, ene, mxe) == mxe) {
            tb.add(this.text, min + sle, max - ele);
            off = -sle - ele;
        } else if (Token.indexOf(this.text, st, min) == min && Token.indexOf(this.text, en, mx) == mx) {
            tb.add(this.text, min + sl, max - el);
            off = -sl - el;
        } else {
            tb.add(ste).add(this.text, min, max).add(ene);
            off = sle + ele;
        }
        boolean added = this.insert(tb.finish(), min, max);
        this.select(min, max + off);
        return added;
    }

    private boolean insert(byte[] string, int offset, int rem) {
        int ts = this.size();
        int al = string.length;
        byte[] tmp = new byte[offset + al + ts - rem];
        System.arraycopy(this.text, 0, tmp, 0, offset);
        System.arraycopy(string, 0, tmp, offset, al);
        System.arraycopy(this.text, rem, tmp, offset + al, ts - rem);
        return this.text(tmp);
    }

    boolean toCase(Case cs) {
        if (!this.selected()) {
            return false;
        }
        int s = Math.min(this.start, this.end);
        int e = Math.max(this.start, this.end);
        int d = this.size() - e;
        byte[] tmp = Token.substring(this.text, s, e);
        TokenBuilder tb = new TokenBuilder(this.size());
        tb.add(this.text, 0, s);
        tb.add(cs == Case.LOWER ? Token.lc(tmp) : (cs == Case.UPPER ? Token.uc(tmp) : Token.tc(tmp)));
        tb.add(this.text, e, this.size());
        boolean changed = this.text(tb.finish());
        this.select(s, this.size() - d);
        return changed;
    }

    void move(boolean down) {
        if (!this.extend()) {
            return;
        }
        int s = this.start;
        int e = this.end;
        int ts = this.size();
        byte[] tmp = Arrays.copyOf(this.text, ts);
        if (down) {
            if (e == ts) {
                return;
            }
            this.pos = e;
            this.lineEnd(true);
            int c = s;
            int i = e;
            while (i < this.pos) {
                tmp[c++] = this.text[i];
                ++i;
            }
            tmp[c++] = 10;
            i = s;
            while (i < e - 1) {
                tmp[c++] = this.text[i];
                ++i;
            }
            this.text(tmp);
            this.select(s + this.pos - e + 1, Math.min(ts, this.pos + 1));
        } else {
            if (s == 0) {
                return;
            }
            this.pos = s - 1;
            this.bol(true);
            int c = this.pos;
            int i = s;
            while (i < e) {
                tmp[c++] = this.text[i];
                ++i;
            }
            if (tmp[c - 1] != 10) {
                tmp[c++] = 10;
            }
            i = this.pos;
            while (i < s && c < ts) {
                tmp[c++] = this.text[i];
                ++i;
            }
            this.text(tmp);
            this.select(this.pos, this.pos + e - s);
        }
    }

    void complete(String value, int p) {
        int ind;
        String v = value;
        int car = v.indexOf(95);
        if (car != -1) {
            v = v.replace("_", "");
        }
        if ((ind = this.open()) != 0) {
            StringBuilder spaces = new StringBuilder();
            int i = 0;
            while (i < ind) {
                spaces.append(' ');
                ++i;
            }
            v = new TokenBuilder().addSep(v.split("\n"), "\n" + spaces).toString();
        }
        this.replace(p, this.pos, v);
        if (car != -1) {
            this.pos = p + car;
        }
    }

    boolean format(Syntax syntax) {
        boolean sel = this.selected();
        int s = sel ? Math.min(this.start, this.end) : 0;
        int e = sel ? Math.max(this.start, this.end) : this.size();
        byte[] format = syntax.format(Arrays.copyOfRange(this.text, s, e), this.spaces());
        boolean changed = this.insert(format, s, e);
        this.select(s, s + format.length);
        return changed;
    }

    boolean sort() {
        if (!this.selected()) {
            this.selectAll();
        }
        if (!this.extend()) {
            return false;
        }
        int l = 1;
        int s = this.start;
        int e = this.end;
        int ts = this.size();
        byte[] tmp = Arrays.copyOf(this.text, ts);
        int i = s;
        while (i < e) {
            if (tmp[i] == 10) {
                ++l;
            }
            ++i;
        }
        TokenList tl = new TokenList(l);
        ByteList bl = new ByteList();
        int i2 = s;
        while (i2 < e) {
            byte ch = tmp[i2];
            if (ch == 10) {
                tl.add(bl.next());
            } else {
                bl.add(ch);
            }
            ++i2;
        }
        if (!bl.isEmpty()) {
            tl.add(bl.finish());
        }
        this.sort(tl);
        i2 = s;
        for (byte[] line : tl) {
            int ll = line.length;
            System.arraycopy(line, 0, tmp, i2, ll);
            if ((i2 += ll) >= e) continue;
            tmp[i2++] = 10;
        }
        if (i2 < e) {
            System.arraycopy(tmp, e, tmp, i2, ts - e);
        }
        boolean changed = this.text(i2 == e ? tmp : Arrays.copyOf(tmp, ts - e + i2));
        this.select(s, i2);
        return changed;
    }

    private void sort(TokenList tokens) {
        GUIOptions gopts = this.gui.gopts;
        boolean asc = gopts.get(GUIOptions.ASCSORT);
        boolean cs = gopts.get(GUIOptions.CASESORT);
        Collator coll = gopts.get(GUIOptions.UNICODE) != false ? null : Collator.getInstance();
        int column = gopts.get(GUIOptions.COLUMN) - 1;
        if (coll != null || column > 0) {
            tokens.sort(true, true);
        }
        Comparator cc = (token1, token2) -> {
            byte[] tok1 = TextEditor.sub(token1, column);
            byte[] tok2 = TextEditor.sub(token2, column);
            return coll != null ? coll.compare(Token.string(tok1), Token.string(tok2)) : Token.diff(cs ? Token.lc(tok1) : tok1, cs ? Token.lc(tok2) : tok2);
        };
        tokens.sort(cc, asc);
        if (gopts.get(GUIOptions.MERGEDUPL).booleanValue()) {
            tokens.unique();
        }
    }

    private static byte[] sub(byte[] token, int column) {
        int tl = token.length;
        int t = 0;
        int c = 0;
        while (t < tl && c < column) {
            t += Token.cl(token, t);
            ++c;
        }
        return Token.substring(token, t);
    }

    boolean indent(StringBuilder sb, boolean shift) {
        if (!this.selected() && shift && this.size() != 0) {
            this.selectLine();
        }
        if (this.selected()) {
            this.indent(shift);
            sb.setLength(0);
            return this.selected();
        }
        if (shift) {
            sb.setLength(0);
        } else {
            boolean c = this.pos > 0;
            int p = this.pos - 1;
            while (p >= 0 && c) {
                byte b = this.text[p];
                if (!Token.ws(b)) {
                    return false;
                }
                if (b == 10) break;
                --p;
            }
            sb.setLength(0);
            sb.append(Token.string(this.spaces()));
        }
        return false;
    }

    int enter(StringBuilder sb) {
        int p;
        boolean opening = this.pos > 0 && OPENING.indexOf(this.text[this.pos - 1]) != -1;
        boolean closing = this.pos < this.size() && CLOSING.indexOf(this.text[this.pos]) != -1;
        int ind = this.indent();
        int indent = this.open();
        int move = 0;
        if (opening) {
            if (closing) {
                p = 0;
                while (p < indent + ind) {
                    sb.append(' ');
                    ++p;
                }
                move = indent + ind + 1;
                sb.append('\n');
            } else {
                indent += ind;
            }
        } else if (closing) {
            indent -= ind;
        }
        p = 0;
        while (p < indent) {
            sb.append(' ');
            ++p;
        }
        this.add(sb, false);
        return move;
    }

    int add(StringBuilder sb, boolean selected) {
        if (sb.length() == 0) {
            return 0;
        }
        int move = 0;
        if (!selected && this.gui.gopts.get(GUIOptions.AUTO).booleanValue()) {
            char ch = sb.charAt(0);
            byte next = this.pos + 1 < this.size() ? this.text[this.pos + 1] : (byte)0;
            byte curr = this.pos < this.size() ? this.text[this.pos] : (byte)0;
            byte prev = this.pos > 0 ? this.text[this.pos - 1] : (byte)0;
            byte pprv = this.pos > 1 ? this.text[this.pos - 2] : (byte)0;
            int opening = OPENING.indexOf(ch);
            if (opening != -1) {
                if (CLOSING.indexOf(curr) != -1 || curr == 0 || Token.ws(curr) || curr == 60) {
                    sb.append(CLOSING.charAt(opening));
                    move = 1;
                }
            } else if (CLOSING.indexOf(ch) != -1) {
                if (ch == curr) {
                    sb.setLength(0);
                    move = 1;
                }
                this.close();
            } else if (ch == '\"' || ch == '\'') {
                if (ch == curr) {
                    sb.setLength(0);
                } else if (!XMLToken.isNCChar(prev) && !XMLToken.isNCChar(curr)) {
                    sb.append(ch);
                }
                move = 1;
            } else if (ch == '>') {
                this.closeElem(sb);
                move = 1;
            } else if (ch == ':') {
                if (prev == 40) {
                    sb.append(':');
                    if (curr != 41) {
                        sb.append(')');
                    }
                    move = 1;
                }
            } else if (ch == '~') {
                if (prev == 58 && pprv == 40) {
                    sb.append("  ");
                    if (curr != 58) {
                        sb.append(':');
                        if (curr != 41) {
                            sb.append(')');
                        }
                    } else if (next != 41) {
                        sb.append(')');
                    }
                    move = 2;
                }
            } else if (ch == '-') {
                if (prev == 45 && pprv == 33 && this.pos > 2 && this.text[this.pos - 3] == 60) {
                    sb.append("  -->\n");
                    move = 2;
                }
            } else if (ch == '?' && prev == 60) {
                sb.append(" ?>\n");
                move = 1;
            }
        }
        this.add(sb.toString());
        return move;
    }

    private void close() {
        int p = this.pos - 1;
        while (p >= 0) {
            byte b = this.text[p];
            if (b == 10) break;
            if (!Token.ws(b)) {
                return;
            }
            --p;
        }
        if (++p >= this.pos) {
            return;
        }
        this.start = Math.max(this.pos - this.indent(), p);
        this.end = Math.max(this.pos, p);
        if (this.start != this.end) {
            this.delete();
        }
    }

    private void closeElem(StringBuilder sb) {
        int p = this.pos;
        while (this.pos() > 0) {
            int cp = this.prev();
            if (XMLToken.isNCChar(cp) || cp == 58) continue;
            if (cp != 60 || this.pos >= p - 1) break;
            this.next();
            sb.append("</").append(new TokenBuilder().add(this.text, this.pos, p)).append('>');
            break;
        }
        this.pos = p;
    }

    void deletePrev() {
        if (!this.selected()) {
            if (this.pos == 0) {
                return;
            }
            this.startSelect();
            int curr = this.curr();
            int prev = this.prev();
            this.endSelection();
            if (this.gui.gopts.get(GUIOptions.AUTO).booleanValue()) {
                if (curr == prev && (curr == 34 || curr == 39)) {
                    ++this.start;
                } else {
                    int open = OPENING.indexOf(prev);
                    if (open != -1 && CLOSING.indexOf(curr) == open) {
                        ++this.start;
                    }
                }
            }
        }
        this.del();
    }

    void delete() {
        if (!this.selected()) {
            if (this.pos == this.size()) {
                return;
            }
            this.start = this.pos;
            this.end = this.pos + Token.cl(this.text, this.pos);
        }
        this.del();
    }

    private void del() {
        int s = Math.min(this.start, this.end);
        int e = Math.max(this.start, this.end);
        int ts = this.size();
        byte[] tmp = new byte[ts - e + s];
        System.arraycopy(this.text, 0, tmp, 0, s);
        System.arraycopy(this.text, e, tmp, s, ts - e);
        this.text(tmp);
        this.pos = s;
    }

    void deleteLine() {
        this.selectLine();
        this.delete();
    }

    void deleteNext(boolean word) {
        if (!this.selected()) {
            if (this.pos() == this.size()) {
                return;
            }
            this.startSelect();
            if (word) {
                this.nextWord(true);
            } else {
                this.lineEnd(true);
            }
            this.endSelection();
        }
        this.delete();
    }

    void deletePrev(boolean word) {
        if (!this.selected()) {
            if (this.pos() == 0) {
                return;
            }
            this.startSelect();
            if (word) {
                this.prevWord(true);
            } else {
                this.bol(true);
            }
            this.endSelection();
        }
        this.delete();
    }

    private void replace(int s, int e, String value) {
        this.select(s, e);
        this.delete();
        this.add(value);
    }

    private boolean extend() {
        if (!this.selected()) {
            this.selectLine();
            if (!this.selected()) {
                return false;
            }
        }
        int s = Math.min(this.start, this.end);
        int e = Math.max(this.start, this.end);
        int ts = this.size();
        while (s > 0 && this.text[s - 1] != 10) {
            --s;
        }
        if (e > 0) {
            while (e < ts && this.text[e - 1] != 10) {
                ++e;
            }
        }
        this.start = s;
        this.end = e;
        return true;
    }

    private void indent(boolean shift) {
        if (!this.extend()) {
            return;
        }
        int s = this.start;
        int e = this.end;
        int ind = this.indent();
        byte[] spaces = this.spaces();
        TokenBuilder tb = new TokenBuilder();
        int p = s;
        while (p < e) {
            if (p == 0 || this.text[p - 1] == 10) {
                int i = 0;
                do {
                    byte cp;
                    if ((cp = this.text[p]) == 9) {
                        i += ind;
                        continue;
                    }
                    if (cp != 32) break;
                    ++i;
                } while (++p < e);
                i = shift ? Math.max(0, i - ind) : i + ind;
                int c = 0;
                while (c < i / ind) {
                    tb.add(spaces);
                    ++c;
                }
                c = 0;
                while (c < i % ind) {
                    tb.add(32);
                    ++c;
                }
            }
            if (p < e) {
                tb.addByte(this.text[p]);
            }
            ++p;
        }
        this.insert(tb.finish(), s, e);
        this.select(s, s + tb.size());
    }

    private int open() {
        int ind = this.indent();
        int indent = 0;
        int p = this.pos - 1;
        while (p >= 0) {
            byte b = this.text[p];
            if (b == 10) break;
            indent = b == 9 ? (indent += ind) : (b == 32 ? ++indent : 0);
            --p;
        }
        return indent;
    }

    int size() {
        return this.text.length;
    }

    int pos() {
        return this.pos;
    }

    void pos(int p) {
        this.pos = p;
        this.noSelect();
    }

    void noSelect() {
        this.start = -1;
        this.end = -1;
    }

    void select(int p, boolean select) {
        this.pos = p;
        if (select) {
            this.startSelect();
        } else {
            this.end = this.pos;
        }
    }

    void selectAll() {
        this.select(0, this.size());
    }

    void select(int s, int e) {
        this.start = s;
        this.end = e;
        this.pos = e;
        this.checkSelection();
    }

    void startSelection(boolean select) {
        if (select) {
            if (!this.selected()) {
                this.startSelect();
            }
        } else {
            this.noSelect();
        }
    }

    void endSelection() {
        this.end = this.pos;
        this.checkSelection();
    }

    private void checkSelection() {
        if (this.start == this.end) {
            this.noSelect();
        }
    }

    boolean selected() {
        return this.start != this.end;
    }

    String copy() {
        TokenBuilder tb = new TokenBuilder();
        int e = this.start < this.end ? this.end : this.start;
        int s = this.start < this.end ? this.start : this.end;
        while (s < e) {
            int cp = Token.cp(this.text, s);
            if (cp >= 32 && cp < 57344 || cp == 10 || cp == 9 || cp > 63743) {
                tb.add(cp);
            }
            s += Token.cl(this.text, s);
        }
        return tb.toString();
    }

    void selectWord() {
        int cp;
        boolean ch = FTToken.lod(this.curr());
        while (this.pos() > 0) {
            cp = this.back(true);
            if (cp != 10 && ch == FTToken.lod(cp)) continue;
            this.forward(true);
            break;
        }
        this.startSelect();
        while (this.pos() < this.size()) {
            cp = this.curr();
            if (cp == 10 || ch != FTToken.lod(cp)) break;
            this.forward(true);
        }
        this.endSelection();
    }

    void selectLine() {
        this.bol(false);
        this.startSelect();
        this.forward(Integer.MAX_VALUE, true);
        this.next();
        this.endSelection();
    }

    private int curr() {
        return this.pos < 0 || this.pos >= this.size() ? 10 : Token.cp(this.text, this.pos);
    }

    private int next() {
        int c = this.curr();
        if (this.pos < this.size()) {
            this.pos += Token.cl(this.text, this.pos);
        }
        return c;
    }

    private void startSelect() {
        this.start = this.pos;
        this.end = this.pos;
    }

    void error(int s) {
        this.error = s;
    }

    int jump(SearchBar.SearchDir dir, boolean select) {
        if (this.searchResults[0].isEmpty()) {
            if (select) {
                this.noSelect();
            }
            return -1;
        }
        int s = this.searchResults[0].sortedIndexOf(!select || this.selected() ? this.pos : this.pos - 1);
        switch (dir) {
            case CURRENT: {
                s = s < 0 ? -s - 1 : s;
                break;
            }
            case FORWARD: {
                s = s < 0 ? -s - 1 : s + 1;
                break;
            }
            case BACKWARD: {
                s = s < 0 ? -s - 2 : s - 1;
            }
        }
        int sl = this.searchResults[0].size();
        if (s < 0) {
            s = sl - 1;
        } else if (s == sl) {
            s = 0;
        }
        int p = this.searchResults[0].get(s);
        if (select) {
            this.start = this.searchResults[1].get(s);
            this.end = p;
        }
        this.pos = p;
        return p;
    }

    public String toString() {
        return this.copy();
    }

    public static enum Case {
        LOWER,
        UPPER,
        TITLE;

    }
}

