/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.text;

import java.awt.Color;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashSet;
import org.basex.data.DataText;
import org.basex.gui.GUIConstants;
import org.basex.gui.text.Syntax;
import org.basex.gui.text.TextIterator;
import org.basex.query.QueryText;
import org.basex.query.expr.CmpN;
import org.basex.query.expr.CmpV;
import org.basex.query.expr.path.Axis;
import org.basex.query.func.Function;
import org.basex.query.util.NSGlobal;
import org.basex.util.Atts;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;
import org.basex.util.XMLToken;

final class SyntaxXQuery
extends Syntax {
    private static final String OPENING = "{(";
    private static final String CLOSING = "})";
    private static final HashSet<String> KEYWORDS = new HashSet();
    private int comment;
    private int quote;
    private boolean var;
    private boolean elem;

    static {
        try {
            Field o;
            Field f;
            Object[] objectArray = QueryText.class.getFields();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                f = objectArray[n2];
                if ("IGNORE".equals(f.getName())) break;
                Collections.addAll(KEYWORDS, ((String)f.get(null)).split("-"));
                ++n2;
            }
            objectArray = Function.VALUES;
            n = Function.VALUES.length;
            n2 = 0;
            while (n2 < n) {
                f = objectArray[n2];
                Collections.addAll(KEYWORDS, Token.string(((Function)((Object)f)).local()).split("-"));
                ++n2;
            }
            objectArray = Axis.VALUES;
            n = Axis.VALUES.length;
            n2 = 0;
            while (n2 < n) {
                Field a = objectArray[n2];
                Collections.addAll(KEYWORDS, ((Axis)((Object)a)).name);
                ++n2;
            }
            objectArray = CmpV.OpV.VALUES;
            n = CmpV.OpV.VALUES.length;
            n2 = 0;
            while (n2 < n) {
                o = objectArray[n2];
                Collections.addAll(KEYWORDS, ((CmpV.OpV)((Object)o)).name);
                ++n2;
            }
            objectArray = CmpN.OpN.VALUES;
            n = CmpN.OpN.VALUES.length;
            n2 = 0;
            while (n2 < n) {
                o = objectArray[n2];
                Collections.addAll(KEYWORDS, ((CmpN.OpN)((Object)o)).name);
                ++n2;
            }
            Atts ns = NSGlobal.NS;
            int n3 = 0;
            while (n3 < ns.size()) {
                KEYWORDS.add(Token.string(ns.name(n3)));
                ++n3;
            }
        }
        catch (Exception ex) {
            Util.stack(ex);
        }
    }

    SyntaxXQuery() {
    }

    @Override
    public void init(Color color) {
        super.init(color);
        this.quote = 0;
        this.var = false;
        this.elem = false;
        this.comment = 0;
    }

    @Override
    public Color getColor(TextIterator iter) {
        int ch = iter.curr();
        if (this.quote != 0) {
            if (ch == this.quote) {
                this.quote = 0;
            }
            return GUIConstants.VALUE;
        }
        if (this.comment == 0 && ch == 40) {
            ++this.comment;
        } else if (this.comment == 1) {
            this.comment = ch == 58 ? 2 : 0;
        } else if (this.comment == 2 && ch == 58) {
            ++this.comment;
        } else if (this.comment == 3 && ch != 58) {
            int n = this.comment = ch == 41 ? 0 : 2;
        }
        if (this.comment != 0) {
            this.var = false;
            return GUIConstants.COMMENT;
        }
        if (ch == 34 || ch == 39) {
            this.quote = ch;
            return GUIConstants.VALUE;
        }
        if (ch == 36) {
            this.var = true;
            return GUIConstants.VARIABLE;
        }
        if (this.var) {
            this.var = XMLToken.isChar(ch);
            return GUIConstants.VARIABLE;
        }
        if (Token.digit(ch) && Token.toLong(Token.token(iter.currString())) != Long.MIN_VALUE) {
            return GUIConstants.DIGIT;
        }
        if (!XMLToken.isNCChar(ch)) {
            this.elem = ch == 60 || ch == 37;
            return GUIConstants.COMMENT;
        }
        if (!this.elem && KEYWORDS.contains(iter.currString())) {
            return GUIConstants.KEYWORD;
        }
        this.elem = false;
        return this.plain;
    }

    @Override
    public byte[] commentOpen() {
        return DataText.XQCOMM_O;
    }

    @Override
    public byte[] commentEnd() {
        return DataText.XQCOMM_C;
    }

    @Override
    public byte[] format(byte[] text, byte[] spaces) {
        int ind = 0;
        TokenBuilder tb = new TokenBuilder();
        int tl = text.length;
        int t = 0;
        while (t < tl) {
            int i;
            byte prev;
            byte ch = text[t];
            int open = OPENING.indexOf(ch);
            int close = CLOSING.indexOf(ch);
            byte next = t + 1 < tl ? text[t + 1] : (byte)0;
            byte by = prev = t > 0 ? text[t - 1] : (byte)0;
            if (open != -1 && (next != 58 || ch != 40)) {
                ++ind;
                tb.addByte(ch);
                if (next != 10 && !SyntaxXQuery.matches(CLOSING.charAt(open), t, text, 3)) {
                    tb.add(10);
                    i = 0;
                    while (i < ind) {
                        tb.add(spaces);
                        ++i;
                    }
                }
            } else if (close != -1 && (prev != 58 || ch != 41)) {
                --ind;
                if (!SyntaxXQuery.spaces(tb) && !SyntaxXQuery.matches(OPENING.charAt(close), t, text, -3)) {
                    tb.add(10);
                    i = 0;
                    while (i < ind) {
                        tb.add(spaces);
                        ++i;
                    }
                }
                tb.addByte(ch);
            } else {
                tb.addByte(ch);
            }
            ++t;
        }
        return tb.finish();
    }

    private static boolean spaces(TokenBuilder text) {
        int t = text.size() - 1;
        while (t >= 0) {
            byte c = text.get(t);
            if (c == 10) break;
            if (!Token.ws(c)) {
                return false;
            }
            --t;
        }
        return true;
    }

    private static boolean matches(char ch, int pos, byte[] text, int dist) {
        int d = 0;
        while (!(dist > 0 ? d >= dist : d <= dist)) {
            int p = pos + d;
            if (p < 0 || p >= text.length) break;
            if (text[p] == ch) {
                return true;
            }
            d += dist > 0 ? 1 : -1;
        }
        return false;
    }
}

