/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.text;

import java.awt.Color;
import java.util.Collections;
import java.util.HashSet;
import org.basex.gui.GUIConstants;
import org.basex.gui.text.Syntax;
import org.basex.gui.text.TextIterator;

final class SyntaxJSON
extends Syntax {
    private static final HashSet<String> KEYWORDS = new HashSet();
    private boolean quoted;
    private boolean back;

    static {
        Collections.addAll(KEYWORDS, "false", "true", "null");
    }

    SyntaxJSON() {
    }

    @Override
    public void init(Color color) {
        super.init(color);
        this.quoted = false;
        this.back = false;
    }

    @Override
    public Color getColor(TextIterator iter) {
        boolean quote;
        int ch = iter.curr();
        boolean bl = quote = !this.back && ch == 34;
        if (this.quoted) {
            this.back = !this.back && ch == 92;
        } else {
            if ("-+0123456789".indexOf(ch) != -1) {
                return GUIConstants.DIGIT;
            }
            if ("{}[]:,".indexOf(ch) != -1) {
                return GUIConstants.COMMENT;
            }
            if (KEYWORDS.contains(iter.currString())) {
                return GUIConstants.KEYWORD;
            }
        }
        if (quote) {
            this.quoted ^= true;
        }
        return quote || this.quoted ? GUIConstants.VALUE : GUIConstants.RED;
    }
}

