/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.layout;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import org.basex.gui.GUIConstants;
import org.basex.gui.layout.BaseXLayout;
import org.basex.gui.layout.BaseXPanel;
import org.basex.util.Performance;

public final class BaseXScrollBar
extends BaseXPanel {
    private static final int MAXSTEP = 15;
    private static final int[] STEPS;
    private static final int MINSIZE = 20;
    private final BaseXPanel comp;
    private int step = STEPS.length / 2;
    private boolean animated;
    private int ww;
    private int hh;
    private int barPos;
    private int barSize;
    private int dragPos;
    private boolean button;
    private boolean down;
    private boolean sliding;
    private boolean moving;
    private int pos;
    private int height;
    private boolean up;
    private int barOffset;

    static {
        int[] nArray = new int[22];
        nArray[0] = -15;
        nArray[1] = -14;
        nArray[2] = -11;
        nArray[3] = -8;
        nArray[4] = -6;
        nArray[5] = -4;
        nArray[6] = -3;
        nArray[7] = -2;
        nArray[8] = -1;
        nArray[9] = -1;
        nArray[12] = 1;
        nArray[13] = 1;
        nArray[14] = 2;
        nArray[15] = 3;
        nArray[16] = 4;
        nArray[17] = 6;
        nArray[18] = 8;
        nArray[19] = 11;
        nArray[20] = 14;
        nArray[21] = 15;
        STEPS = nArray;
    }

    public BaseXScrollBar(BaseXPanel comp) {
        super(comp.gui);
        this.comp = comp;
        this.addMouseListener(this);
        this.addKeyListener(this);
        this.addMouseMotionListener(this);
        this.setOpaque(false);
        this.refreshLayout();
    }

    public void refreshLayout() {
        this.ww = 10 + GUIConstants.fontSize / 2;
        this.setPreferredSize(new Dimension(this.ww, this.getPreferredSize().height));
    }

    public void pos(int p) {
        int pp = Math.max(0, Math.min(this.height - this.getHeight(), p));
        if (this.pos == pp) {
            return;
        }
        this.pos = pp;
        this.repaint();
    }

    public int pos() {
        return this.pos;
    }

    public void height(int h) {
        if (this.height != h) {
            this.height = h;
            this.repaint();
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        this.hh = this.getHeight();
        super.paintComponent(g);
        if (this.hh >= this.height) {
            return;
        }
        int barH = this.hh - (this.ww << 1) + 4;
        double factor = (double)(barH - this.barOffset) / (double)this.height;
        int size = (int)((double)this.hh * factor);
        this.barOffset = Math.max(0, 20 - size);
        this.barSize = Math.min(size += this.barOffset, barH - 1);
        this.barPos = (int)Math.max(0.0, Math.min((double)this.pos * factor, (double)(barH - this.barSize)));
        g.setColor(GUIConstants.PANEL);
        g.fillRect(0, 0, this.ww, this.hh);
        int bh = this.ww - 2 + this.barPos;
        BaseXLayout.drawCell(g, 0, this.ww, bh, bh + this.barSize, false);
        int d = 2;
        g.setColor(GUIConstants.dgray);
        g.drawLine(5, bh += this.barSize / 2, this.ww - 6, bh);
        g.drawLine(5, bh - 2, this.ww - 6, bh - 2);
        g.drawLine(5, bh + 2, this.ww - 6, bh + 2);
        BaseXLayout.antiAlias(g);
        int[][] nArrayArray = new int[2][];
        int[] nArray = new int[3];
        nArray[1] = 6;
        nArray[2] = 3;
        nArrayArray[0] = nArray;
        int[] nArray2 = new int[3];
        nArray2[0] = 6;
        nArray2[1] = 6;
        nArrayArray[1] = nArray2;
        this.drawButton(g, nArrayArray, 0, this.button && this.up);
        int[][] nArrayArray2 = new int[2][];
        int[] nArray3 = new int[3];
        nArray3[1] = 6;
        nArray3[2] = 3;
        nArrayArray2[0] = nArray3;
        int[] nArray4 = new int[3];
        nArray4[2] = 6;
        nArrayArray2[1] = nArray4;
        this.drawButton(g, nArrayArray2, this.hh - this.ww, this.button && this.down);
        g.setColor(GUIConstants.gray);
        g.drawLine(0, 0, 0, this.hh);
        g.drawLine(this.ww - 1, 0, this.ww - 1, this.hh);
    }

    private void drawButton(Graphics g, int[][] pol, int y, boolean focus) {
        BaseXLayout.drawCell(g, 0, this.ww, y, y + this.ww, focus);
        int pl = pol[0].length;
        int i = 0;
        while (i < pl) {
            int[] nArray = pol[0];
            int n = i;
            nArray[n] = nArray[n] + (this.ww / 2 - 3);
            int[] nArray2 = pol[1];
            int n2 = i++;
            nArray2[n2] = nArray2[n2] + (y + this.ww / 2 - 3);
        }
        g.setColor(focus ? GUIConstants.TEXT : GUIConstants.dgray);
        g.fillPolygon(pol[0], pol[1], 3);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        int y = e.getY();
        this.sliding = y > this.ww + this.barPos && y < this.ww + this.barPos + this.barSize;
        this.moving = !this.sliding;
        this.up = y < this.ww + this.barPos;
        this.down = y > this.ww + this.barPos + this.barSize;
        boolean bl = this.button = y < this.ww || y > this.hh - this.ww;
        if (this.sliding) {
            this.dragPos = this.barPos - y;
        }
        if (this.sliding || this.animated) {
            return;
        }
        new Thread(() -> {
            this.animated = this.moving;
            while (this.animated) {
                this.step = this.moving ? Math.max(0, Math.min(STEPS.length - 1, this.step + (this.down ? 1 : -1))) : (this.step += this.step < STEPS.length / 2 ? 1 : -1);
                int offset = STEPS[this.step];
                if (!this.button) {
                    offset = offset * this.hh / 15 / 4;
                }
                this.pos = Math.max(0, Math.min(this.height - this.hh, this.pos + offset));
                this.comp.repaint();
                Performance.sleep(25L);
                boolean bl = this.animated = this.step != STEPS.length / 2;
                if (y <= this.ww + this.barPos || y >= this.ww + this.barPos + this.barSize) continue;
                this.dragPos = this.barPos - y;
                this.animated = false;
                this.sliding = true;
                this.step = STEPS.length / 2;
            }
        }).start();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.up = false;
        this.down = false;
        this.moving = false;
        this.sliding = false;
        this.comp.repaint();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (!this.sliding) {
            return;
        }
        this.pos = (int)((long)(e.getY() + this.dragPos) * (long)this.height / (long)(this.hh - (this.ww << 1)));
        this.pos = Math.max(0, Math.min(this.height - this.hh, this.pos));
        this.comp.repaint();
    }
}

