/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.layout;

import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.basex.gui.GUI;
import org.basex.gui.GUICommand;
import org.basex.gui.GUIPopupCmd;
import org.basex.gui.layout.BaseXKeys;
import org.basex.gui.layout.BaseXLayout;
import org.basex.gui.layout.BaseXPanel;

public final class BaseXPopup
extends JPopupMenu {
    private final GUI gui;
    private final GUICommand[] commands;

    public BaseXPopup(BaseXPanel comp, GUICommand ... commands) {
        this((JComponent)comp, comp.gui, commands);
    }

    public BaseXPopup(JComponent comp, final GUI gui, GUICommand ... commands) {
        this.gui = gui;
        this.commands = commands;
        comp.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (!gui.updating && e.isPopupTrigger()) {
                    BaseXPopup.this.show(e.getComponent(), e.getX() - 10, e.getY() - 15);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.mousePressed(e);
            }
        });
        comp.addKeyListener(e -> {
            if (!gUI.updating && BaseXKeys.CONTEXT.is(e)) {
                this.show(e.getComponent(), 10, 10);
            } else {
                GUICommand[] gUICommandArray2 = commands;
                int n = commands.length;
                int n2 = 0;
                while (n2 < n) {
                    GUICommand cmd = gUICommandArray2[n2];
                    if (cmd instanceof GUIPopupCmd) {
                        BaseXKeys[] baseXKeysArray = ((GUIPopupCmd)cmd).shortcuts();
                        int n3 = baseXKeysArray.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            BaseXKeys sc = baseXKeysArray[n4];
                            if (sc.is(e)) {
                                cmd.execute(gui);
                                e.consume();
                                return;
                            }
                            ++n4;
                        }
                    }
                    ++n2;
                }
            }
        });
        StringBuilder mnemCache = new StringBuilder();
        GUICommand[] gUICommandArray = commands;
        int n = commands.length;
        int n2 = 0;
        while (n2 < n) {
            GUICommand cmd = gUICommandArray[n2];
            if (cmd == null) {
                this.addSeparator();
            } else {
                String desc = cmd.label();
                JMenuItem jmi = this.add(cmd.toggle() ? new JCheckBoxMenuItem(desc) : new JMenuItem(desc));
                jmi.addActionListener(e -> {
                    if (!gUI.updating) {
                        cmd.execute(gui);
                    }
                });
                BaseXLayout.setMnemonic(jmi, mnemCache);
                jmi.setAccelerator(BaseXLayout.keyStroke(cmd));
            }
            ++n2;
        }
    }

    @Override
    public void show(Component comp, int x, int y) {
        int cl = this.commands.length;
        int c = 0;
        while (c < cl) {
            if (this.commands[c] != null) {
                AbstractButton button = (AbstractButton)this.getComponent(c);
                button.setEnabled(this.commands[c].enabled(this.gui));
                button.setSelected(this.commands[c].selected(this.gui));
            }
            ++c;
        }
        super.show(comp, x, y);
    }
}

