/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.layout;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.KeyListener;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import org.basex.gui.GUI;
import org.basex.gui.GUICommand;
import org.basex.gui.GUIConstants;
import org.basex.gui.GUIMenuCmd;
import org.basex.gui.GUIOptions;
import org.basex.gui.layout.BaseXButton;
import org.basex.gui.layout.BaseXCombo;
import org.basex.gui.layout.BaseXDialog;
import org.basex.gui.layout.BaseXKeys;
import org.basex.gui.layout.BaseXWindow;
import org.basex.gui.text.SearchBar;
import org.basex.gui.text.TextPanel;
import org.basex.util.Prop;
import org.basex.util.Token;
import org.basex.util.Util;

public final class BaseXLayout {
    private static final Map<?, ?> HINTS = (Map)Toolkit.getDefaultToolkit().getDesktopProperty("awt.font.desktophints");
    private static boolean hints = true;
    private static final String META = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() == 4 ? "meta" : "ctrl";
    private static KeyListener keys;

    private BaseXLayout() {
    }

    static void focus(Component comp) {
        GUI gui = BaseXLayout.gui(comp);
        if (gui == null) {
            return;
        }
        if (gui.gopts.get(GUIOptions.MOUSEFOCUS).booleanValue() && comp.isEnabled()) {
            comp.requestFocusInWindow();
        }
    }

    public static void hints(Graphics g) {
        if (HINTS != null && hints) {
            try {
                ((Graphics2D)g).addRenderingHints(HINTS);
            }
            catch (Exception ex) {
                Util.stack(ex);
                hints = false;
            }
        }
    }

    public static Graphics2D antiAlias(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        return g2;
    }

    private static GUI gui(Component comp) {
        Component c = comp;
        do {
            if (!(c instanceof GUI)) continue;
            return (GUI)c;
        } while ((c = c.getParent()) != null);
        return null;
    }

    public static void setWidth(Component comp, int w) {
        comp.setPreferredSize(new Dimension(w, comp.getPreferredSize().height));
    }

    public static void setHeight(Component comp, int h) {
        comp.setPreferredSize(new Dimension(comp.getPreferredSize().width, h));
    }

    public static EmptyBorder border(int t, int l, int b, int r) {
        return new EmptyBorder(t, l, b, r);
    }

    public static void addDrop(final JComponent comp, final DropHandler dnd) {
        comp.setDropTarget(new DropTarget(comp, 3, null, true, null){

            @Override
            public synchronized void drop(DropTargetDropEvent dtde) {
                dtde.acceptDrop(3);
                Transferable tr = dtde.getTransferable();
                for (Object o : BaseXLayout.contents(tr)) {
                    dnd.drop(o);
                }
                comp.requestFocusInWindow();
            }
        });
    }

    public static KeyStroke keyStroke(GUICommand cmd) {
        String scut;
        Object sc = cmd.shortcuts();
        if (sc == null) {
            return null;
        }
        if (sc instanceof BaseXKeys[]) {
            BaseXKeys[] scs = (BaseXKeys[])sc;
            if (scs.length == 0) {
                return null;
            }
            scut = scs[0].shortCut();
        } else {
            scut = Util.info(sc, META);
        }
        KeyStroke ks = KeyStroke.getKeyStroke(scut);
        if (ks == null) {
            Util.errln("Could not assign shortcut: " + sc + " / " + scut, new Object[0]);
        }
        return ks;
    }

    public static void setMnemonic(AbstractButton b, StringBuilder mnem) {
        if (Prop.MAC) {
            return;
        }
        String label = b.getText();
        int ll = label.length();
        int l = 0;
        while (l < ll) {
            char ch = Character.toLowerCase(label.charAt(l));
            if (Token.letter(ch) && mnem.indexOf(Character.toString(ch)) == -1) {
                b.setMnemonic(ch);
                mnem.append(ch);
                break;
            }
            ++l;
        }
    }

    public static ArrayList<Object> contents(Transferable tr) {
        ArrayList<Object> list = new ArrayList<Object>();
        try {
            if (tr.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                list.addAll((List)tr.getTransferData(DataFlavor.javaFileListFlavor));
            } else if (tr.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                list.add(tr.getTransferData(DataFlavor.stringFlavor));
            } else {
                StringBuilder sb = new StringBuilder("Data flavors not supported:\n");
                DataFlavor[] dataFlavorArray = tr.getTransferDataFlavors();
                int n = dataFlavorArray.length;
                int n2 = 0;
                while (n2 < n) {
                    DataFlavor df = dataFlavorArray[n2];
                    sb.append("- ").append(df).append('\n');
                    ++n2;
                }
                Util.debug(sb, new Object[0]);
            }
        }
        catch (Exception ex) {
            Util.stack(ex);
        }
        return list;
    }

    public static void copy(String text) {
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(text), null);
    }

    public static void copyPath(String path) {
        try {
            BaseXLayout.copy(Paths.get(path, new String[0]).toRealPath(new LinkOption[0]).toString());
        }
        catch (Exception ex) {
            Util.stack(ex);
        }
    }

    public static void addInteraction(Component comp, BaseXWindow win) {
        comp.addMouseListener(e -> BaseXLayout.focus(comp));
        BaseXDialog dialog = win.dialog();
        if (dialog == null) {
            comp.addKeyListener(BaseXLayout.globalShortcuts(win.gui()));
        } else {
            comp.addKeyListener(e -> {
                BaseXCombo combo;
                BaseXCombo baseXCombo = combo = comp instanceof BaseXCombo ? (BaseXCombo)comp : null;
                if (combo != null && combo.isPopupVisible()) {
                    return;
                }
                if (BaseXKeys.ENTER.is(e) && !(comp instanceof BaseXButton) && !(comp instanceof TextPanel)) {
                    dialog.close();
                } else if (BaseXKeys.ESCAPE.is(e)) {
                    boolean close = true;
                    if (comp instanceof TextPanel) {
                        SearchBar bar = ((TextPanel)comp).getSearch();
                        boolean bl = close = bar == null || !bar.deactivate(true);
                    }
                    if (close) {
                        dialog.cancel();
                    }
                }
            });
        }
    }

    private static KeyListener globalShortcuts(GUI gui) {
        if (keys == null) {
            keys = e -> {
                int fs;
                if (gUI.context.data() != null) {
                    if (BaseXKeys.GOBACK.is(e)) {
                        GUIMenuCmd.C_GOBACK.execute(gui);
                    } else if (BaseXKeys.GOFORWARD.is(e)) {
                        GUIMenuCmd.C_GOFORWARD.execute(gui);
                    } else if (BaseXKeys.GOUP.is(e)) {
                        GUIMenuCmd.C_GOUP.execute(gui);
                    } else if (BaseXKeys.GOHOME.is(e)) {
                        GUIMenuCmd.C_GOHOME.execute(gui);
                    }
                }
                if (BaseXKeys.FOCUSINPUT.is(e)) {
                    gUI.input.requestFocusInWindow();
                }
                if (BaseXKeys.FOCUSEDITOR.is(e)) {
                    gUI.editor.focusEditor();
                }
                int nfs = fs = gUI.gopts.get(GUIOptions.FONTSIZE).intValue();
                if (BaseXKeys.INCFONT1.is(e) || BaseXKeys.INCFONT2.is(e)) {
                    nfs = fs + 1;
                } else if (BaseXKeys.DECFONT.is(e)) {
                    nfs = Math.max(1, fs - 1);
                } else if (BaseXKeys.NORMFONT.is(e)) {
                    nfs = (int)((double)GUIConstants.LABEL.getFont().getSize() * 1.5);
                }
                if (fs != nfs) {
                    gUI.gopts.set(GUIOptions.FONTSIZE, nfs);
                    gui.updateLayout();
                }
            };
        }
        return keys;
    }

    public static String addShortcut(String str, String sc) {
        if (sc == null || str == null) {
            return str;
        }
        StringBuilder sb = new StringBuilder();
        String[] stringArray = sc.split(" ");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String t;
            String s = stringArray[n2];
            String string = "%".equals(s) ? (Prop.MAC ? "meta" : "control") : (t = s);
            if (t.length() != 1) {
                t = Toolkit.getProperty("AWT." + t.toLowerCase(Locale.ENGLISH), t);
            }
            sb.append('+').append(t);
            ++n2;
        }
        return String.valueOf(str) + " (" + sb.substring(1) + ')';
    }

    public static String value(double val) {
        return Token.string(Token.chopNumber(Token.token(val)));
    }

    public static void drawCell(Graphics g, int xs, int xe, int ys, int ye, boolean focus) {
        g.setColor(GUIConstants.gray);
        g.drawRect(xs, ys, xe - xs - 1, ye - ys - 1);
        g.setColor(GUIConstants.BACK);
        g.drawRect(xs + 1, ys + 1, xe - xs - 3, ye - ys - 3);
        g.setColor(focus ? GUIConstants.lgray : GUIConstants.BACK);
        g.fillRect(xs + 1, ys + 1, xe - xs - 2, ye - ys - 2);
    }

    public static void drawCenter(Graphics g, String text, int w, int y) {
        g.drawString(text, (w - BaseXLayout.width(g, text)) / 2, y);
    }

    public static void drawTooltip(Graphics g, String tt, int x, int y, int w, int c) {
        int tw = BaseXLayout.width(g, tt);
        int th = g.getFontMetrics().getHeight();
        int xx = Math.min(w - tw - 8, x);
        g.setColor(GUIConstants.color(c));
        g.fillRect(xx - 1, y - th, tw + 4, th);
        g.setColor(GUIConstants.BACK);
        g.drawString(tt, xx, y - 4);
    }

    public static int width(Graphics g, String s) {
        return g.getFontMetrics().stringWidth(s);
    }

    public static void chopString(Graphics g, byte[] s, int x, int y, int w, int fs) {
        if (w < 12) {
            return;
        }
        int[] cw = GUIConstants.fontWidths(g.getFont());
        int j = s.length;
        try {
            int l = 0;
            int fw = 0;
            int k = 0;
            while (k < j) {
                int ww = BaseXLayout.width(g, cw, Token.cp(s, k));
                if (fw + ww >= w - 4) {
                    j = Math.max(1, k - l);
                    if (k > 1) {
                        fw -= BaseXLayout.width(g, cw, Token.cp(s, k - 1));
                    }
                    g.drawString("..", x + fw, y + fs);
                    break;
                }
                fw += ww;
                l = Token.cl(s, k);
                k += l;
            }
        }
        catch (Exception ex) {
            Util.debug(ex);
        }
        g.drawString(Token.string(s, 0, j), x, y + fs);
    }

    public static int width(Graphics g, byte[] s) {
        int[] cw = GUIConstants.fontWidths(g.getFont());
        int l = s.length;
        int fw = 0;
        try {
            int k = 0;
            while (k < l) {
                fw += BaseXLayout.width(g, cw, Token.cp(s, k));
                k += Token.cl(s, k);
            }
        }
        catch (Exception ex) {
            Util.debug(ex);
        }
        return fw;
    }

    public static int width(Graphics g, int[] cw, int c) {
        return c >= cw.length ? g.getFontMetrics().charWidth(c) : cw[c];
    }

    public static interface DropHandler {
        public void drop(Object var1);
    }
}

