/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.dialog;

import org.basex.core.Databases;
import org.basex.core.MainOptions;
import org.basex.core.Text;
import org.basex.gui.GUI;
import org.basex.gui.GUIConstants;
import org.basex.gui.GUIOptions;
import org.basex.gui.dialog.DialogFT;
import org.basex.gui.dialog.DialogImport;
import org.basex.gui.dialog.DialogIndex;
import org.basex.gui.dialog.DialogOptions;
import org.basex.gui.dialog.DialogParsing;
import org.basex.gui.dialog.DialogValues;
import org.basex.gui.layout.BaseXBack;
import org.basex.gui.layout.BaseXCheckBox;
import org.basex.gui.layout.BaseXDialog;
import org.basex.gui.layout.BaseXLabel;
import org.basex.gui.layout.BaseXTabs;
import org.basex.gui.layout.BaseXTextField;
import org.basex.gui.layout.TableLayout;
import org.basex.index.IndexType;
import org.basex.util.Util;

public final class DialogNew
extends BaseXDialog {
    private final DialogImport general;
    private final DialogOptions options;
    private final BaseXTextField dbName;
    private final BaseXBack buttons = this.okCancel();
    private final BaseXCheckBox textindex;
    private final BaseXCheckBox attrindex;
    private final BaseXCheckBox ftindex;
    private final BaseXCheckBox tokenindex;
    private final DialogIndex[] index;

    public DialogNew(GUI gui) {
        super(gui, Text.CREATE_DATABASE);
        MainOptions opts = gui.context.options;
        GUIOptions gopts = gui.gopts;
        this.dbName = new BaseXTextField(this, gopts.get(GUIOptions.DBNAME));
        BaseXBack pnl = new BaseXBack(new TableLayout(2, 1));
        pnl.add(new BaseXLabel(String.valueOf(Text.NAME_OF_DB) + ": ", false, true).border(8, 0, 6, 0));
        pnl.add(this.dbName);
        BaseXTabs tabs = new BaseXTabs(this);
        DialogParsing parsePanel = new DialogParsing(this, tabs);
        this.general = new DialogImport(this, pnl, parsePanel);
        this.index = new DialogIndex[]{new DialogValues(this, IndexType.TEXT), new DialogValues(this, IndexType.ATTRIBUTE), new DialogValues(this, IndexType.TOKEN), new DialogFT(this, true)};
        this.textindex = new BaseXCheckBox(this, Text.TEXT_INDEX, MainOptions.TEXTINDEX, opts).bold().large();
        this.attrindex = new BaseXCheckBox(this, Text.ATTRIBUTE_INDEX, MainOptions.ATTRINDEX, opts).bold().large();
        this.tokenindex = new BaseXCheckBox(this, Text.TOKEN_INDEX, MainOptions.TOKENINDEX, opts).bold().large();
        this.ftindex = new BaseXCheckBox(this, Text.FULLTEXT_INDEX, MainOptions.FTINDEX, opts).bold().large();
        BaseXBack indexPanel = new BaseXBack(new TableLayout(8, 1)).border(8);
        indexPanel.add(this.textindex);
        indexPanel.add(this.index[0]);
        indexPanel.add(new BaseXBack());
        indexPanel.add(this.attrindex);
        indexPanel.add(this.index[1]);
        indexPanel.add(new BaseXBack());
        indexPanel.add(this.tokenindex);
        indexPanel.add(this.index[2]);
        BaseXBack ftPanel = new BaseXBack(new TableLayout(2, 1)).border(8);
        ftPanel.add(this.ftindex);
        ftPanel.add(this.index[3]);
        this.options = new DialogOptions(this, null);
        tabs.addTab(Text.GENERAL, this.general);
        tabs.addTab(Text.PARSING, parsePanel);
        tabs.addTab(Text.INDEXES, indexPanel);
        tabs.addTab(Text.FULLTEXT, ftPanel);
        tabs.addTab(Text.OPTIONS, this.options);
        this.set(tabs, "Center");
        this.set(this.buttons, "South");
        this.general.setType(this.general.input());
        this.action(this.general.parsers);
        this.setResizable(true);
        this.finish();
    }

    @Override
    public void action(Object comp) {
        boolean valid = this.general.action(comp, true) && this.options.action();
        this.index[0].action(this.textindex.isSelected());
        this.index[1].action(this.attrindex.isSelected());
        this.index[2].action(this.tokenindex.isSelected());
        this.index[3].action(this.ftindex.isSelected());
        if (comp == this.general.browse || comp == this.general.input) {
            this.dbName.setText(this.general.dbName);
        }
        String nm = this.dbName.getText().trim();
        boolean bl = this.ok = valid && !nm.isEmpty();
        String inf = valid ? (this.ok ? null : Text.ENTER_DB_NAME) : Text.RES_NOT_FOUND;
        GUIConstants.Msg icon = GUIConstants.Msg.ERROR;
        if (this.ok) {
            this.ok = Databases.validName(nm);
            if (this.ok) {
                this.gui.gopts.set(GUIOptions.DBNAME, nm);
            }
            if (!this.ok) {
                inf = Util.info(Text.INVALID_X, Text.NAME);
            } else if (this.general.input.getText().trim().isEmpty()) {
                inf = Text.EMPTY_DB;
                icon = GUIConstants.Msg.WARN;
            } else if (this.gui.context.listDBs().contains(nm)) {
                inf = Text.OVERWRITE_DB;
                icon = GUIConstants.Msg.WARN;
            }
        }
        this.general.info.setText(inf, icon);
        DialogNew.enableOK(this.buttons, Text.B_OK, this.ok);
    }

    @Override
    public void close() {
        if (!this.ok) {
            return;
        }
        super.close();
        this.gui.set(MainOptions.TEXTINDEX, this.textindex.isSelected());
        this.gui.set(MainOptions.ATTRINDEX, this.attrindex.isSelected());
        this.gui.set(MainOptions.TOKENINDEX, this.tokenindex.isSelected());
        this.gui.set(MainOptions.FTINDEX, this.ftindex.isSelected());
        this.general.setOptions();
        this.options.setOptions(null);
        DialogIndex[] dialogIndexArray = this.index;
        int n = this.index.length;
        int n2 = 0;
        while (n2 < n) {
            DialogIndex di = dialogIndexArray[n2];
            di.setOptions();
            ++n2;
        }
    }
}

