/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.dialog;

import java.awt.BorderLayout;
import java.awt.Component;
import org.basex.core.Context;
import org.basex.core.Text;
import org.basex.data.Data;
import org.basex.gui.GUI;
import org.basex.gui.GUIConstants;
import org.basex.gui.layout.BaseXBack;
import org.basex.gui.layout.BaseXDialog;
import org.basex.gui.layout.BaseXLabel;
import org.basex.gui.layout.BaseXLayout;
import org.basex.gui.layout.BaseXTextField;
import org.basex.gui.text.SearchEditor;
import org.basex.gui.text.TextPanel;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.XMLToken;
import org.basex.util.list.StringList;

public final class DialogEdit
extends BaseXDialog {
    public final StringList result = new StringList();
    public final int kind;
    private final BaseXBack buttons;
    private final BaseXLabel info;
    private BaseXTextField input1;
    private BaseXTextField input2;
    private TextPanel input3;
    private String old1;
    private String old2;
    private String old3;

    public DialogEdit(GUI gui, int pre) {
        super(gui, Text.EDIT_DATA);
        BaseXBack pp = new BaseXBack(new BorderLayout());
        Context context = gui.context;
        Data data = context.data();
        this.kind = data.kind(pre);
        String title = Util.info(Text.EDIT_X, Text.NODE_KINDS[this.kind]);
        BaseXLabel label = new BaseXLabel(title, true, true);
        pp.add((Component)label, "North");
        if (this.kind == 1) {
            this.old1 = Token.string(data.name(pre, this.kind));
        } else if (this.kind == 0) {
            this.old1 = Token.string(data.text(pre, true));
        } else if (this.kind == 2 || this.kind == 4) {
            this.old3 = Token.string(data.atom(pre));
        } else if (this.kind == 3) {
            this.old1 = Token.string(data.name(pre, this.kind));
            this.old2 = Token.string(data.atom(pre));
        } else {
            this.old1 = Token.string(data.name(pre, this.kind));
            this.old3 = Token.string(data.atom(pre));
        }
        BaseXBack b = new BaseXBack(new BorderLayout(0, 4));
        if (this.old1 != null) {
            this.input1 = new BaseXTextField(this, this.old1);
            BaseXLayout.setWidth(this.input1, 500);
            b.add((Component)this.input1, "North");
        }
        if (this.old2 != null) {
            this.input2 = new BaseXTextField(this, this.old2);
            b.add((Component)this.input2, "Center");
        }
        if (this.old3 != null) {
            this.input3 = new TextPanel(this, this.old3, true);
            this.input3.addKeyListener(this.keys);
            BaseXLayout.setWidth(this.input3, 350);
            BaseXLayout.setHeight(this.input3, 350);
            b.add((Component)new SearchEditor(gui, this.input3), "Center");
            this.setResizable(true);
        }
        pp.add((Component)b, "Center");
        this.set(pp, "Center");
        pp = new BaseXBack(new BorderLayout());
        this.info = new BaseXLabel(" ").border(12, 0, 6, 0);
        pp.add((Component)this.info, "West");
        this.buttons = this.okCancel();
        pp.add((Component)this.buttons, "East");
        this.set(pp, "South");
        this.finish();
    }

    @Override
    public void action(Object cmp) {
        this.ok = this.kind != 2 || this.input3.getText().length != 0;
        String msg = null;
        if (this.kind != 2 && this.kind != 4) {
            this.ok = XMLToken.isQName(Token.token(this.input1.getText()));
            if (!this.ok && !this.input1.getText().isEmpty()) {
                msg = Util.info(Text.INVALID_X, Text.NAME);
            }
        }
        this.info.setText(msg, GUIConstants.Msg.ERROR);
        DialogEdit.enableOK(this.buttons, Text.B_OK, this.ok);
    }

    @Override
    public void close() {
        super.close();
        this.ok = false;
        if (this.old1 != null) {
            this.result.add(this.input1.getText());
            this.ok |= !this.input1.getText().equals(this.old1);
        }
        if (this.old2 != null) {
            this.result.add(this.input2.getText());
            this.ok |= !this.input2.getText().equals(this.old2);
        }
        if (this.old3 != null) {
            String text = Token.string(this.input3.getText());
            this.result.add(text);
            this.ok |= !text.equals(this.old3);
        }
    }
}

