/*
 * Decompiled with CFR 0.152.
 */
package org.basex.data;

import org.basex.core.Text;
import org.basex.data.Data;
import org.basex.data.DataText;
import org.basex.util.Table;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.list.TokenList;

public final class DataPrinter {
    private final Data data;
    private final Table table;
    private final TokenBuilder nsp = new TokenBuilder();

    public DataPrinter(Data data) {
        this.data = data;
        this.table = new Table();
        this.table.header.add(DataText.TABLEPRE);
        this.table.header.add(DataText.TABLEDIST);
        this.table.header.add(DataText.TABLESIZE);
        this.table.header.add(DataText.TABLEATS);
        this.table.header.add(DataText.TABLEID);
        this.table.header.add(DataText.TABLENS);
        this.table.header.add(DataText.TABLEKND);
        this.table.header.add(DataText.TABLECON);
        int i = 0;
        while (i < 6) {
            this.table.align.add(true);
            ++i;
        }
    }

    public void add(int start, int end) {
        int ps = Math.max(0, start);
        int pe = Math.min(this.data.meta.size, end);
        int p = ps;
        while (p < pe) {
            this.add(p);
            ++p;
        }
        byte[] ns = this.data.nspaces.table(ps, pe);
        if (ns.length != 0) {
            this.nsp.add(Text.NL).add(ns).add(this.data.nspaces.toString(ps, pe)).add(Text.NL);
        }
    }

    private void add(int pre) {
        int k = this.data.kind(pre);
        TokenList tl = new TokenList();
        tl.add(pre);
        tl.add(pre - this.data.parent(pre, k));
        tl.add(this.data.size(pre, k));
        tl.add(this.data.attSize(pre, k));
        tl.add(this.data.id(pre));
        int uriId = this.data.uriId(pre, k);
        if (this.data.nsFlag(pre)) {
            tl.add("+" + uriId);
        } else {
            tl.add(uriId);
        }
        tl.add(DataText.TABLEKINDS[k]);
        byte[] cont = k == 1 ? this.data.name(pre, 1) : (k == 3 ? new TokenBuilder(this.data.name(pre, 3)).add(DataText.ATT1).add(this.data.text(pre, false)).add(DataText.ATT2).finish() : this.data.text(pre, true));
        tl.add(Token.replace(Token.chop(cont, 64), 10, 32));
        this.table.contents.add(tl);
    }

    public byte[] finish() {
        return Token.concat(this.table.finish(), this.nsp.finish());
    }

    public String toString() {
        return Token.string(this.finish());
    }
}

