/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core.jobs;

import java.math.BigDecimal;
import java.util.Map;
import java.util.TimerTask;
import org.basex.core.Context;
import org.basex.core.jobs.Job;
import org.basex.core.jobs.JobContext;
import org.basex.core.jobs.JobException;
import org.basex.core.jobs.JobState;
import org.basex.core.jobs.JobsOptions;
import org.basex.core.jobs.QueryJobResult;
import org.basex.core.jobs.QueryJobSpec;
import org.basex.core.jobs.QueryJobTask;
import org.basex.data.Data;
import org.basex.query.QueryContext;
import org.basex.query.QueryDateTime;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryProcessor;
import org.basex.query.iter.Iter;
import org.basex.query.value.Value;
import org.basex.query.value.ValueBuilder;
import org.basex.query.value.item.ADate;
import org.basex.query.value.item.ADateDur;
import org.basex.query.value.item.DTDur;
import org.basex.query.value.item.Dtm;
import org.basex.query.value.item.Dur;
import org.basex.query.value.item.FItem;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.Tim;
import org.basex.query.value.node.DBNode;
import org.basex.util.InputInfo;
import org.basex.util.Performance;
import org.basex.util.Token;

public final class QueryJob
extends Job
implements Runnable {
    private final QueryJobResult result;
    private final QueryJobSpec job;
    private QueryProcessor qp;
    private boolean remove;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public QueryJob(QueryJobSpec job, InputInfo info, Context ctx) throws QueryException {
        block14: {
            super();
            this.result = new QueryJobResult(this);
            this.job = job;
            this.jc().context = ctx;
            opts = job.options;
            start = opts.get(JobsOptions.START);
            delay = start == null || start.isEmpty() != false ? 0L : this.delay(start, 0L, info);
            interval = 0L;
            inter = opts.get(JobsOptions.INTERVAL);
            if (inter == null || inter.isEmpty()) break block14;
            interval = QueryJob.ms(new DTDur(Token.token(inter), info));
            if (interval >= 1000L) ** GOTO lbl15
            throw QueryError.JOBS_RANGE_X.get(info, new Object[]{inter});
lbl-1000:
            // 1 sources

            {
                delay += interval;
lbl15:
                // 2 sources

                ** while (delay < 0L)
            }
        }
        if (delay < 0L) {
            throw QueryError.JOBS_RANGE_X.get(info, new Object[]{start});
        }
        end = opts.get(JobsOptions.END);
        v0 = duration = end == null || end.isEmpty() != false ? 0x7FFFFFFFFFFFFFFFL : this.delay(end, delay, info);
        if (duration <= delay) {
            throw QueryError.JOBS_RANGE_X.get(info, new Object[]{end});
        }
        v1 = cache = opts.contains(JobsOptions.CACHE) != false && opts.get(JobsOptions.CACHE) != false;
        if (cache && interval > 0L) {
            throw QueryError.JOBS_OPTIONS.get(info, new Object[0]);
        }
        jobs = ctx.jobs;
        var16_13 = jobs.tasks;
        synchronized (var16_13) {
            id = opts.get(JobsOptions.ID);
            if (id != null) {
                if (id.startsWith("job")) {
                    throw QueryError.JOBS_ID_INVALID_X.get(info, new Object[]{id});
                }
                if (jobs.tasks.containsKey(id) || jobs.active.containsKey(id) || jobs.results.containsKey(id)) {
                    throw QueryError.JOBS_ID_EXISTS_X.get(info, new Object[]{id});
                }
                this.jc().id(id);
            } else {
                id = this.jc().id();
            }
            if (cache) {
                jobs.results.put(id, this.result);
            }
            task = new QueryJobTask(this, jobs, delay, interval, duration);
            jobs.tasks.put(id, task);
            if (interval > 0L) {
                jobs.timer.scheduleAtFixedRate((TimerTask)task, delay, interval);
            } else {
                jobs.timer.schedule((TimerTask)task, delay);
            }
        }
    }

    private long delay(String string, long min, InputInfo info) throws QueryException {
        long ms;
        QueryDateTime qdt = new QueryDateTime();
        if (Dur.DTD.matcher(string).matches()) {
            ms = QueryJob.ms(new DTDur(Token.token(string), info));
        } else if (ADate.TIME.matcher(string).matches()) {
            ms = QueryJob.ms(new DTDur(new Tim(Token.token(string), info), qdt.time, info));
            while (ms <= min) {
                ms += 86400000L;
            }
        } else {
            ms = QueryJob.ms(new DTDur(new Dtm(Token.token(string), info), qdt.datm, info));
        }
        return ms;
    }

    private static long ms(ADateDur date) {
        return date.sec.multiply(BigDecimal.valueOf(1000L)).longValue();
    }

    public void remove() {
        this.remove = true;
    }

    /*
     * Loose catch block
     */
    @Override
    public void run() {
        JobContext jc = this.jc();
        Context ctx = jc.context;
        JobsOptions opts = this.job.options;
        this.qp = new QueryProcessor(this.job.query, opts.get(JobsOptions.BASE_URI), ctx);
        try {
            try {
                Performance perf = new Performance();
                for (Map.Entry<String, Value> binding : this.job.bindings.entrySet()) {
                    String key = binding.getKey();
                    Value value = binding.getValue();
                    if (key.isEmpty()) {
                        this.qp.context(value);
                        continue;
                    }
                    this.qp.bind(key, value);
                }
                this.qp.parse();
                this.updating = this.qp.updating;
                this.result.time = perf.ns();
                this.pushJob(this.qp);
                this.register(ctx);
                if (this.remove) {
                    ctx.jobs.tasks.remove(jc.id());
                }
                this.result.value = QueryJob.copy(this.qp.iter(), ctx, this.qp.qc);
            }
            catch (JobException ex) {
                ctx.jobs.results.remove(jc.id());
                Boolean cache = opts.get(JobsOptions.CACHE);
                if (cache != null && cache.booleanValue()) {
                    ctx.jobs.scheduleResult(this);
                    this.state(JobState.CACHED);
                } else {
                    this.state(JobState.SCHEDULED);
                }
                if (ctx.jobs.active.containsKey(jc.id())) {
                    this.qp.close();
                    this.unregister(ctx);
                    this.popJob();
                    this.qp = null;
                    this.result.time += jc.performance.ns();
                    jc.performance = null;
                }
                if (this.remove) {
                    ctx.jobs.tasks.remove(jc.id());
                }
            }
            catch (QueryException ex) {
                this.result.exception = ex;
                Boolean cache = opts.get(JobsOptions.CACHE);
                if (cache != null && cache.booleanValue()) {
                    ctx.jobs.scheduleResult(this);
                    this.state(JobState.CACHED);
                } else {
                    this.state(JobState.SCHEDULED);
                }
                if (ctx.jobs.active.containsKey(jc.id())) {
                    this.qp.close();
                    this.unregister(ctx);
                    this.popJob();
                    this.qp = null;
                    this.result.time += jc.performance.ns();
                    jc.performance = null;
                }
                if (this.remove) {
                    ctx.jobs.tasks.remove(jc.id());
                }
            }
            catch (Throwable ex) {
                this.result.exception = QueryError.XQUERY_UNEXPECTED_X.get(null, ex);
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                Boolean cache = opts.get(JobsOptions.CACHE);
                if (cache != null && cache.booleanValue()) {
                    ctx.jobs.scheduleResult(this);
                    this.state(JobState.CACHED);
                } else {
                    this.state(JobState.SCHEDULED);
                }
                if (ctx.jobs.active.containsKey(jc.id())) {
                    this.qp.close();
                    this.unregister(ctx);
                    this.popJob();
                    this.qp = null;
                    this.result.time += jc.performance.ns();
                    jc.performance = null;
                }
                if (this.remove) {
                    ctx.jobs.tasks.remove(jc.id());
                }
            }
        }
        finally {
            Boolean cache = opts.get(JobsOptions.CACHE);
            if (cache != null && cache.booleanValue()) {
                ctx.jobs.scheduleResult(this);
                this.state(JobState.CACHED);
            } else {
                this.state(JobState.SCHEDULED);
            }
            if (ctx.jobs.active.containsKey(jc.id())) {
                this.qp.close();
                this.unregister(ctx);
                this.popJob();
                this.qp = null;
                this.result.time += jc.performance.ns();
                jc.performance = null;
            }
            if (this.remove) {
                ctx.jobs.tasks.remove(jc.id());
            }
        }
    }

    @Override
    public void addLocks() {
        this.qp.addLocks();
    }

    public static Value copy(Iter iter, Context ctx, QueryContext qc) throws QueryException {
        Item item;
        ValueBuilder vb = new ValueBuilder(qc);
        while ((item = qc.next(iter)) != null) {
            if (item instanceof FItem) {
                throw QueryError.BASEX_FUNCTION_X.get(null, item);
            }
            Data data = item.data();
            if (data != null && !data.inMemory()) {
                item = ((DBNode)item).dbNodeCopy(ctx.options, qc);
            }
            vb.add(item);
        }
        return vb.value();
    }

    public String toString() {
        String uri = this.job.options.get(JobsOptions.BASE_URI);
        return uri == null || uri.isEmpty() ? this.job.query : uri;
    }
}

