/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core.cmd;

import org.basex.core.Text;
import org.basex.core.cmd.ACreate;
import org.basex.core.users.Perm;
import org.basex.data.Data;
import org.basex.data.MetaData;
import org.basex.io.IOFile;
import org.basex.util.Prop;
import org.basex.util.Token;
import org.basex.util.list.IntList;

public final class Rename
extends ACreate {
    public Rename(String source, String target) {
        super(Perm.WRITE, true, source, target);
    }

    @Override
    protected boolean run() {
        final Data data = this.context.data();
        final String src = MetaData.normPath(this.args[0]);
        if (src == null) {
            return this.error(Text.NAME_INVALID_X, this.args[0]);
        }
        final String trg = MetaData.normPath(this.args[1]);
        if (trg == null) {
            return this.error(Text.NAME_INVALID_X, this.args[1]);
        }
        return this.update(data, new ACreate.Code(){

            @Override
            boolean run() {
                return Rename.this.rename(data, src, trg);
            }
        });
    }

    private boolean rename(Data data, String src, String trg) {
        IOFile file;
        boolean ok = true;
        int c = 0;
        IntList docs = data.resources.docs(src);
        int ds = docs.size();
        int i = 0;
        while (i < ds) {
            int pre = docs.get(i);
            String target = Rename.target(data, pre, src, trg);
            if (target.isEmpty()) {
                ok = !this.info(Text.NAME_INVALID_X, target);
            } else {
                data.update(pre, 0, Token.token(target));
                ++c;
            }
            ++i;
        }
        IOFile iOFile = file = data.inMemory() ? null : data.meta.binary(src);
        if (file != null && file.exists()) {
            IOFile target = data.meta.binary(trg);
            IOFile trgdir = target.parent();
            if (!trgdir.md() || !file.rename(target)) {
                ok = !this.info(Text.NAME_INVALID_X, trg);
            }
            ++c;
        }
        return this.info(Text.RES_RENAMED_X_X, c, this.jc().performance) && ok;
    }

    public static String target(Data data, int pre, String src, String trg) {
        String path = Token.string(data.text(pre, true));
        if (Prop.CASE ? path.equals(src) : path.equalsIgnoreCase(src)) {
            return trg;
        }
        String source = src.isEmpty() || src.endsWith("/") ? src : String.valueOf(src) + '/';
        String target = trg.isEmpty() || trg.endsWith("/") ? trg : String.valueOf(trg) + '/';
        return String.valueOf(target) + path.substring(source.length());
    }
}

