/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core;

import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.basex.io.IO;
import org.basex.io.IOFile;
import org.basex.io.IOStream;
import org.basex.io.in.NewlineInput;
import org.basex.util.Prop;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.list.StringList;

public final class Lang {
    private static final String SUFFIX = "lang";
    private static final HashMap<String, String> TEXTS = new HashMap();
    private static final HashMap<String, Boolean> CHECK = new HashMap();

    static {
        Lang.read(Prop.language);
    }

    private Lang() {
    }

    private static synchronized void read(String lang) {
        TEXTS.clear();
        CHECK.clear();
        String path = "/lang/" + lang + '.' + SUFFIX;
        InputStream is = Lang.class.getResourceAsStream(path);
        if (is == null) {
            Util.errln(String.valueOf(path) + " not found.", new Object[0]);
        } else {
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try (NewlineInput nli = new NewlineInput(is);){
                    String line;
                    while ((line = nli.readLine()) != null) {
                        int i = line.indexOf(61);
                        if (i == -1 || line.startsWith("#")) continue;
                        String key = line.substring(0, i).trim();
                        String val = line.substring(i + 1).trim();
                        if ("langright".equals(key)) {
                            Prop.langright = "true".equals(val);
                            continue;
                        }
                        if (val.contains("\\n")) {
                            val = val.replaceAll("\\\\n", Prop.NL);
                        }
                        if (Prop.langkeys) {
                            val = String.valueOf('[') + key + ": " + val + ']';
                        }
                        if (TEXTS.put(key, val) != null) {
                            Util.errln("%.lang: '%' is declared twice", lang, key);
                        }
                        CHECK.put(key, true);
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException ex) {
                Util.errln(ex, new Object[0]);
            }
        }
    }

    static synchronized String lang(String key) {
        if (key == null) {
            for (String s : CHECK.keySet()) {
                Util.errln("%.lang: '%' can be removed", Prop.language, s);
            }
            return "---";
        }
        String val = TEXTS.get(key);
        if (val == null) {
            Util.errln("%.lang: '%' is missing", Prop.language, key);
            return String.valueOf('[') + key + ']';
        }
        CHECK.remove(key);
        return val;
    }

    static synchronized String lang(String key, Object ... ext) {
        return Util.info(Lang.lang(key), ext);
    }

    public static synchronized String[][] parse() {
        StringList langs = new StringList();
        StringList creds = new StringList();
        try {
            URL url = Lang.class.getResource("/lang");
            if ("jar".equals(url.getProtocol())) {
                JarURLConnection conn = (JarURLConnection)url.openConnection();
                String pre = conn.getEntryName();
                JarFile jar = conn.getJarFile();
                Enumeration<JarEntry> je = jar.entries();
                while (je.hasMoreElements()) {
                    JarEntry entry = je.nextElement();
                    String name = entry.getName();
                    if (!name.startsWith(pre) || !name.endsWith(SUFFIX)) continue;
                    byte[] cont = new IOStream(jar.getInputStream(entry)).read();
                    langs.add(name.replaceAll(".*/|.lang", ""));
                    creds.add(Lang.credits(cont));
                }
            } else {
                IOFile[] iOFileArray = ((IOFile)IO.get(url.toString())).children();
                int n = iOFileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IOFile f = iOFileArray[n2];
                    langs.add(f.name().replace(".lang", ""));
                    creds.add(Lang.credits(((IO)f).read()));
                    ++n2;
                }
            }
        }
        catch (IOException ex) {
            Util.errln(ex, new Object[0]);
        }
        return new String[][]{(String[])langs.finish(), (String[])creds.finish()};
    }

    private static synchronized String credits(byte[] cont) {
        StringTokenizer st = new StringTokenizer(Token.string(cont), "\n");
        st.nextToken();
        return st.nextToken().replaceAll("# ", "");
    }

    static void check() {
        IOFile[] files;
        Lang.read(Prop.language);
        StringBuilder sb = new StringBuilder();
        HashSet<String> set = new HashSet<String>(TEXTS.keySet());
        IOFile[] iOFileArray = files = new IOFile("src/main/resources/lang").children();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            IOFile file = iOFileArray[n2];
            String lang = file.name().replace(".lang", "");
            if (!lang.equals(Prop.language)) {
                Lang.read(lang);
                String[] stringArray = set.toArray(new String[set.size()]);
                int n3 = stringArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    String text = stringArray[n4];
                    if (TEXTS.remove(text) == null) {
                        sb.append("- ").append(text).append('\n');
                    }
                    ++n4;
                }
                if (sb.length() != 0) {
                    Util.err("Missing in %.lang:\n%", lang, sb);
                    sb.setLength(0);
                }
                for (String s : TEXTS.keySet()) {
                    sb.append("- ").append(s).append('\n');
                }
                if (sb.length() != 0) {
                    Util.err("Not defined in %.lang:\n%", lang, sb);
                    sb.setLength(0);
                }
            }
            ++n2;
        }
    }
}

