/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core;

import java.util.Date;
import java.util.HashSet;
import java.util.regex.Pattern;
import org.basex.core.StaticOptions;
import org.basex.io.IOFile;
import org.basex.util.DateTime;
import org.basex.util.Prop;
import org.basex.util.Token;
import org.basex.util.list.StringList;

public final class Databases {
    public static final String DATE = "\\d{4}-\\d{2}-\\d{2}-\\d{2}-\\d{2}-\\d{2}";
    public static final String DBCHARS = "-+=~!#$%^&()[]{}@'`";
    private static final String REGEXCHARS = "-+=~!#$%^&()[]{}@'`".replaceAll("(.)", "\\\\$1");
    private static final Pattern ZIPPATTERN = Pattern.compile("-\\d{4}-\\d{2}-\\d{2}-\\d{2}-\\d{2}-\\d{2}\\.zip$");
    private static final Pattern REGEX = Pattern.compile(".*[*?,].*");
    private final StaticOptions soptions;

    Databases(StaticOptions soptions) {
        this.soptions = soptions;
    }

    public StringList list() {
        return this.list(true, true, null);
    }

    public StringList listDBs(String name) {
        return this.list(true, false, name);
    }

    private StringList list(boolean db, boolean backup, String name) {
        Pattern pt = name == null ? null : Databases.regex(name);
        IOFile[] children = this.soptions.dbPath().children();
        StringList list = new StringList(children.length);
        HashSet<String> map = new HashSet<String>(children.length);
        IOFile[] iOFileArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IOFile f = iOFileArray[n2];
            String fn = f.name();
            String add = null;
            if (backup && fn.endsWith(".zip")) {
                String nn = ZIPPATTERN.split(fn)[0];
                if (!nn.equals(fn)) {
                    add = nn;
                }
            } else if (db && f.isDir() && !fn.startsWith(".")) {
                add = fn;
            }
            if (add != null && (pt == null || pt.matcher(add).matches()) && map.add(add)) {
                list.add(add);
            }
            ++n2;
        }
        return list.sort(false);
    }

    public static Pattern regex(String pattern) {
        return Databases.regex(pattern, "");
    }

    public static Pattern regex(String pattern, String suffix) {
        if (pattern == null) {
            return null;
        }
        String nm = REGEX.matcher(pattern).matches() ? IOFile.regex(pattern) : String.valueOf(pattern.replaceAll("([" + REGEXCHARS + "])", "\\\\$1")) + suffix;
        return Pattern.compile(nm, Prop.CASE ? 0 : 2);
    }

    public StringList backups() {
        StringList backups = new StringList();
        IOFile[] iOFileArray = this.soptions.dbPath().children();
        int n = iOFileArray.length;
        int n2 = 0;
        while (n2 < n) {
            IOFile f = iOFileArray[n2];
            String n3 = f.name();
            if (n3.endsWith(".zip")) {
                backups.add(n3.substring(0, n3.lastIndexOf(46)));
            }
            ++n2;
        }
        return backups;
    }

    public StringList backups(String db) {
        StringList backups = new StringList();
        IOFile file = this.soptions.dbPath(String.valueOf(db) + ".zip");
        if (file.exists()) {
            backups.add(db);
        } else {
            Pattern regex = Databases.regex(db, "-\\d{4}-\\d{2}-\\d{2}-\\d{2}-\\d{2}-\\d{2}\\.zip");
            IOFile[] iOFileArray = this.soptions.dbPath().children();
            int n = iOFileArray.length;
            int n2 = 0;
            while (n2 < n) {
                IOFile f = iOFileArray[n2];
                String n3 = f.name();
                if (regex.matcher(n3).matches()) {
                    backups.add(n3.substring(0, n3.lastIndexOf(46)));
                }
                ++n2;
            }
        }
        return backups.sort(Prop.CASE, false);
    }

    public static String name(String backup) {
        return Pattern.compile("-\\d{4}-\\d{2}-\\d{2}-\\d{2}-\\d{2}-\\d{2}$").split(backup)[0];
    }

    public static Date date(String backup) {
        return DateTime.parse(backup.replaceAll("^.+-(\\d{4}-\\d{2}-\\d{2}-\\d{2}-\\d{2}-\\d{2})$", "$1"));
    }

    public static boolean validChar(int ch, boolean firstLast) {
        return Token.letterOrDigit(ch) || DBCHARS.indexOf(ch) != -1 || !firstLast && ch == 46;
    }

    public static boolean validName(String name) {
        return Databases.validName(name, false);
    }

    public static boolean validName(String name, boolean glob) {
        if (name == null) {
            return false;
        }
        int nl = name.length();
        int n = 0;
        while (n < nl) {
            char ch = name.charAt(n);
            if ((!glob || ch != '?' && ch != '*' && ch != ',') && !Databases.validChar(ch, n == 0 || n + 1 == nl)) {
                return false;
            }
            ++n;
        }
        return nl != 0;
    }
}

