/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util.similarity;

import org.basex.util.FTToken;
import org.basex.util.Token;

public final class Levenshtein {
    private static final int MAX = 50;
    private final int error;
    private int[][] matrix;

    public Levenshtein() {
        this(0);
    }

    public Levenshtein(int error) {
        this.error = error;
    }

    public boolean similar(byte[] token, byte[] sub) {
        return this.similar(token, sub, this.error);
    }

    public boolean similar(byte[] token, byte[] sub, int err) {
        int k;
        int sl = sub.length;
        int tl = token.length;
        int slen = 0;
        int tlen = 0;
        int s = 0;
        while (s < sl) {
            ++slen;
            s += Token.cl(sub, s);
        }
        int t = 0;
        while (t < tl) {
            ++tlen;
            t += Token.cl(token, t);
        }
        if (tlen == 0) {
            return false;
        }
        if (err == 0 && slen < 4 || tlen > 50 || slen > 50) {
            return slen == tlen && Levenshtein.same(token, sub);
        }
        int n = k = err == 0 ? Math.max(1, slen >> 2) : err;
        return Math.abs(slen - tlen) <= k && this.ls(token, tlen, sub, slen, k);
    }

    private boolean ls(byte[] tk, int tl, byte[] sb, int sl, int k) {
        int[][] mx = this.matrix;
        if (mx == null) {
            mx = new int[52][52];
            int ml = mx.length;
            int m = 0;
            while (m < ml) {
                mx[0][m] = m;
                mx[m][0] = m;
                ++m;
            }
            this.matrix = mx;
        }
        int e2 = -1;
        int f2 = -1;
        int t = 0;
        while (t < tl) {
            int e = FTToken.noDiacritics(Token.lc(Token.cp(tk, t)));
            int d = Integer.MAX_VALUE;
            int s = 0;
            while (s < sl) {
                int f = FTToken.noDiacritics(Token.lc(Token.cp(sb, s)));
                int c = Levenshtein.m(mx[t][s + 1] + 1, mx[t + 1][s] + 1, mx[t][s] + (e == f ? 0 : 1));
                if (e == f2 && f == e2) {
                    c = mx[t][s];
                }
                mx[t + 1][s + 1] = c;
                d = Math.min(d, c);
                f2 = f;
                s += Token.cl(sb, s);
            }
            if (d > k) {
                return false;
            }
            e2 = e;
            t += Token.cl(tk, t);
        }
        return mx[tl][sl] <= k;
    }

    public static double distance(int[] cps1, int[] cps2) {
        int l1 = cps1.length;
        int l2 = cps2.length;
        int lMax = Math.max(l1, l2);
        if (lMax == 0) {
            return 1.0;
        }
        int[][] m = new int[lMax + 1][lMax + 1];
        int f2 = -1;
        int f1 = -1;
        int p1 = 0;
        while (p1 < lMax) {
            int c1 = p1 < l1 ? cps1[p1] : 0;
            int p2 = 0;
            while (p2 < lMax) {
                int c2 = p2 < l2 ? cps2[p2] : 0;
                int c = Levenshtein.m(m[p1][p2 + 1] + 1, m[p1 + 1][p2] + 1, m[p1][p2] + (c1 == c2 ? 0 : 1));
                if (c1 == f1 && c2 == f2) {
                    c = m[p1][p2];
                }
                m[p1 + 1][p2 + 1] = c;
                f1 = c2;
                ++p2;
            }
            f2 = c1;
            ++p1;
        }
        return (double)(lMax - m[lMax][lMax]) / (double)lMax;
    }

    private static int m(int a, int b, int c) {
        int d = a < b ? a : b;
        return d < c ? d : c;
    }

    private static boolean same(byte[] tk, byte[] sb) {
        int tl = tk.length;
        int sl = sb.length;
        int s = 0;
        int t = 0;
        while (t < tl && s < sl) {
            if (Token.lc(FTToken.noDiacritics(Token.cp(tk, t))) != Token.lc(FTToken.noDiacritics(Token.cp(sb, t)))) {
                return false;
            }
            t += Token.cl(tk, t);
            s += Token.cl(sb, s);
        }
        return true;
    }
}

