/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.seq.tree;

import java.util.Arrays;
import org.basex.query.util.fingertree.Node;
import org.basex.query.util.fingertree.NodeLike;
import org.basex.query.value.item.Item;
import org.basex.query.value.seq.tree.PartialLeafNode;
import org.basex.util.Util;

final class LeafNode
implements Node<Item, Item> {
    final Item[] values;

    LeafNode(Item[] values) {
        this.values = values;
        assert (values.length >= 8 && values.length <= 15);
    }

    @Override
    public long size() {
        return this.values.length;
    }

    public LeafNode reverse() {
        int n = this.values.length;
        Item[] out = new Item[n];
        int i = 0;
        while (i < n) {
            out[i] = this.values[n - 1 - i];
            ++i;
        }
        return new LeafNode(out);
    }

    @Override
    public boolean insert(Node<Item, Item>[] siblings, long pos, Item val) {
        int p = (int)pos;
        int n = this.values.length;
        Item[] vals = new Item[n + 1];
        System.arraycopy(this.values, 0, vals, 0, p);
        vals[p] = val;
        System.arraycopy(this.values, p, vals, p + 1, n - p);
        if (n < 15) {
            siblings[1] = new LeafNode(vals);
            return false;
        }
        LeafNode left = (LeafNode)siblings[0];
        if (left != null && left.values.length < 15) {
            Item[] lvals = left.values;
            int l = lvals.length;
            int diff = 15 - l;
            int move = (diff + 1) / 2;
            Item[] newLeft = new Item[l + move];
            Item[] newRight = new Item[n + 1 - move];
            System.arraycopy(lvals, 0, newLeft, 0, l);
            System.arraycopy(vals, 0, newLeft, l, move);
            System.arraycopy(vals, move, newRight, 0, newRight.length);
            siblings[0] = new LeafNode(newLeft);
            siblings[1] = new LeafNode(newRight);
            return false;
        }
        LeafNode right = (LeafNode)siblings[2];
        if (right != null && right.values.length < 15) {
            Item[] rvals = right.values;
            int r = rvals.length;
            int diff = 15 - r;
            int move = (diff + 1) / 2;
            int l = n + 1 - move;
            Item[] newLeft = new Item[l];
            Item[] newRight = new Item[r + move];
            System.arraycopy(vals, 0, newLeft, 0, l);
            System.arraycopy(vals, l, newRight, 0, move);
            System.arraycopy(rvals, 0, newRight, move, r);
            siblings[1] = new LeafNode(newLeft);
            siblings[2] = new LeafNode(newRight);
            return false;
        }
        int l = vals.length / 2;
        int r = vals.length - l;
        Item[] newLeft = new Item[l];
        Item[] newRight = new Item[r];
        System.arraycopy(vals, 0, newLeft, 0, l);
        System.arraycopy(vals, l, newRight, 0, r);
        siblings[3] = siblings[2];
        siblings[1] = new LeafNode(newLeft);
        siblings[2] = new LeafNode(newRight);
        return true;
    }

    public LeafNode set(long pos, Item val) {
        Item[] vals = (Item[])this.values.clone();
        vals[(int)pos] = val;
        return new LeafNode(vals);
    }

    @Override
    public NodeLike<Item, Item>[] remove(Node<Item, Item> left, Node<Item, Item> right, long pos) {
        int p = (int)pos;
        int n = this.values.length;
        NodeLike[] nodeLikeArray = new NodeLike[3];
        nodeLikeArray[0] = left;
        nodeLikeArray[2] = right;
        NodeLike[] out = nodeLikeArray;
        if (n > 8) {
            Item[] vals = new Item[n - 1];
            System.arraycopy(this.values, 0, vals, 0, p);
            System.arraycopy(this.values, p + 1, vals, p, n - 1 - p);
            out[1] = new LeafNode(vals);
            return out;
        }
        LeafNode leftLeaf = (LeafNode)left;
        if (leftLeaf != null && leftLeaf.arity() > 8) {
            Item[] lvals = leftLeaf.values;
            int l = lvals.length;
            int diff = l - 8;
            int move = (diff + 1) / 2;
            int ll = l - move;
            int rl = n - 1 + move;
            Item[] newLeft = new Item[ll];
            Item[] newRight = new Item[rl];
            System.arraycopy(lvals, 0, newLeft, 0, ll);
            System.arraycopy(lvals, ll, newRight, 0, move);
            System.arraycopy(this.values, 0, newRight, move, p);
            System.arraycopy(this.values, p + 1, newRight, move + p, n - 1 - p);
            out[0] = new LeafNode(newLeft);
            out[1] = new LeafNode(newRight);
            return out;
        }
        LeafNode rightLeaf = (LeafNode)right;
        if (rightLeaf != null && rightLeaf.arity() > 8) {
            Item[] rvals = rightLeaf.values;
            int r = rvals.length;
            int diff = r - 8;
            int move = (diff + 1) / 2;
            int ll = n - 1 + move;
            int rl = r - move;
            Item[] newLeft = new Item[ll];
            Item[] newRight = new Item[rl];
            System.arraycopy(this.values, 0, newLeft, 0, p);
            System.arraycopy(this.values, p + 1, newLeft, p, n - 1 - p);
            System.arraycopy(rvals, 0, newLeft, n - 1, move);
            System.arraycopy(rvals, move, newRight, 0, rl);
            out[1] = new LeafNode(newLeft);
            out[2] = new LeafNode(newRight);
            return out;
        }
        if (left != null) {
            Item[] lvals = ((LeafNode)left).values;
            int l = lvals.length;
            int r = this.values.length;
            Item[] vals = new Item[l + r - 1];
            System.arraycopy(lvals, 0, vals, 0, l);
            System.arraycopy(this.values, 0, vals, l, p);
            System.arraycopy(this.values, p + 1, vals, l + p, r - 1 - p);
            out[0] = new LeafNode(vals);
            out[1] = null;
            return out;
        }
        if (right != null) {
            Item[] rvals = ((LeafNode)right).values;
            int l = this.values.length;
            int r = rvals.length;
            Item[] vals = new Item[l - 1 + r];
            System.arraycopy(this.values, 0, vals, 0, p);
            System.arraycopy(this.values, p + 1, vals, p, l - 1 - p);
            System.arraycopy(rvals, 0, vals, l - 1, r);
            out[1] = null;
            out[2] = new LeafNode(vals);
            return out;
        }
        Item[] vals = new Item[n - 1];
        System.arraycopy(this.values, 0, vals, 0, p);
        System.arraycopy(this.values, p + 1, vals, p, n - 1 - p);
        out[1] = new PartialLeafNode(vals);
        return out;
    }

    @Override
    public int append(NodeLike<Item, Item>[] nodes, int pos) {
        if (pos == 0) {
            nodes[0] = this;
            return 1;
        }
        NodeLike<Item, Item> left = nodes[pos - 1];
        if (!(left instanceof PartialLeafNode)) {
            nodes[pos] = this;
            return pos + 1;
        }
        Item[] ls = ((PartialLeafNode)left).elems;
        int l = ls.length;
        Item[] rs = this.values;
        int r = rs.length;
        int n = l + r;
        if (n <= 15) {
            Item[] vals = new Item[n];
            System.arraycopy(ls, 0, vals, 0, l);
            System.arraycopy(rs, 0, vals, l, r);
            nodes[pos - 1] = new LeafNode(vals);
            return pos;
        }
        int ll = n / 2;
        int rl = n - ll;
        int move = r - rl;
        Item[] newLeft = new Item[ll];
        Item[] newRight = new Item[rl];
        System.arraycopy(ls, 0, newLeft, 0, l);
        System.arraycopy(rs, 0, newLeft, l, move);
        System.arraycopy(rs, move, newRight, 0, rl);
        nodes[pos - 1] = new LeafNode(newLeft);
        nodes[pos] = new LeafNode(newRight);
        return pos + 1;
    }

    @Override
    public NodeLike<Item, Item> slice(long off, long size) {
        int p = (int)off;
        int n = (int)size;
        Item[] out = new Item[n];
        System.arraycopy(this.values, p, out, 0, n);
        return n < 8 ? new PartialLeafNode(out) : new LeafNode(out);
    }

    public String toString() {
        return String.valueOf(Util.className(this)) + '(' + this.size() + ')' + Arrays.toString(this.values);
    }

    @Override
    public long checkInvariants() {
        if (this.values.length < 8 || this.values.length > 15) {
            throw new AssertionError((Object)("Wrong " + Util.className(this) + " size: " + this.values.length));
        }
        return this.values.length;
    }

    @Override
    public int arity() {
        return this.values.length;
    }

    @Override
    public Item getSub(int index) {
        return this.values[index];
    }
}

