/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.item;

import java.util.LinkedList;
import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryFocus;
import org.basex.query.StaticContext;
import org.basex.query.expr.Expr;
import org.basex.query.expr.ParseExpr;
import org.basex.query.expr.TypeCheck;
import org.basex.query.expr.gflwor.Clause;
import org.basex.query.expr.gflwor.GFLWOR;
import org.basex.query.expr.gflwor.Let;
import org.basex.query.func.DynFuncCall;
import org.basex.query.func.StaticFunc;
import org.basex.query.scope.Scope;
import org.basex.query.util.ASTVisitor;
import org.basex.query.util.Flag;
import org.basex.query.util.list.AnnList;
import org.basex.query.value.Value;
import org.basex.query.value.item.FItem;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.query.value.node.FElem;
import org.basex.query.value.type.FuncType;
import org.basex.query.value.type.SeqType;
import org.basex.query.var.Var;
import org.basex.query.var.VarRef;
import org.basex.query.var.VarScope;
import org.basex.util.InputInfo;
import org.basex.util.TokenBuilder;
import org.basex.util.hash.IntObjMap;

public final class FuncItem
extends FItem
implements Scope {
    public final StaticContext sc;
    public final Expr expr;
    private final QNm name;
    private final Var[] params;
    private final QueryFocus focus;
    private final int stackSize;

    public FuncItem(StaticContext sc, AnnList anns, QNm name, Var[] params, FuncType type, Expr expr, int stackSize) {
        this(sc, anns, name, params, type, expr, new QueryFocus(), stackSize);
    }

    public FuncItem(StaticContext sc, AnnList anns, QNm name, Var[] params, FuncType type, Expr expr, QueryFocus focus, int stackSize) {
        super(type, anns);
        this.name = name;
        this.params = params;
        this.expr = expr;
        this.stackSize = stackSize;
        this.sc = sc;
        this.focus = focus;
    }

    @Override
    public int arity() {
        return this.params.length;
    }

    @Override
    public QNm funcName() {
        return this.name;
    }

    @Override
    public QNm paramName(int ps) {
        return this.params[ps].name;
    }

    @Override
    public FuncType funcType() {
        return (FuncType)this.type;
    }

    @Override
    public int stackFrameSize() {
        return this.stackSize;
    }

    @Override
    public Value invValue(QueryContext qc, InputInfo info, Value ... args) throws QueryException {
        QueryFocus qf = qc.focus;
        qc.focus = this.focus;
        try {
            int pl = this.params.length;
            int p = 0;
            while (p < pl) {
                qc.set(this.params[p], args[p]);
                ++p;
            }
            Value value = this.expr.value(qc);
            return value;
        }
        finally {
            qc.focus = qf;
        }
    }

    @Override
    public Item invItem(QueryContext qc, InputInfo info, Value ... args) throws QueryException {
        QueryFocus qf = qc.focus;
        qc.focus = this.focus;
        try {
            int pl = this.params.length;
            int p = 0;
            while (p < pl) {
                qc.set(this.params[p], args[p]);
                ++p;
            }
            Item item = this.expr.item(qc, info);
            return item;
        }
        finally {
            qc.focus = qf;
        }
    }

    @Override
    public FuncItem coerceTo(FuncType ft, QueryContext qc, InputInfo info, boolean opt) throws QueryException {
        ParseExpr checked;
        DynFuncCall optimized;
        int pl = this.params.length;
        if (pl != ft.argTypes.length) {
            throw QueryError.typeError(this, ft.seqType(), null, info);
        }
        FuncType tp = this.funcType();
        if (opt ? tp.eq(ft) : tp.instanceOf(ft)) {
            return this;
        }
        VarScope vs = new VarScope(this.sc);
        Var[] vars = new Var[pl];
        Expr[] args = new Expr[pl];
        int p = pl;
        while (p-- > 0) {
            vars[p] = vs.addNew(this.params[p].name, ft.argTypes[p], true, qc, info);
            args[p] = new VarRef(info, vars[p]).optimize(null);
        }
        DynFuncCall ex = new DynFuncCall(info, this.sc, this.expr.has(Flag.UPD), false, (Expr)this, args);
        CompileContext cc = new CompileContext(qc);
        cc.pushScope(vs);
        Expr expr = optimized = opt ? ((Expr)ex).optimize(cc) : ex;
        if (tp.declType.instanceOf(ft.declType)) {
            checked = optimized;
        } else {
            TypeCheck tc = new TypeCheck(this.sc, info, optimized, ft.declType, true);
            checked = opt ? tc.optimize(cc) : tc;
        }
        ((Expr)checked).markTailCalls(null);
        return new FuncItem(this.sc, this.anns, this.name, vars, ft, checked, vs.stackSize());
    }

    @Override
    public boolean accept(ASTVisitor visitor) {
        return visitor.funcItem(this);
    }

    @Override
    public boolean visit(ASTVisitor visitor) {
        Var[] varArray = this.params;
        int n = this.params.length;
        int n2 = 0;
        while (n2 < n) {
            Var var = varArray[n2];
            if (!visitor.declared(var)) {
                return false;
            }
            ++n2;
        }
        return this.expr.accept(visitor);
    }

    @Override
    public void comp(CompileContext cc) {
    }

    @Override
    public boolean compiled() {
        return true;
    }

    @Override
    public Object toJava() {
        return this;
    }

    @Override
    public Expr inlineExpr(Expr[] exprs, CompileContext cc, InputInfo info) throws QueryException {
        if (!StaticFunc.inline(cc, this.anns, this.expr) || this.expr.has(Flag.CTX)) {
            return null;
        }
        cc.info("inline %", this);
        LinkedList<Clause> clauses = exprs.length == 0 ? null : new LinkedList<Clause>();
        IntObjMap<Var> vm = new IntObjMap<Var>();
        int pl = this.params.length;
        int p = 0;
        while (p < pl) {
            clauses.add(new Let(cc.copy(this.params[p], vm), exprs[p], false).optimize(cc));
            ++p;
        }
        Expr rt = this.expr.copy(cc, vm);
        rt.accept(new ASTVisitor(){

            @Override
            public boolean inlineFunc(Scope scope) {
                return scope.visit(this);
            }

            @Override
            public boolean dynFuncCall(DynFuncCall call) {
                call.markInlined(FuncItem.this);
                return true;
            }
        });
        return clauses == null ? rt : new GFLWOR(info, clauses, rt).optimize(cc);
    }

    @Override
    public boolean isVacuousBody() {
        SeqType st = this.expr.seqType();
        return st != null && st.zero() && !this.expr.has(Flag.UPD);
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj;
    }

    @Override
    public void plan(FElem plan) {
        byte[] nm = this.name == null ? null : this.name.prefixId();
        FuncItem.addPlan(plan, this.planElem("name", nm, "type", this.type), new Object[]{this.params, this.expr});
    }

    @Override
    public String toErrorString() {
        return this.toString(true);
    }

    @Override
    public String toString() {
        return this.toString(false);
    }

    private String toString(boolean error) {
        FuncType ft = (FuncType)this.type;
        TokenBuilder tb = new TokenBuilder();
        if (this.name != null) {
            tb.add("(: ").add(this.name.prefixId()).add("#").addInt(this.arity()).add(" :) ");
        }
        tb.addExt(this.anns, new Object[0]).add("function").add(40);
        int pl = this.params.length;
        int p = 0;
        while (p < pl) {
            if (p != 0) {
                tb.add(",");
            }
            tb.addExt(error ? this.params[p].toErrorString() : this.params[p], new Object[0]);
            ++p;
        }
        return tb.add(41).add(" as ").addExt(ft.declType, new Object[0]).add(" {...}").toString();
    }
}

