/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.array;

import java.util.ListIterator;
import org.basex.query.QueryContext;
import org.basex.query.value.Value;
import org.basex.query.value.array.Array;
import org.basex.query.value.array.BigArray;
import org.basex.util.Util;

final class SmallArray
extends Array {
    final Value[] elems;

    SmallArray(Value[] elems) {
        this.elems = elems;
        assert (elems.length >= 1 && elems.length <= 7);
    }

    @Override
    public Array cons(Value head) {
        if (this.elems.length < 7) {
            Value[] newElems = SmallArray.slice(this.elems, -1, this.elems.length);
            newElems[0] = head;
            return new SmallArray(newElems);
        }
        int mid = 3;
        Value[] left = SmallArray.slice(this.elems, -1, 3);
        Value[] right = SmallArray.slice(this.elems, 3, this.elems.length);
        left[0] = head;
        return new BigArray(left, right);
    }

    @Override
    public Array snoc(Value last) {
        if (this.elems.length < 7) {
            Value[] newElems = SmallArray.slice(this.elems, 0, this.elems.length + 1);
            newElems[newElems.length - 1] = last;
            return new SmallArray(newElems);
        }
        Value[] left = SmallArray.slice(this.elems, 0, 4);
        Value[] right = SmallArray.slice(this.elems, 4, this.elems.length + 1);
        right[right.length - 1] = last;
        return new BigArray(left, right);
    }

    @Override
    public Value get(long index) {
        return this.elems[(int)index];
    }

    @Override
    public Array put(long pos, Value val) {
        Value[] values = (Value[])this.elems.clone();
        values[(int)pos] = val;
        return new SmallArray(values);
    }

    @Override
    public long arraySize() {
        return this.elems.length;
    }

    @Override
    public Array concat(Array seq) {
        return seq.isEmptyArray() ? this : seq.consSmall(this.elems);
    }

    @Override
    public Value head() {
        return this.elems[0];
    }

    @Override
    public Value last() {
        return this.elems[this.elems.length - 1];
    }

    @Override
    public Array init() {
        if (this.elems.length == 1) {
            return SmallArray.empty();
        }
        return new SmallArray(SmallArray.slice(this.elems, 0, this.elems.length - 1));
    }

    @Override
    public Array tail() {
        if (this.elems.length == 1) {
            return SmallArray.empty();
        }
        return new SmallArray(SmallArray.slice(this.elems, 1, this.elems.length));
    }

    @Override
    public boolean isEmptyArray() {
        return false;
    }

    @Override
    public Array reverseArray(QueryContext qc) {
        qc.checkStop();
        int n = this.elems.length;
        if (n == 1) {
            return this;
        }
        Value[] es = new Value[n];
        int i = 0;
        while (i < n) {
            es[i] = this.elems[n - 1 - i];
            ++i;
        }
        return new SmallArray(es);
    }

    @Override
    public Array insertBefore(long pos, Value value, QueryContext qc) {
        qc.checkStop();
        int p = (int)pos;
        int n = this.elems.length;
        Value[] out = new Value[n + 1];
        System.arraycopy(this.elems, 0, out, 0, p);
        out[p] = value;
        System.arraycopy(this.elems, p, out, p + 1, n - p);
        if (n < 7) {
            return new SmallArray(out);
        }
        return new BigArray(SmallArray.slice(out, 0, 4), SmallArray.slice(out, 4, n + 1));
    }

    @Override
    public Array remove(long pos, QueryContext qc) {
        qc.checkStop();
        int p = (int)pos;
        int n = this.elems.length;
        if (n == 1) {
            return SmallArray.empty();
        }
        Value[] out = new Value[n - 1];
        System.arraycopy(this.elems, 0, out, 0, p);
        System.arraycopy(this.elems, p + 1, out, p, n - 1 - p);
        return new SmallArray(out);
    }

    @Override
    public Array subArray(long pos, long len, QueryContext qc) {
        qc.checkStop();
        int p = (int)pos;
        int n = (int)len;
        return n == 0 ? Array.empty() : new SmallArray(SmallArray.slice(this.elems, p, p + n));
    }

    @Override
    public ListIterator<Value> iterator(long start) {
        return new ListIterator<Value>(start){
            private int index;
            {
                this.index = (int)Math.max(0L, Math.min(l, (long)SmallArray.this.elems.length));
            }

            @Override
            public int nextIndex() {
                return this.index;
            }

            @Override
            public boolean hasNext() {
                return this.index < SmallArray.this.elems.length;
            }

            @Override
            public Value next() {
                return SmallArray.this.elems[this.index++];
            }

            @Override
            public int previousIndex() {
                return this.index - 1;
            }

            @Override
            public boolean hasPrevious() {
                return this.index > 0;
            }

            @Override
            public Value previous() {
                return SmallArray.this.elems[--this.index];
            }

            @Override
            public void set(Value e) {
                throw Util.notExpected();
            }

            @Override
            public void add(Value e) {
                throw Util.notExpected();
            }

            @Override
            public void remove() {
                throw Util.notExpected();
            }
        };
    }

    @Override
    void checkInvariants() {
        int n = this.elems.length;
        if (n == 0) {
            throw new AssertionError((Object)("Empty array in " + Util.className(this)));
        }
        if (n > 7) {
            throw new AssertionError((Object)("Array too big: " + n));
        }
    }

    @Override
    Array consSmall(Value[] left) {
        int l = left.length;
        int r = this.elems.length;
        int n = l + r;
        if (Math.min(l, r) >= 4) {
            return new BigArray(left, this.elems);
        }
        Value[] out = new Value[n];
        System.arraycopy(left, 0, out, 0, l);
        System.arraycopy(this.elems, 0, out, l, r);
        if (n <= 7) {
            return new SmallArray(out);
        }
        int mid = n / 2;
        return new BigArray(SmallArray.slice(out, 0, mid), SmallArray.slice(out, mid, n));
    }
}

