/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.array;

import java.util.Collections;
import java.util.ListIterator;
import org.basex.query.QueryContext;
import org.basex.query.value.Value;
import org.basex.query.value.array.Array;
import org.basex.query.value.array.SmallArray;
import org.basex.util.Util;

final class EmptyArray
extends Array {
    static final EmptyArray INSTANCE = new EmptyArray();

    private EmptyArray() {
    }

    @Override
    public Array cons(Value elem) {
        return new SmallArray(new Value[]{elem});
    }

    @Override
    public Array snoc(Value elem) {
        return new SmallArray(new Value[]{elem});
    }

    @Override
    public Value get(long index) {
        throw Util.notExpected();
    }

    @Override
    public Array put(long pos, Value val) {
        throw Util.notExpected();
    }

    @Override
    public long arraySize() {
        return 0L;
    }

    @Override
    public Array concat(Array seq) {
        return seq;
    }

    @Override
    public Value head() {
        throw Util.notExpected();
    }

    @Override
    public Value last() {
        throw Util.notExpected();
    }

    @Override
    public Array init() {
        throw Util.notExpected();
    }

    @Override
    public Array tail() {
        throw Util.notExpected();
    }

    @Override
    public Array subArray(long pos, long len, QueryContext qc) {
        return this;
    }

    @Override
    public boolean isEmptyArray() {
        return true;
    }

    @Override
    public Array reverseArray(QueryContext qc) {
        return this;
    }

    @Override
    public Array insertBefore(long pos, Value value, QueryContext qc) {
        return new SmallArray(new Value[]{value});
    }

    @Override
    public Array remove(long pos, QueryContext qc) {
        throw Util.notExpected();
    }

    @Override
    public ListIterator<Value> iterator(long size) {
        return Collections.emptyListIterator();
    }

    @Override
    void checkInvariants() {
    }

    @Override
    Array consSmall(Value[] values) {
        return new SmallArray(values);
    }
}

