/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.util.pkg;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import org.basex.io.IOFile;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.util.pkg.EXPathRepo;
import org.basex.query.util.pkg.Pkg;
import org.basex.query.util.pkg.PkgComponent;
import org.basex.query.util.pkg.PkgDep;
import org.basex.query.util.pkg.PkgParser;
import org.basex.util.InputInfo;
import org.basex.util.Prop;
import org.basex.util.Strings;
import org.basex.util.Version;

public final class PkgValidator {
    private final EXPathRepo repo;
    private final InputInfo info;

    public PkgValidator(EXPathRepo repo, InputInfo info) {
        this.repo = repo;
        this.info = info;
    }

    public void check(Pkg pkg) throws QueryException {
        this.checkDepends(pkg);
        this.checkComps(pkg);
    }

    private void checkDepends(Pkg pkg) throws QueryException {
        ArrayList<PkgDep> procs = new ArrayList<PkgDep>();
        for (PkgDep dep : pkg.dep) {
            if (dep.name == null && dep.processor == null) {
                throw QueryError.REPO_DESCRIPTOR_X.get(this.info, "Dependency not completely specified.");
            }
            if (dep.name != null && this.depPkg(dep) == null) {
                throw QueryError.REPO_NOTFOUND_X.get(this.info, dep.name);
            }
            if (dep.processor == null) continue;
            procs.add(dep);
        }
        if (!procs.isEmpty()) {
            this.checkProcs(procs);
        }
    }

    String depPkg(PkgDep dep) {
        HashSet<String> instVers = new HashSet<String>();
        for (String nextPkg : this.repo.pkgDict().keySet()) {
            if (!nextPkg.startsWith(dep.name)) continue;
            instVers.add(Pkg.version(nextPkg));
        }
        String version = PkgValidator.availVersion(dep, instVers);
        return version == null ? null : dep.id(version);
    }

    private void checkProcs(ArrayList<PkgDep> procs) throws QueryException {
        boolean supported = false;
        int i = Prop.VERSION.indexOf(32);
        HashSet<String> versions = new HashSet<String>();
        versions.add(i == -1 ? Prop.VERSION : Prop.VERSION.substring(0, i));
        for (PkgDep dep : procs) {
            if (!dep.processor.toLowerCase(Locale.ENGLISH).equals(Prop.PROJECT_NAME)) {
                supported = false;
                break;
            }
            boolean bl = supported = PkgValidator.availVersion(dep, versions) != null;
        }
        if (!supported) {
            throw QueryError.REPO_VERSION.get(this.info, new Object[0]);
        }
    }

    private static String availVersion(PkgDep dep, HashSet<String> versions) {
        if (versions.isEmpty()) {
            return null;
        }
        if (dep.versions != null) {
            HashSet versList = new HashSet();
            Collections.addAll(versList, Strings.split(dep.versions, ' '));
            for (String v : versList) {
                if (!versions.contains(v)) continue;
                return v;
            }
        } else if (dep.semver != null) {
            Version semVer = new Version(dep.semver);
            for (String v : versions) {
                if (!new Version(v).isCompatible(semVer)) continue;
                return v;
            }
        } else if (dep.semverMin != null && dep.semverMax != null) {
            Version min = new Version(dep.semverMin);
            Version max = new Version(dep.semverMax);
            for (String nextVer : versions) {
                Version v = new Version(nextVer);
                if (v.compareTo(min) < 0 || v.compareTo(max) >= 0) continue;
                return nextVer;
            }
        } else if (dep.semverMin != null) {
            Version semVer = new Version(dep.semverMin);
            for (String nextVer : versions) {
                Version v = new Version(nextVer);
                if (!v.isCompatible(semVer) && v.compareTo(semVer) < 0) continue;
                return nextVer;
            }
        } else if (dep.semverMax != null) {
            Version semVer = new Version(dep.semverMax);
            for (String nextVer : versions) {
                Version v = new Version(nextVer);
                if (!v.isCompatible(semVer) && v.compareTo(semVer) > 0) continue;
                return nextVer;
            }
        } else {
            return versions.iterator().next();
        }
        return null;
    }

    private void checkComps(Pkg pkg) throws QueryException {
        for (PkgComponent comp : pkg.comps) {
            if (!this.isInstalled(comp, pkg.name())) continue;
            throw QueryError.REPO_INSTALLED_X.get(this.info, comp.name());
        }
    }

    private boolean isInstalled(PkgComponent comp, String name) throws QueryException {
        HashSet<String> ids = this.repo.nsDict().get(comp.uri);
        if (ids == null) {
            return false;
        }
        for (String id : ids) {
            if (id == null || Pkg.name(id).equals(name)) continue;
            String pkgPath = this.repo.pkgDict().get(id).path();
            IOFile pkgDesc = new IOFile(this.repo.path(pkgPath), "expath-pkg.xml");
            Pkg pkg = new PkgParser(this.info).parse(pkgDesc);
            for (PkgComponent nextComp : pkg.comps) {
                if (!nextComp.name().equals(comp.name())) continue;
                return true;
            }
        }
        return false;
    }
}

