/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.util.pkg;

import java.io.IOException;
import java.util.function.Function;
import org.basex.io.IO;
import org.basex.io.IOContent;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryFunction;
import org.basex.query.QueryText;
import org.basex.query.iter.BasicNodeIter;
import org.basex.query.util.pkg.Pkg;
import org.basex.query.util.pkg.PkgComponent;
import org.basex.query.util.pkg.PkgDep;
import org.basex.query.util.pkg.PkgText;
import org.basex.query.value.item.QNm;
import org.basex.query.value.node.ANode;
import org.basex.query.value.node.DBNode;
import org.basex.query.value.type.NodeType;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.Util;

public final class PkgParser {
    private final InputInfo info;

    public PkgParser(InputInfo info) {
        this.info = info;
    }

    public Pkg parse(IO io) throws QueryException {
        ANode node;
        try {
            node = PkgParser.childElements(new DBNode(new IOContent(io.read()))).next();
            if (!PkgParser.eqNS(PkgText.E_PACKAGE, node.qname())) {
                throw QueryError.REPO_DESCRIPTOR_X.get(this.info, Util.info("Invalid element %", node.qname()));
            }
        }
        catch (IOException ex) {
            throw QueryError.REPO_PARSE_X_X.get(this.info, io.name(), ex);
        }
        QueryFunction<byte[], String> attribute = name -> {
            byte[] v = node.attribute((byte[])name);
            if (v == null) {
                throw QueryError.REPO_DESCRIPTOR_X.get(this.info, Util.info("'%' attribute missing in '%' element", name, PkgText.E_PACKAGE));
            }
            return Token.string(v);
        };
        Pkg pkg = new Pkg(attribute.apply(PkgText.A_NAME));
        pkg.abbrev = attribute.apply(PkgText.A_ABBREV);
        pkg.spec = attribute.apply(PkgText.A_SPEC);
        pkg.version = attribute.apply(PkgText.A_VERSION);
        this.parseChildren(node, pkg);
        return pkg;
    }

    private void parseChildren(ANode node, Pkg pkg) throws QueryException {
        ANode next;
        BasicNodeIter ch = PkgParser.childElements(node);
        while ((next = ch.next()) != null) {
            QNm name = next.qname();
            if (PkgParser.eqNS(PkgText.E_DEPENDENCY, name)) {
                pkg.dep.add(this.parseDependency(next));
                continue;
            }
            if (!PkgParser.eqNS(PkgText.E_XQUERY, name)) continue;
            pkg.comps.add(this.parseComp(next));
        }
    }

    private PkgDep parseDependency(ANode node) {
        Function<byte[], String> attribute = att -> {
            byte[] v = node.attribute((byte[])att);
            return v == null ? null : Token.string(v);
        };
        PkgDep dep = new PkgDep(attribute.apply(PkgText.A_PACKAGE));
        dep.processor = attribute.apply(PkgText.A_PROCESSOR);
        dep.versions = attribute.apply(PkgText.A_VERSIONS);
        dep.semver = attribute.apply(PkgText.A_SEMVER);
        dep.semverMin = attribute.apply(PkgText.A_SEMVER_MIN);
        dep.semverMax = attribute.apply(PkgText.A_SEMVER_MAX);
        return dep;
    }

    private PkgComponent parseComp(ANode node) throws QueryException {
        ANode next;
        BasicNodeIter iter = PkgParser.childElements(node);
        PkgComponent comp = new PkgComponent();
        while ((next = iter.next()) != null) {
            QNm name = next.qname();
            if (PkgParser.eqNS(PkgText.A_NAMESPACE, name)) {
                comp.uri = Token.string(next.string());
                continue;
            }
            if (PkgParser.eqNS(PkgText.A_FILE, name)) {
                comp.file = Token.string(next.string());
                continue;
            }
            throw QueryError.REPO_DESCRIPTOR_X.get(this.info, Util.info("Invalid element %", name));
        }
        if (comp.uri == null) {
            throw QueryError.REPO_DESCRIPTOR_X.get(this.info, Util.info("Component '%' not specified", new Object[]{PkgText.A_NAMESPACE}));
        }
        if (comp.file == null) {
            throw QueryError.REPO_DESCRIPTOR_X.get(this.info, Util.info("Component '%' not specified", new Object[]{PkgText.A_FILE}));
        }
        return comp;
    }

    private static BasicNodeIter childElements(ANode node) {
        return new BasicNodeIter(node){
            final BasicNodeIter ch;
            {
                this.ch = aNode.children();
            }

            @Override
            public ANode next() {
                ANode n;
                while ((n = this.ch.next()) != null && n.type != NodeType.ELM) {
                }
                return n;
            }
        };
    }

    private static boolean eqNS(byte[] cmp, QNm name) {
        return name.eq(new QNm(cmp, QueryText.PKG_URI));
    }
}

