/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.up.primitives.db;

import java.io.IOException;
import org.basex.data.Data;
import org.basex.io.IOFile;
import org.basex.io.in.BufferInput;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.up.primitives.Update;
import org.basex.query.up.primitives.UpdateType;
import org.basex.query.up.primitives.db.DBUpdate;
import org.basex.query.value.item.Item;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.hash.TokenObjMap;

public final class DBStore
extends DBUpdate {
    private final TokenObjMap<Item> map = new TokenObjMap();

    public DBStore(Data data, String path, Item item, InputInfo info) {
        super(UpdateType.DBSTORE, data, info);
        this.map.put(Token.token(path), item);
    }

    @Override
    public void merge(Update update) {
        DBStore put = (DBStore)update;
        for (byte[] path : put.map) {
            this.map.put(path, put.map.get(path));
        }
    }

    @Override
    public void apply() throws QueryException {
        for (byte[] path : this.map) {
            try {
                IOFile file = this.data.meta.binary(Token.string(path));
                if (file.isDir()) {
                    file.delete();
                }
                file.parent().md();
                Throwable throwable = null;
                Object var5_7 = null;
                try (BufferInput bi = this.map.get(path).input(this.info);){
                    file.write(bi);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException ex) {
                Util.debug(ex);
                throw QueryError.UPDBPUT_X.get(this.info, new Object[]{path});
            }
        }
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public void prepare() {
    }
}

