/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.up.primitives;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.basex.build.DirParser;
import org.basex.build.DiskBuilder;
import org.basex.build.MemBuilder;
import org.basex.build.Parser;
import org.basex.core.Context;
import org.basex.core.MainOptions;
import org.basex.core.StaticOptions;
import org.basex.core.cmd.CreateDB;
import org.basex.core.cmd.DropDB;
import org.basex.data.Data;
import org.basex.data.DataClip;
import org.basex.data.MemData;
import org.basex.io.IOFile;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.up.primitives.DBOptions;
import org.basex.query.up.primitives.NewInput;
import org.basex.query.value.node.ANode;
import org.basex.query.value.node.FDoc;
import org.basex.query.value.type.NodeType;
import org.basex.util.InputInfo;
import org.basex.util.Token;

public final class DBNew {
    public final List<NewInput> inputs;
    public Data data;
    private final QueryContext qc;
    private final InputInfo info;
    private final List<DBOptions> dboptions;

    public DBNew(QueryContext qc, DBOptions options, InputInfo info, NewInput ... list) {
        this.qc = qc;
        this.info = info;
        int is = list.length;
        this.inputs = new ArrayList<NewInput>(is);
        this.dboptions = new ArrayList<DBOptions>(is);
        NewInput[] newInputArray = list;
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            NewInput input = newInputArray[n2];
            this.inputs.add(input);
            this.dboptions.add(options);
            ++n2;
        }
    }

    public void merge(DBNew add) {
        this.inputs.addAll(add.inputs);
        this.dboptions.addAll(add.dboptions);
    }

    public void prepare(String name) throws QueryException {
        if (this.inputs.isEmpty()) {
            return;
        }
        boolean cache = false;
        for (DBOptions dbopts : this.dboptions) {
            Object obj = dbopts.get(MainOptions.ADDCACHE);
            if (!(obj instanceof Boolean) || !((Boolean)obj).booleanValue()) continue;
            cache = true;
            break;
        }
        Context ctx = this.qc.context;
        MainOptions mopts = ctx.options;
        StaticOptions sopts = ctx.soptions;
        try {
            this.data = cache ? CreateDB.create(sopts.randomDbName(name), Parser.emptyParser(mopts), ctx, mopts) : new MemData(mopts);
            this.data.startUpdate(mopts);
            long is = this.inputs.size();
            int i = 0;
            while ((long)i < is) {
                DataClip clip = this.data(name, i);
                this.inputs.set(i, null);
                try {
                    this.data.insert(this.data.meta.size, -1, clip);
                }
                finally {
                    DropDB.drop(clip.data, sopts);
                }
                ++i;
            }
            this.data.finishUpdate(mopts);
        }
        catch (IOException ex) {
            throw QueryError.IOERR_X.get(this.info, ex);
        }
    }

    public void finish() {
        if (this.data != null) {
            DropDB.drop(this.data, this.qc.context.soptions);
        }
    }

    private DataClip data(String name, int i) throws IOException {
        Context ctx = this.qc.context;
        StaticOptions soptions = ctx.soptions;
        NewInput input = this.inputs.get(i);
        MainOptions mopts = this.dboptions.get(i).assignTo(new MainOptions(this.qc.context.options, true));
        boolean addcache = mopts.get(MainOptions.ADDCACHE);
        ANode node = input.node;
        if (node != null) {
            if (node.type != NodeType.DOC) {
                node = new FDoc(name).add(node);
            }
            MemData mdata = (MemData)node.dbNodeCopy(mopts, this.qc).data();
            mdata.update(0, 0, Token.token(input.path));
            return new DataClip(mdata);
        }
        String dbpath = soptions.randomDbName(name);
        Parser parser = new DirParser(input.io, mopts, new IOFile(dbpath)).target(input.path);
        return (addcache ? new DiskBuilder(dbpath, parser, soptions, mopts) : new MemBuilder(name, parser)).dataClip();
    }
}

