/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.up.atomic;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.basex.data.Data;
import org.basex.data.DataClip;
import org.basex.query.up.atomic.BasicUpdate;
import org.basex.query.up.atomic.Delete;
import org.basex.query.up.atomic.Insert;
import org.basex.query.up.atomic.InsertAttr;
import org.basex.query.up.atomic.Rename;
import org.basex.query.up.atomic.Replace;
import org.basex.query.up.atomic.StructuralUpdate;
import org.basex.query.up.atomic.UpdateValue;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.hash.IntSet;

public final class AtomicUpdateCache {
    private final List<StructuralUpdate> struct = new ArrayList<StructuralUpdate>(1);
    private final List<BasicUpdate> val = new ArrayList<BasicUpdate>(1);
    private BasicUpdate recent;
    private BasicUpdate recentStruct;
    public final Data data;

    public AtomicUpdateCache(Data data) {
        this.data = data;
    }

    public void addDelete(int pre) {
        this.considerAtomic(Delete.getInstance(this.data, pre), false);
    }

    public void addInsert(int pre, int par, DataClip clip) {
        this.considerAtomic(clip.data.kind(clip.start) == 3 ? InsertAttr.getInstance(pre, par, clip) : Insert.getInstance(pre, par, clip), false);
    }

    public void addReplace(int pre, DataClip clip) {
        this.considerAtomic(Replace.getInstance(this.data, pre, clip), false);
    }

    public void addRename(int pre, byte[] name, byte[] uri) {
        this.considerAtomic(Rename.getInstance(this.data, pre, name, uri), false);
    }

    public void addUpdateValue(int pre, byte[] value) {
        this.considerAtomic(UpdateValue.getInstance(this.data, pre, value), false);
    }

    public void clear() {
        this.struct.clear();
        this.val.clear();
        this.recent = null;
        this.recentStruct = null;
    }

    private void considerAtomic(BasicUpdate candidate, boolean slack) {
        if (this.recent == null) {
            this.recent = candidate;
            if (this.recent instanceof StructuralUpdate) {
                this.recentStruct = candidate;
            }
            return;
        }
        if (candidate instanceof StructuralUpdate && this.recentStruct != null) {
            ((StructuralUpdate)candidate).accumulatedShifts += this.recentStruct.accumulatedShifts();
        }
        if (slack) {
            this.add(candidate, false);
        } else {
            AtomicUpdateCache.check(this.recent, candidate);
            if (this.treeAwareUpdates(this.recent, candidate)) {
                return;
            }
            BasicUpdate m = this.recent.merge(this.data, candidate);
            if (m != null) {
                this.add(m, true);
            } else {
                this.add(candidate, false);
            }
        }
    }

    private void add(BasicUpdate bu, boolean merged) {
        if (bu == null) {
            return;
        }
        if (!merged) {
            if (this.recent instanceof StructuralUpdate) {
                this.struct.add((StructuralUpdate)this.recent);
            } else {
                this.val.add(this.recent);
            }
        }
        this.recent = bu;
        if (bu instanceof StructuralUpdate) {
            this.recentStruct = bu;
        }
    }

    private void flush() {
        if (this.recent != null) {
            this.add(this.recent, false);
            this.recent = null;
            this.recentStruct = null;
        }
    }

    public int updatesSize() {
        this.flush();
        return this.struct.size() + this.val.size();
    }

    private static void check(BasicUpdate bu1, BasicUpdate bu2) {
        if (bu2.location < bu1.location) {
            throw Util.notExpected("Invalid order at location " + bu1.location, new Object[0]);
        }
        if (bu2.location == bu1.location) {
            if (bu2 instanceof Insert || bu2 instanceof InsertAttr) {
                if (bu1 instanceof Delete) {
                    throw Util.notExpected("Invalid sequence of delete, insert at location " + bu1.location, new Object[0]);
                }
                if (bu1 instanceof Replace) {
                    throw Util.notExpected("Invalid sequence of replace, insert at location " + bu1.location, new Object[0]);
                }
            }
            if (bu2.destructive() && bu1.destructive()) {
                throw Util.notExpected("Multiple deletes/replaces on node " + bu1.location, new Object[0]);
            }
            if (bu2 instanceof Rename && bu1 instanceof Rename) {
                throw Util.notExpected("Multiple renames on node " + bu1.location, new Object[0]);
            }
            if (bu2 instanceof UpdateValue && bu1 instanceof UpdateValue) {
                throw Util.notExpected("Multiple updates on node " + bu1.location, new Object[0]);
            }
            if (bu2.destructive() && !(bu1 instanceof StructuralUpdate)) {
                throw Util.notExpected("Invalid sequence of value update and destructive update at location " + bu1.location, new Object[0]);
            }
        }
    }

    private boolean treeAwareUpdates(BasicUpdate bu1, BasicUpdate bu2) {
        int pre;
        int fol;
        return bu1.destructive() && (bu2.location <= (fol = (pre = bu1.location) + this.data.size(pre, this.data.kind(pre))) && (bu2 instanceof Insert || bu2 instanceof InsertAttr) && bu2.parent >= pre && bu2.parent < fol || bu2.location < fol);
    }

    public void execute(boolean mergeTexts) {
        this.data.updateDists = false;
        this.applyUpdates();
        this.adjustDistances();
        if (mergeTexts) {
            this.resolveTextAdjacency();
        }
        this.data.updateDists = true;
        this.clear();
    }

    public void applyUpdates() {
        this.flush();
        for (BasicUpdate u : this.val) {
            u.apply(this.data);
        }
        int i = this.struct.size() - 1;
        while (i >= 0) {
            this.struct.get(i).apply(this.data);
            --i;
        }
    }

    private void adjustDistances() {
        boolean shifts = false;
        for (StructuralUpdate update : this.struct) {
            if (update.accumulatedShifts == 0) continue;
            shifts = true;
            break;
        }
        if (!shifts) {
            return;
        }
        IntSet updatedNodes = new IntSet();
        for (StructuralUpdate update : this.struct) {
            int pre = update.preOfAffectedNode + update.accumulatedShifts;
            while (pre < this.data.meta.size && !updatedNodes.contains(pre)) {
                int kind = this.data.kind(pre);
                this.data.dist(pre, kind, this.calculateNewDistance(pre, kind));
                updatedNodes.add(pre);
                pre += this.data.size(pre, kind);
            }
        }
    }

    private int calculateNewDistance(int pre, int kind) {
        int distanceBefore = this.data.dist(pre, kind);
        int preBefore = this.calculatePreValue(pre, true);
        if (kind == 0) {
            distanceBefore = preBefore + 1;
        }
        int parentBefore = preBefore - distanceBefore;
        int parentAfter = this.calculatePreValue(parentBefore, false);
        return pre - parentAfter;
    }

    public int calculatePreValue(int pre, boolean beforeUpdates) {
        int i = this.find(pre, beforeUpdates);
        if (i == -1) {
            return pre;
        }
        i = AtomicUpdateCache.refine(this.struct, i, beforeUpdates);
        int acm = this.struct.get((int)i).accumulatedShifts;
        return beforeUpdates ? pre - acm : pre + acm;
    }

    private int find(int pre, boolean beforeUpdates) {
        int left = 0;
        int right = this.struct.size() - 1;
        while (left <= right) {
            if (left == right) {
                if (AtomicUpdateCache.c(this.struct, left, beforeUpdates) <= pre) {
                    return left;
                }
                return -1;
            }
            if (right - left == 1) {
                if (AtomicUpdateCache.c(this.struct, right, beforeUpdates) <= pre) {
                    return right;
                }
                if (AtomicUpdateCache.c(this.struct, left, beforeUpdates) <= pre) {
                    return left;
                }
                return -1;
            }
            int middle = left + right >>> 1;
            int value = AtomicUpdateCache.c(this.struct, middle, beforeUpdates);
            if (value == pre) {
                return middle;
            }
            if (value > pre) {
                right = middle - 1;
                continue;
            }
            left = middle;
        }
        return -1;
    }

    private static int refine(List<StructuralUpdate> updates, int index, boolean beforeUpdates) {
        int u = index;
        int value = AtomicUpdateCache.c(updates, u++, beforeUpdates);
        int us = updates.size();
        while (u < us && AtomicUpdateCache.c(updates, u, beforeUpdates) == value) {
            ++u;
        }
        return u - 1;
    }

    private static int c(List<StructuralUpdate> updates, int index, boolean beforeUpdates) {
        StructuralUpdate u = updates.get(index);
        return u.preOfAffectedNode + (beforeUpdates ? u.accumulatedShifts : 0);
    }

    private void resolveTextAdjacency() {
        LinkedList<Delete> deletes = new LinkedList<Delete>();
        int smallestVisited = Integer.MAX_VALUE;
        int i = this.struct.size() - 1;
        while (i >= 0) {
            int followingNode;
            int beforeFollowingNode;
            StructuralUpdate u = this.struct.get(i);
            DataClip insseq = u.getInsertionData();
            int newLocation = u.location + u.accumulatedShifts - u.shifts;
            int beforeNewLocation = newLocation - 1;
            if (insseq != null && (beforeFollowingNode = (followingNode = newLocation + insseq.size()) - 1) < smallestVisited) {
                Delete del = this.mergeTextNodes(beforeFollowingNode);
                if (del != null) {
                    deletes.add(0, del);
                }
                smallestVisited = beforeFollowingNode;
            }
            if (beforeNewLocation < smallestVisited) {
                Delete del = this.mergeTextNodes(beforeNewLocation);
                if (del != null) {
                    deletes.add(0, del);
                }
                smallestVisited = beforeNewLocation;
            }
            --i;
        }
        AtomicUpdateCache auc = new AtomicUpdateCache(this.data);
        for (Delete delete : deletes) {
            auc.considerAtomic(delete, true);
        }
        deletes.clear();
        auc.applyUpdates();
        auc.adjustDistances();
        auc.clear();
    }

    private Delete mergeTextNodes(int pre) {
        int s = this.data.meta.size;
        int b = pre + 1;
        if (pre >= s || b >= s || pre < 0 || b < 0) {
            return null;
        }
        if (this.data.kind(pre) != 2 || this.data.kind(b) != 2) {
            return null;
        }
        if (this.data.parent(pre, 2) != this.data.parent(b, 2)) {
            return null;
        }
        UpdateValue.getInstance(this.data, pre, Token.concat(this.data.text(pre, true), this.data.text(b, true))).apply(this.data);
        return Delete.getInstance(this.data, b);
    }
}

