/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.xslt;

import java.io.IOException;
import java.io.PrintStream;
import java.util.HashMap;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.basex.io.IO;
import org.basex.io.IOContent;
import org.basex.io.out.ArrayOutput;
import org.basex.io.serial.SerializerMode;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryIOException;
import org.basex.query.func.xslt.XsltFn;
import org.basex.query.value.item.Item;
import org.basex.query.value.node.ANode;
import org.basex.query.value.node.DBNode;
import org.basex.util.InputInfo;
import org.basex.util.Prop;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.options.BooleanOption;
import org.basex.util.options.Options;

public class XsltTransform
extends XsltFn {
    @Override
    public Item item(QueryContext qc, InputInfo ii) throws QueryException {
        try {
            return new DBNode(new IOContent(this.transform(qc)));
        }
        catch (IOException ex) {
            throw QueryError.IOERR_X.get(this.info, ex);
        }
    }

    final byte[] transform(QueryContext qc) throws QueryException {
        this.checkCreate(qc);
        IO in = this.read(0, qc);
        IO xsl = this.read(1, qc);
        Options opts = this.toOptions(2, new Options(), qc);
        XsltOptions xopts = this.toOptions(3, new XsltOptions(), qc);
        PrintStream tmp = System.err;
        ArrayOutput ao = new ArrayOutput();
        try {
            System.setErr(new PrintStream(ao));
            byte[] byArray = XsltTransform.transform(in, xsl, opts.free(), xopts);
            return byArray;
        }
        catch (TransformerException ex) {
            Util.debug(ex);
            throw QueryError.XSLT_ERROR_X.get(this.info, new Object[]{Token.trim(Token.utf8(ao.finish(), Prop.ENCODING))});
        }
        finally {
            System.setErr(tmp);
        }
    }

    private IO read(int i, QueryContext qc) throws QueryException {
        Item item = this.toNodeOrAtomItem(i, qc);
        if (item instanceof ANode) {
            try {
                IOContent io = new IOContent(item.serialize(SerializerMode.NOINDENT.get()).finish());
                io.name(Token.string(((ANode)item).baseURI()));
                return io;
            }
            catch (QueryIOException e) {
                e.getCause(this.info);
            }
        }
        if (item.type.isStringOrUntyped()) {
            return this.checkPath(this.toToken(item));
        }
        throw QueryError.STRNOD_X_X.get(this.info, item.type, item);
    }

    private static byte[] transform(IO in, IO xsl, HashMap<String, String> par, XsltOptions xopts) throws TransformerException {
        Transformer tr = XsltTransform.transformer(xsl.streamSource(), xopts.get(XsltOptions.CACHE));
        par.forEach(tr::setParameter);
        ArrayOutput ao = new ArrayOutput();
        tr.transform(in.streamSource(), new StreamResult(ao));
        return ao.finish();
    }

    private static Transformer transformer(StreamSource ss, boolean cache) throws TransformerException {
        String key = cache ? ss.getSystemId() : null;
        Transformer tr = null;
        if (key != null) {
            tr = (Transformer)MAP.get(key);
        }
        if (tr == null) {
            tr = TransformerFactory.newInstance().newTransformer(ss);
        }
        if (key != null) {
            MAP.put(key, tr);
        }
        return tr;
    }

    public static final class XsltOptions
    extends Options {
        public static final BooleanOption CACHE = new BooleanOption("cache", false);
    }
}

