/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.unit;

import java.io.IOException;
import java.util.ArrayList;
import org.basex.core.Context;
import org.basex.core.jobs.Job;
import org.basex.io.IO;
import org.basex.io.IOFile;
import org.basex.query.func.unit.Constants;
import org.basex.query.func.unit.Unit;
import org.basex.query.value.node.FElem;
import org.basex.util.Performance;

public final class Suite {
    public int failures;
    public int errors;
    public int skipped;
    public int tests;

    public FElem test(IOFile root, Context ctx, Job job) throws IOException {
        ArrayList<IOFile> files = new ArrayList<IOFile>();
        Performance perf = new Performance();
        FElem suites = new FElem(Constants.TESTSUITES);
        if (root.isDir()) {
            for (String path : root.descendants()) {
                IOFile file = new IOFile(root, path);
                if (!file.hasSuffix(IO.XQSUFFIXES)) continue;
                files.add(file);
            }
        } else {
            files.add(root);
        }
        for (IOFile file : files) {
            Unit unit = new Unit(file, ctx, job);
            unit.test(suites);
            this.errors += unit.errors;
            this.failures += unit.failures;
            this.skipped += unit.skipped;
            this.tests += unit.tests;
        }
        suites.add(Constants.TIME, Unit.time(perf));
        return suites;
    }
}

